/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.commondatamodel.objectmodel.persistence.modeljson;

import com.microsoft.commondatamodel.objectmodel.cdm.CdmCorpusContext;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmTraitDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmTraitReference;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmTypeAttributeDefinition;
import com.microsoft.commondatamodel.objectmodel.enums.CdmDataFormat;
import com.microsoft.commondatamodel.objectmodel.enums.CdmObjectType;
import com.microsoft.commondatamodel.objectmodel.enums.CdmPropertyName;
import com.microsoft.commondatamodel.objectmodel.persistence.modeljson.ExtensionHelper;
import com.microsoft.commondatamodel.objectmodel.persistence.modeljson.Utils;
import com.microsoft.commondatamodel.objectmodel.persistence.modeljson.types.Attribute;
import com.microsoft.commondatamodel.objectmodel.utilities.CopyOptions;
import com.microsoft.commondatamodel.objectmodel.utilities.ResolveOptions;
import com.microsoft.commondatamodel.objectmodel.utilities.StringUtils;
import com.microsoft.commondatamodel.objectmodel.utilities.TraitToPropertyMap;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public class TypeAttributePersistence {
    public static CompletableFuture<CdmTypeAttributeDefinition> fromData(CdmCorpusContext ctx, Attribute obj, List<CdmTraitDefinition> extensionTraitDefList, List<CdmTraitDefinition> localExtensionTraitDefList) {
        CdmTypeAttributeDefinition attribute = (CdmTypeAttributeDefinition)ctx.getCorpus().makeObject(CdmObjectType.TypeAttributeDef, obj.getName());
        attribute.updateDataFormat(TypeAttributePersistence.dataTypeFromData(obj.getDataType()));
        if (!StringUtils.isNullOrTrimEmpty(obj.getDescription())) {
            attribute.updateDescription(obj.getDescription());
        }
        if (obj.isHidden() != null && obj.isHidden().booleanValue()) {
            CdmTraitReference isHiddenTrait = (CdmTraitReference)ctx.getCorpus().makeObject(CdmObjectType.TraitRef, "is.hidden");
            isHiddenTrait.setFromProperty(true);
            attribute.getAppliedTraits().add(isHiddenTrait);
        }
        return Utils.processAnnotationsFromData(ctx, obj, attribute.getAppliedTraits()).thenCompose(v -> {
            ExtensionHelper.processExtensionFromJson(ctx, obj, attribute.getAppliedTraits(), extensionTraitDefList, localExtensionTraitDefList);
            return CompletableFuture.completedFuture(attribute);
        });
    }

    public static CompletableFuture<Attribute> toData(CdmTypeAttributeDefinition instance, ResolveOptions resOpt, CopyOptions options) {
        Attribute attribute = new Attribute();
        attribute.setName(instance.getName());
        attribute.setDataType(TypeAttributePersistence.dataTypeToData(instance.fetchDataFormat()));
        attribute.setDescription((String)instance.fetchProperty(CdmPropertyName.DESCRIPTION));
        Utils.processTraitsAndAnnotationsToData(instance.getCtx(), attribute, instance.getAppliedTraits());
        TraitToPropertyMap t2pm = new TraitToPropertyMap(instance);
        CdmTraitReference isHiddenTrait = t2pm.fetchTraitReferenceName("is.hidden");
        if (isHiddenTrait != null) {
            attribute.setHidden(true);
        }
        return CompletableFuture.completedFuture(attribute);
    }

    private static CdmDataFormat dataTypeFromData(String dataType) {
        switch (dataType.toLowerCase()) {
            case "string": {
                return CdmDataFormat.String;
            }
            case "int64": {
                return CdmDataFormat.Int64;
            }
            case "double": {
                return CdmDataFormat.Double;
            }
            case "date": {
                return CdmDataFormat.Date;
            }
            case "time": {
                return CdmDataFormat.Time;
            }
            case "datetime": {
                return CdmDataFormat.DateTime;
            }
            case "datetimeoffset": {
                return CdmDataFormat.DateTimeOffset;
            }
            case "decimal": {
                return CdmDataFormat.Decimal;
            }
            case "boolean": {
                return CdmDataFormat.Boolean;
            }
            case "guid": {
                return CdmDataFormat.Guid;
            }
            case "json": {
                return CdmDataFormat.Json;
            }
        }
        return null;
    }

    private static String dataTypeToData(CdmDataFormat dataType) {
        switch (dataType) {
            case Int16: 
            case Int32: 
            case Int64: {
                return "int64";
            }
            case Float: 
            case Double: {
                return "double";
            }
            case Char: 
            case String: {
                return "string";
            }
            case Guid: {
                return "guid";
            }
            case Binary: {
                return "boolean";
            }
            case Time: {
                return "time";
            }
            case Date: {
                return "date";
            }
            case DateTime: {
                return "dateTime";
            }
            case DateTimeOffset: {
                return "dateTimeOffset";
            }
            case Boolean: {
                return "boolean";
            }
            case Decimal: {
                return "decimal";
            }
            case Json: {
                return "json";
            }
        }
        return "unclassified";
    }
}

