/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.commondatamodel.objectmodel.resolvedmodel;

import com.google.common.base.Strings;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmParameterDefinition;
import com.microsoft.commondatamodel.objectmodel.utilities.CdmException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@Deprecated
public class ParameterCollection {
    List<CdmParameterDefinition> sequence;
    Map<String, CdmParameterDefinition> lookup;
    Map<CdmParameterDefinition, Integer> ordinals;

    public ParameterCollection(ParameterCollection prior) {
        if (prior == null) {
            this.setSequence(new ArrayList<CdmParameterDefinition>());
            this.setLookup(new LinkedHashMap<String, CdmParameterDefinition>());
            this.setOrdinals(new LinkedHashMap<CdmParameterDefinition, Integer>());
        } else {
            this.setSequence((List<CdmParameterDefinition>)(prior.getSequence() != null ? new ArrayList<CdmParameterDefinition>(prior.getSequence()) : new ArrayList()));
            this.setLookup((Map<String, CdmParameterDefinition>)(prior.getLookup() != null ? new LinkedHashMap<String, CdmParameterDefinition>(prior.getLookup()) : new LinkedHashMap()));
            this.setOrdinals((Map<CdmParameterDefinition, Integer>)(prior.getOrdinals() != null ? new LinkedHashMap<CdmParameterDefinition, Integer>(prior.getOrdinals()) : new LinkedHashMap()));
        }
    }

    public void add(CdmParameterDefinition element) throws CdmException {
        String name = element.getName();
        if (!Strings.isNullOrEmpty((String)name)) {
            if (this.lookup.containsKey(name)) {
                throw new CdmException("Duplicate parameter name " + name);
            }
            this.lookup.put(name, element);
        }
        this.ordinals.put(element, this.sequence.size());
        this.sequence.add(element);
    }

    public CdmParameterDefinition resolveParameter(int ordinal, String name) throws CdmException {
        if (!Strings.isNullOrEmpty((String)name)) {
            if (this.lookup.containsKey(name)) {
                return this.lookup.get(name);
            }
            throw new CdmException("There is no parameter named " + name);
        }
        if (ordinal >= this.sequence.size()) {
            throw new CdmException("Too many arguments supplied");
        }
        return this.sequence.get(ordinal);
    }

    public int fetchParameterIndex(String paramName) {
        return this.ordinals.get(this.lookup.get(paramName));
    }

    public List<CdmParameterDefinition> getSequence() {
        return this.sequence;
    }

    void setSequence(List<CdmParameterDefinition> sequence) {
        this.sequence = sequence;
    }

    Map<String, CdmParameterDefinition> getLookup() {
        return this.lookup;
    }

    void setLookup(Map<String, CdmParameterDefinition> lookup) {
        this.lookup = lookup;
    }

    Map<CdmParameterDefinition, Integer> getOrdinals() {
        return this.ordinals;
    }

    void setOrdinals(Map<CdmParameterDefinition, Integer> ordinals) {
        this.ordinals = ordinals;
    }
}

