/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.commondatamodel.objectmodel.resolvedmodel;

import com.fasterxml.jackson.databind.JsonNode;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmArgumentDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmTraitDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.StringSpewCatcher;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.ParameterCollection;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.ParameterValue;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.ResolvedTrait;
import com.microsoft.commondatamodel.objectmodel.utilities.ResolveOptions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

@Deprecated
public class ResolvedTraitSet {
    private List<ResolvedTrait> set;
    private Boolean hasElevated;
    private ResolveOptions resOpt;
    private Map<CdmTraitDefinition, ResolvedTrait> lookupByTrait;

    public ResolvedTraitSet(ResolveOptions resOpt) {
        this.resOpt = resOpt.copy();
        this.set = new ArrayList<ResolvedTrait>();
        this.lookupByTrait = new LinkedHashMap<CdmTraitDefinition, ResolvedTrait>();
        this.hasElevated = false;
    }

    public ResolvedTraitSet merge(ResolvedTrait toMerge, Boolean copyOnWrite) {
        ResolvedTraitSet traitSetResult = this;
        CdmTraitDefinition trait = toMerge.getTrait();
        List<Object> av = null;
        List<Boolean> wasSet = null;
        if (toMerge.getParameterValues() != null) {
            av = toMerge.getParameterValues().getValues();
            wasSet = toMerge.getParameterValues().getWasSet();
        }
        if (!this.getHasElevated().booleanValue()) {
            this.setHasElevated(trait.getElevated() == null ? false : trait.getElevated());
        }
        if (traitSetResult.getLookupByTrait().containsKey(trait)) {
            ResolvedTrait rtOld = traitSetResult.getLookupByTrait().get(trait);
            List<Object> avOld = null;
            if (rtOld.getParameterValues() != null) {
                avOld = rtOld.getParameterValues().getValues();
            }
            if (av != null && avOld != null) {
                for (int i = 0; i < av.size(); ++i) {
                    if (avOld.get(i) != null && avOld.get(i) instanceof JsonNode) {
                        avOld.set(i, ((JsonNode)avOld.get(i)).asText());
                    }
                    try {
                        if (av.get(i) == avOld.get(i)) continue;
                        if (copyOnWrite.booleanValue()) {
                            traitSetResult = traitSetResult.shallowCopyWithException(trait);
                            rtOld = traitSetResult.getLookupByTrait().get(trait);
                            avOld = rtOld.getParameterValues().getValues();
                            copyOnWrite = false;
                        }
                        avOld.set(i, ParameterValue.fetchReplacementValue(this.resOpt, avOld.get(i), av.get(i), wasSet.get(i)));
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        } else {
            if (copyOnWrite.booleanValue()) {
                traitSetResult = traitSetResult.shallowCopy();
            }
            toMerge = toMerge.copy();
            traitSetResult.getSet().add(toMerge);
            traitSetResult.getLookupByTrait().put(trait, toMerge);
        }
        return traitSetResult;
    }

    ResolvedTraitSet mergeSet(ResolvedTraitSet toMerge) {
        return this.mergeSet(toMerge, false);
    }

    public ResolvedTraitSet mergeSet(ResolvedTraitSet toMerge, Boolean elevatedOnly) {
        Boolean copyOnWrite = true;
        ResolvedTraitSet traitSetResult = this;
        if (toMerge != null) {
            int l = toMerge.getSet().size();
            for (int i = 0; i < l; ++i) {
                ResolvedTraitSet traitSetMerge;
                ResolvedTrait rt = toMerge.getSet().get(i);
                if (elevatedOnly.booleanValue() && (rt.getTrait().getElevated() == null || !rt.getTrait().getElevated().booleanValue()) || (traitSetMerge = traitSetResult.merge(rt, copyOnWrite)) == traitSetResult) continue;
                traitSetResult = traitSetMerge;
                copyOnWrite = false;
            }
        }
        return traitSetResult;
    }

    public ResolvedTrait get(CdmTraitDefinition trait) {
        if (this.getLookupByTrait().containsKey(trait)) {
            return this.getLookupByTrait().get(trait);
        }
        return null;
    }

    public ResolvedTrait find(ResolveOptions resOpt, String traitName) {
        for (ResolvedTrait rt : this.set) {
            if (!rt.getTrait().isDerivedFrom(traitName, resOpt)) continue;
            return rt;
        }
        return null;
    }

    public ResolvedTraitSet deepCopy() {
        ResolvedTraitSet copy = new ResolvedTraitSet(this.resOpt);
        List<ResolvedTrait> newSet = copy.getSet();
        for (ResolvedTrait rt : this.set) {
            rt = rt.copy();
            newSet.add(rt);
            copy.getLookupByTrait().put(rt.getTrait(), rt);
        }
        copy.setHasElevated(this.hasElevated);
        return copy;
    }

    private ResolvedTraitSet shallowCopyWithException(CdmTraitDefinition just) {
        ResolvedTraitSet copy = new ResolvedTraitSet(this.resOpt);
        List<ResolvedTrait> newSet = copy.getSet();
        for (ResolvedTrait rt : this.set) {
            if (rt.getTrait() == just) {
                rt = rt.copy();
            }
            newSet.add(rt);
            copy.getLookupByTrait().put(rt.getTrait(), rt);
        }
        copy.setHasElevated(this.hasElevated);
        return copy;
    }

    ResolvedTraitSet shallowCopy() {
        ResolvedTraitSet copy = new ResolvedTraitSet(this.resOpt);
        if (this.set != null) {
            List<ResolvedTrait> newSet = copy.getSet();
            for (ResolvedTrait rt : this.set) {
                newSet.add(rt);
                copy.getLookupByTrait().put(rt.getTrait(), rt);
            }
        }
        copy.setHasElevated(this.hasElevated);
        return copy;
    }

    Set<String> collectTraitNames() {
        LinkedHashSet<String> collection = new LinkedHashSet<String>();
        if (this.set != null) {
            for (ResolvedTrait rt : this.set) {
                rt.collectTraitNames(this.resOpt, collection);
            }
        }
        return collection;
    }

    public void setParameterValueFromArgument(CdmTraitDefinition trait, CdmArgumentDefinition arg) {
        ResolvedTrait resTrait = this.get(trait);
        if (resTrait != null && resTrait.getParameterValues() != null) {
            List<Object> av = resTrait.getParameterValues().getValues();
            Object newVal = arg.getValue();
            int iParam = resTrait.getParameterValues().indexOf(arg.getParameterDef());
            av.set(iParam, ParameterValue.fetchReplacementValue(this.resOpt, av.get(iParam), newVal, true));
            resTrait.getParameterValues().getWasSet().set(iParam, true);
        }
    }

    public ResolvedTraitSet setTraitParameterValue(ResolveOptions resOpt, CdmTraitDefinition toTrait, String paramName, Object value) {
        ResolvedTraitSet altered = this.shallowCopyWithException(toTrait);
        altered.get(toTrait).getParameterValues().setParameterValue(resOpt, paramName, value);
        return altered;
    }

    ResolvedTraitSet replaceTraitParameterValue(ResolveOptions resOpt, String toTrait, String paramName, Object valueWhen, Object valueNew) {
        ResolvedTraitSet traitSetResult = this;
        for (int i = 0; i < traitSetResult.getSet().size(); ++i) {
            ResolvedTrait rt = traitSetResult.getSet().get(i);
            if (!rt.getTrait().isDerivedFrom(toTrait, resOpt) || rt.getParameterValues() == null) continue;
            ParameterCollection pc = rt.getParameterValues().getPc();
            List<Object> av = rt.getParameterValues().getValues();
            int idx = pc.fetchParameterIndex(paramName);
            if (idx < 0 || !Objects.equals(av.get(idx), valueWhen)) continue;
            traitSetResult = this.shallowCopyWithException(rt.getTrait());
            rt = traitSetResult.getSet().get(i);
            av = rt.getParameterValues().getValues();
            av.set(idx, ParameterValue.fetchReplacementValue(resOpt, av.get(idx), valueNew, true));
            break;
        }
        return traitSetResult;
    }

    public void spew(ResolveOptions resOpt, StringSpewCatcher to, String indent, Boolean nameSort) throws IOException {
        ArrayList<ResolvedTrait> list = new ArrayList<ResolvedTrait>(this.set);
        if (nameSort.booleanValue()) {
            list.sort((l, r) -> StringUtils.compareIgnoreCase((String)l.getTraitName(), (String)r.getTraitName(), (boolean)true));
        }
        for (ResolvedTrait trait : list) {
            trait.spew(resOpt, to, indent);
        }
    }

    public List<ResolvedTrait> getSet() {
        return this.set;
    }

    public void setSet(List<ResolvedTrait> set) {
        this.set = set;
    }

    public Boolean getHasElevated() {
        return this.hasElevated;
    }

    public void setHasElevated(Boolean hasElevated) {
        this.hasElevated = hasElevated;
    }

    public ResolveOptions getResOpt() {
        return this.resOpt;
    }

    void setResOpt(ResolveOptions resOpt) {
        this.resOpt = resOpt;
    }

    public int getSize() {
        return this.set != null ? this.set.size() : 0;
    }

    public ResolvedTrait getFirst() {
        return this.set != null ? this.set.get(0) : null;
    }

    public Map<CdmTraitDefinition, ResolvedTrait> getLookupByTrait() {
        return this.lookupByTrait;
    }

    public void setLookupByTrait(Map<CdmTraitDefinition, ResolvedTrait> lookupByTrait) {
        this.lookupByTrait = lookupByTrait;
    }

    public class CaseAgnosticTraitNameComparator
    implements Comparator<ResolvedTrait> {
        @Override
        public int compare(ResolvedTrait l, ResolvedTrait r) {
            return l.getTraitName().toLowerCase().compareTo(r.getTraitName().toLowerCase());
        }
    }
}

