/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.commondatamodel.objectmodel.cdm;

import com.microsoft.commondatamodel.objectmodel.cdm.CdmArgumentDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmCollection;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmCorpusContext;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmTraitReference;
import com.microsoft.commondatamodel.objectmodel.enums.CdmObjectType;
import java.util.List;
import java.util.Objects;

public class CdmArgumentCollection
extends CdmCollection<CdmArgumentDefinition> {
    public CdmArgumentCollection(CdmCorpusContext ctx, CdmTraitReference owner) {
        super(ctx, owner, CdmObjectType.ArgumentDef);
    }

    @Override
    public CdmTraitReference getOwner() {
        return (CdmTraitReference)super.getOwner();
    }

    @Override
    public CdmArgumentDefinition add(CdmArgumentDefinition cdmArgumentDefinition) {
        this.getOwner().resolvedArguments = false;
        return super.add(cdmArgumentDefinition);
    }

    public CdmArgumentDefinition add(String name, Object value) {
        CdmArgumentDefinition argument = (CdmArgumentDefinition)((Object)super.add(name));
        argument.setValue(value);
        this.getOwner().resolvedArguments = false;
        return argument;
    }

    @Override
    public void add(int index, CdmArgumentDefinition arg) {
        this.getOwner().setResolvedArguments(false);
        super.add(index, arg);
    }

    @Override
    public void addAll(List<CdmArgumentDefinition> argumentList) {
        argumentList.forEach(this::add);
    }

    public Object fetchValue(String name) {
        for (CdmArgumentDefinition argument : this.getAllItems()) {
            if (!Objects.equals(argument.getName(), name)) continue;
            return argument.getValue();
        }
        if (this.getAllItems().size() == 1 && ((CdmArgumentDefinition)this.getAllItems().get(0)).getName() == null) {
            return ((CdmArgumentDefinition)this.getAllItems().get(0)).getValue();
        }
        return null;
    }

    public void updateArgument(String name, Object value) {
        this.makeDocumentDirty();
        for (CdmArgumentDefinition argument : this.getAllItems()) {
            if (!Objects.equals(argument.getName(), name)) continue;
            argument.setValue(value);
            return;
        }
        this.add(name, value);
    }
}

