/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.commondatamodel.objectmodel.cdm;

import com.microsoft.commondatamodel.objectmodel.cdm.CdmAttributeContextReference;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmCollection;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmCorpusContext;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmDocumentDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmObject;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmObjectBase;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmObjectDefinitionBase;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmObjectReference;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmObjectReferenceBase;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmTraitReference;
import com.microsoft.commondatamodel.objectmodel.enums.CdmAttributeContextType;
import com.microsoft.commondatamodel.objectmodel.enums.CdmLogCode;
import com.microsoft.commondatamodel.objectmodel.enums.CdmObjectType;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.ResolvedAttribute;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.ResolvedAttributeSet;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.ResolvedAttributeSetBuilder;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.ResolvedTraitSet;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.ResolvedTraitSetBuilder;
import com.microsoft.commondatamodel.objectmodel.utilities.AttributeContextParameters;
import com.microsoft.commondatamodel.objectmodel.utilities.CopyOptions;
import com.microsoft.commondatamodel.objectmodel.utilities.ResolveOptions;
import com.microsoft.commondatamodel.objectmodel.utilities.StringUtils;
import com.microsoft.commondatamodel.objectmodel.utilities.VisitCallback;
import com.microsoft.commondatamodel.objectmodel.utilities.logger.Logger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.stream.Collectors;

public class CdmAttributeContext
extends CdmObjectDefinitionBase {
    private String tag = CdmAttributeContext.class.getSimpleName();
    private CdmAttributeContextType type;
    private CdmCollection<CdmObject> contents;
    private String name;
    private Integer lowestOrder;
    private CdmObjectReference parent;
    private CdmObjectReference definition;
    private String declaredPath;
    private String atCorpusPath;
    private CdmCollection<CdmAttributeContextReference> lineage;

    public CdmAttributeContext(CdmCorpusContext ctx, String name) {
        super(ctx);
        this.setObjectType(CdmObjectType.AttributeContextDef);
        this.name = name;
        this.setAtCorpusPath(name);
        this.contents = new CdmCollection(this.getCtx(), this, this.getObjectType());
    }

    public final CdmAttributeContextType getType() {
        return this.type;
    }

    public final void setType(CdmAttributeContextType value) {
        this.type = value;
    }

    @Deprecated
    public static CdmAttributeContext createChildUnder(ResolveOptions resOpt, AttributeContextParameters acp) {
        if (acp == null) {
            return null;
        }
        if (acp.getType() == CdmAttributeContextType.PassThrough) {
            return acp.getUnder();
        }
        ResolveOptions resOptCopy = resOpt.copy();
        resOptCopy.setSaveResolutionsOnCopy(true);
        CdmObjectReference definition = null;
        ResolvedTraitSet rtsApplied = null;
        if (acp.getRegarding() != null) {
            definition = ((CdmObjectBase)acp.getRegarding()).createPortableReference(resOptCopy);
            if (acp.isIncludeTraits()) {
                rtsApplied = acp.getRegarding().fetchResolvedTraits(resOptCopy);
            }
        }
        CdmAttributeContext underChild = (CdmAttributeContext)acp.getUnder().getCtx().getCorpus().makeObject(CdmObjectType.AttributeContextDef, acp.getName());
        underChild.setCtx(acp.getUnder().getCtx());
        underChild.setInDocument(acp.getUnder().getInDocument());
        underChild.setType(acp.getType());
        underChild.setDefinition(definition);
        if (rtsApplied != null && rtsApplied.getSet() != null) {
            rtsApplied.getSet().forEach(rt -> {
                CdmTraitReference traitRef = CdmObjectBase.resolvedTraitToTraitRef(resOptCopy, rt);
                underChild.getExhibitsTraits().add(traitRef);
            });
        }
        underChild.setParent(resOptCopy, acp.getUnder());
        if (resOptCopy.getMapOldCtxToNewCtx() != null) {
            resOptCopy.getMapOldCtxToNewCtx().put(underChild, underChild);
        }
        return underChild;
    }

    public CdmObject copyNode() {
        return this.copyNode(new ResolveOptions(this));
    }

    CdmObject copyNode(ResolveOptions resOpt) {
        CdmAttributeContext copy = new CdmAttributeContext(this.getCtx(), this.getName());
        copy.setType(this.type);
        copy.setInDocument(resOpt.getWrtDoc());
        if (this.getParent() != null) {
            copy.setParent(new CdmAttributeContextReference(this.getCtx(), null));
            copy.getParent().setExplicitReference(this.getParent().getExplicitReference());
        }
        if (this.getDefinition() != null) {
            copy.setDefinition((CdmObjectReference)this.getDefinition().copy(resOpt));
            copy.getDefinition().setOwner(this.getDefinition().getOwner());
        }
        copy.setContents(new CdmCollection<CdmObject>(this.getCtx(), copy, CdmObjectType.AttributeRef));
        if (this.getLineage() != null) {
            this.getLineage().forEach(lin -> copy.addLineage(lin.getExplicitReference(), false));
        }
        this.copyDef(resOpt, copy);
        if (resOpt.getMapOldCtxToNewCtx() != null) {
            resOpt.getMapOldCtxToNewCtx().put(copy, copy);
        }
        return copy;
    }

    CdmAttributeContext copyAttributeContextTree(ResolveOptions resOpt, CdmAttributeContext newNode) {
        resOpt.getMapOldCtxToNewCtx().put(this, newNode);
        for (CdmObject child : this.contents) {
            if (!(child instanceof CdmAttributeContext)) continue;
            CdmAttributeContext childAsAttributeContext = (CdmAttributeContext)child;
            CdmAttributeContext newChild = (CdmAttributeContext)childAsAttributeContext.copyNode(resOpt);
            newNode.getContents().allItems.add(newChild);
            childAsAttributeContext.copyAttributeContextTree(resOpt, newChild);
        }
        return newNode;
    }

    public final CdmObjectReference getParent() {
        return this.parent;
    }

    public final void setParent(CdmObjectReference value) {
        this.parent = value;
    }

    public final CdmObjectReference getDefinition() {
        return this.definition;
    }

    public final void setDefinition(CdmObjectReference value) {
        this.definition = value;
    }

    public final CdmCollection<CdmObject> getContents() {
        return this.contents;
    }

    public void setContents(CdmCollection<CdmObject> value) {
        this.contents = value;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    public final void setName(String value) {
        this.name = value;
    }

    final Integer getLowestOrder() {
        return this.lowestOrder;
    }

    final void setLowestOrder(Integer value) {
        this.lowestOrder = value;
    }

    @Override
    public boolean isDerivedFrom(String baseDef, ResolveOptions resOpt) {
        return false;
    }

    public final CdmCollection<CdmAttributeContextReference> getLineage() {
        return this.lineage;
    }

    public void setLineage(CdmCollection<CdmAttributeContextReference> value) {
        this.lineage = value;
    }

    @Deprecated
    public CdmAttributeContextReference setLineage(CdmObject objLineage) {
        this.setLineage(new CdmCollection<CdmAttributeContextReference>(this.getCtx(), this, CdmObjectType.AttributeContextRef));
        return this.addLineage(objLineage);
    }

    @Override
    public boolean visit(String pathFrom, VisitCallback preChildren, VisitCallback postChildren) {
        String path = "";
        if (this.getCtx() != null && this.getCtx().getCorpus() != null && !this.getCtx().getCorpus().blockDeclaredPathChanges && StringUtils.isNullOrTrimEmpty(path = this.declaredPath)) {
            this.declaredPath = path = pathFrom + this.getName();
        }
        if (preChildren != null && preChildren.invoke(this, path)) {
            return false;
        }
        if (this.getParent() != null && this.getParent().visit(path + "/parent/", preChildren, postChildren)) {
            return true;
        }
        if (this.getDefinition() != null && this.getDefinition().visit(path + "/definition/", preChildren, postChildren)) {
            return true;
        }
        if (this.getContents() != null && CdmObjectBase.visitList(this.getContents(), path + "/", preChildren, postChildren)) {
            return true;
        }
        if (this.getLineage() != null && CdmObjectBase.visitList(this.getLineage(), path + "/lineage/", preChildren, postChildren)) {
            return true;
        }
        if (this.visitDef(path, preChildren, postChildren)) {
            return true;
        }
        return postChildren != null && postChildren.invoke(this, path);
    }

    @Override
    public boolean validate() {
        ArrayList<String> missingFields = new ArrayList<String>();
        if (StringUtils.isNullOrTrimEmpty(this.name)) {
            missingFields.add("name");
        }
        if (this.type == null) {
            missingFields.add("type");
        }
        if (missingFields.size() > 0) {
            Logger.error(this.getCtx(), this.tag, "validate", this.getAtCorpusPath(), CdmLogCode.ErrValdnIntegrityCheckFailure, this.atCorpusPath, String.join((CharSequence)", ", missingFields.parallelStream().map(s -> String.format("'%s'", s)).collect(Collectors.toList())));
            return false;
        }
        return true;
    }

    @Override
    public Object copyData(ResolveOptions resOpt, CopyOptions options) {
        return CdmObjectBase.copyData(this, resOpt, options, CdmAttributeContext.class);
    }

    @Override
    public CdmObject copy(ResolveOptions resOpt, CdmObject host) {
        CdmAttributeContext copy;
        if (resOpt == null) {
            resOpt = new ResolveOptions(this, this.getCtx().getCorpus().getDefaultResolutionDirectives());
        }
        if (host == null) {
            copy = (CdmAttributeContext)this.copyNode(resOpt);
        } else {
            copy = (CdmAttributeContext)host;
            copy.setCtx(this.getCtx());
            copy.setName(this.getName());
            copy.getContents().clear();
        }
        if (this.getParent() != null) {
            copy.setParent((CdmObjectReference)this.getParent().copy(resOpt));
        }
        if (this.contents != null && this.contents.size() > 0) {
            for (CdmObject cdmObject : this.contents) {
                copy.getContents().add(cdmObject.copy(resOpt));
            }
        }
        if (this.lineage != null && this.lineage.size() > 0) {
            for (CdmAttributeContextReference cdmAttributeContextReference : this.lineage) {
                copy.addLineage(cdmAttributeContextReference.getExplicitReference().copy(resOpt));
            }
        }
        return copy;
    }

    void setRelativePath(String rp) {
        this.declaredPath = rp;
    }

    private void setParent(ResolveOptions resOpt, CdmAttributeContext parent) {
        CdmObjectReferenceBase parentRef = (CdmObjectReferenceBase)this.getCtx().getCorpus().makeObject(CdmObjectType.AttributeContextRef, parent.getAtCorpusPath(), true);
        if (this.getName() != null) {
            this.setAtCorpusPath(parent.getAtCorpusPath() + "/" + this.getName());
        }
        parentRef.setExplicitReference(parent);
        parentRef.setInDocument(parent.getInDocument());
        parent.getContents().add(this);
        this.setParent(parentRef);
    }

    @Deprecated
    public CdmAttributeContextReference addLineage(CdmObject objLineage) {
        return this.addLineage(objLineage, true);
    }

    @Deprecated
    public CdmAttributeContextReference addLineage(CdmObject objLineage, boolean validate) {
        CdmAttributeContextReference refLineage;
        if (objLineage.getObjectType() == CdmObjectType.AttributeContextRef) {
            refLineage = (CdmAttributeContextReference)objLineage;
            objLineage = refLineage.getExplicitReference();
        } else if (objLineage.getObjectType() == CdmObjectType.AttributeContextDef) {
            CdmAttributeContext acLin = (CdmAttributeContext)objLineage;
            refLineage = (CdmAttributeContextReference)this.getCtx().getCorpus().makeObject(CdmObjectType.AttributeContextRef, acLin.getAtCorpusPath(), true);
            refLineage.setExplicitReference(acLin);
        } else {
            return null;
        }
        if (this.getLineage() == null) {
            this.setLineage(new CdmCollection<CdmAttributeContextReference>(this.getCtx(), this, CdmObjectType.AttributeContextRef));
        }
        if (refLineage.getExplicitReference().getId() == this.getId()) {
            return null;
        }
        this.getLineage().add(refLineage);
        return refLineage;
    }

    public static ResolveOptions prepareOptionsForResolveAttributes(ResolveOptions resOptSource) {
        ResolveOptions resOptCopy = resOptSource.copy();
        resOptCopy.setSaveResolutionsOnCopy(true);
        resOptCopy.setMapOldCtxToNewCtx(new HashMap<CdmAttributeContext, CdmAttributeContext>());
        return resOptCopy;
    }

    @Deprecated
    public static CdmAttributeContext getUnderContextForCacheContext(ResolveOptions resOpt, CdmCorpusContext ctx, AttributeContextParameters acpUsed) {
        if (acpUsed != null) {
            AttributeContextParameters acpCache = acpUsed.copy();
            CdmAttributeContext parentCtxForCache = new CdmAttributeContext(ctx, "cacheHolder");
            parentCtxForCache.setType(CdmAttributeContextType.PassThrough);
            acpCache.setUnder(parentCtxForCache);
            return CdmAttributeContext.createChildUnder(resOpt, acpCache);
        }
        return null;
    }

    @Deprecated
    public CdmAttributeContext getUnderContextFromCacheContext(ResolveOptions resOpt, AttributeContextParameters acpUsed) {
        if (acpUsed != null) {
            return CdmAttributeContext.createChildUnder(resOpt, acpUsed);
        }
        return null;
    }

    @Deprecated
    public boolean associateTreeCopyWithAttributes(ResolveOptions resOpt, ResolvedAttributeSet ras) {
        CdmAttributeContext cachedCtx = ras.getAttributeContext();
        if (cachedCtx.copyAttributeContextTree(resOpt, this) == null) {
            return false;
        }
        ras.setAttributeContext(this);
        this.fixResolveAttributeCtx(ras, resOpt);
        this.fixAttCtxNodeLineage(this, null, resOpt);
        return true;
    }

    @Deprecated
    public boolean finalizeAttributeContext(ResolveOptions resOpt, String pathStart, CdmDocumentDefinition docHome, CdmDocumentDefinition docFrom, String monikerForDocFrom) {
        return this.finalizeAttributeContext(resOpt, pathStart, docFrom, docHome, monikerForDocFrom, false);
    }

    @Deprecated
    public boolean finalizeAttributeContext(ResolveOptions resOpt, String pathStart, CdmDocumentDefinition docHome, CdmDocumentDefinition docFrom, String monikerForDocFrom, boolean finished) {
        LinkedHashMap<CdmDocumentDefinition, String> foundDocPaths = new LinkedHashMap<CdmDocumentDefinition, String>();
        if (!StringUtils.isNullOrTrimEmpty(monikerForDocFrom)) {
            monikerForDocFrom = String.format("%s/", monikerForDocFrom);
        }
        this.fixAttCtxNodePaths(this, pathStart, docHome, docFrom, foundDocPaths, resOpt, monikerForDocFrom);
        this.fixAndFinalizeAttCtxNodeLineage(this);
        if (finished) {
            resOpt.setSaveResolutionsOnCopy(false);
            resOpt.setMapOldCtxToNewCtx(null);
        }
        return true;
    }

    @Override
    @Deprecated
    public ResolvedAttributeSetBuilder constructResolvedAttributes(ResolveOptions resOpt) {
        return this.constructResolvedAttributes(resOpt, null);
    }

    @Override
    @Deprecated
    public ResolvedAttributeSetBuilder constructResolvedAttributes(ResolveOptions resOpt, CdmAttributeContext under) {
        return null;
    }

    @Override
    void constructResolvedTraits(ResolvedTraitSetBuilder rtsb, ResolveOptions resOpt) {
    }

    @Override
    public String getAtCorpusPath() {
        return this.atCorpusPath;
    }

    public void setAtCorpusPath(String atCorpusPath) {
        this.atCorpusPath = atCorpusPath;
    }

    private void fixResolveAttributeCtx(ResolvedAttributeSet rasSub, ResolveOptions resOpt) {
        for (ResolvedAttribute ra : rasSub.getSet()) {
            ra.setAttCtx(resOpt.getMapOldCtxToNewCtx().get(ra.getAttCtx()));
            if (!(ra.getTarget() instanceof ResolvedAttributeSet)) continue;
            ((ResolvedAttributeSet)ra.getTarget()).setAttributeContext(ra.getAttCtx());
            this.fixResolveAttributeCtx((ResolvedAttributeSet)ra.getTarget(), resOpt);
        }
    }

    private void fixAttCtxNodeLineage(CdmAttributeContext ac, CdmAttributeContext acParent, ResolveOptions resOpt) {
        if (ac == null) {
            return;
        }
        if (acParent != null && ac.getParent() != null && ac.getParent().getExplicitReference() != null) {
            ac.getParent().setExplicitReference(acParent);
        }
        if (ac.getLineage() != null && ac.getLineage().size() > 0) {
            ac.getLineage().forEach(lin -> {
                if (lin.getExplicitReference() != null) {
                    lin.setExplicitReference(resOpt.getMapOldCtxToNewCtx().get((CdmAttributeContext)lin.getExplicitReference()));
                }
            });
        }
        if (ac.getContents() == null || ac.getContents().isEmpty()) {
            return;
        }
        for (CdmObject subSub : ac.getContents()) {
            this.fixAttCtxNodeLineage((CdmAttributeContext)subSub, ac, resOpt);
        }
    }

    private void fixAttCtxNodePaths(CdmObject subItem, String pathFrom, CdmDocumentDefinition docHome, CdmDocumentDefinition docFrom, HashMap<CdmDocumentDefinition, String> foundDocPaths, ResolveOptions resOpt, String monikerForDocFrom) {
        CdmAttributeContext ac = (CdmAttributeContext)subItem;
        if (ac == null) {
            return;
        }
        ac.setInDocument(docHome);
        if (ac.getDefinition() != null) {
            ac.getDefinition().setInDocument(docHome);
            if (ac.getDefinition().getNamedReference() != null) {
                CdmDocumentDefinition docFromDef = ac.getDefinition().getExplicitReference().getInDocument();
                String pathBetweenDocs = foundDocPaths.get(docFromDef);
                if (pathBetweenDocs == null) {
                    pathBetweenDocs = docFrom.importPathToDoc(docFromDef);
                    if (pathBetweenDocs == null) {
                        pathBetweenDocs = "";
                    }
                    foundDocPaths.put(docFrom, pathBetweenDocs);
                }
                ((CdmObjectReferenceBase)ac.getDefinition()).localizePortableReference(resOpt, String.format("%s%s", monikerForDocFrom, pathBetweenDocs));
            }
        }
        if (ac.getParent() != null) {
            ac.getParent().setInDocument(docHome);
        }
        if (ac.getLineage() != null && ac.getLineage().size() > 0) {
            ac.getLineage().forEach(lin -> lin.setInDocument(docHome));
        }
        String divider = StringUtils.isNullOrEmpty(ac.getAtCorpusPath()) || !pathFrom.endsWith("/") ? "/" : "";
        ac.setAtCorpusPath(String.format("%s%s%s", pathFrom, divider, ac.getName()));
        if (ac.getContents() == null || ac.getContents().size() == 0) {
            return;
        }
        for (CdmObject subSub : ac.getContents()) {
            if (subSub.getObjectType() != CdmObjectType.AttributeContextDef) continue;
            this.fixAttCtxNodePaths(subSub, ac.getAtCorpusPath(), docHome, docFrom, foundDocPaths, resOpt, monikerForDocFrom);
        }
    }

    private void fixAndFinalizeAttCtxNodeLineage(CdmObject subItem) {
        CdmAttributeContext ac = (CdmAttributeContext)subItem;
        if (ac == null) {
            return;
        }
        if (ac.getParent() != null && ac.getParent().getExplicitReference() != null) {
            ac.getParent().setNamedReference(((CdmAttributeContext)ac.getParent().getExplicitReference()).getAtCorpusPath());
        }
        if (ac.getLineage() != null && ac.getLineage().size() > 0) {
            for (CdmAttributeContextReference lin : ac.getLineage()) {
                if (lin.getExplicitReference() == null) continue;
                lin.setNamedReference(((CdmAttributeContext)lin.getExplicitReference()).getAtCorpusPath());
            }
        }
        if (ac.getContents() == null || ac.getContents().size() == 0) {
            return;
        }
        for (CdmObject subSub : ac.getContents()) {
            this.fixAndFinalizeAttCtxNodeLineage(subSub);
        }
    }

    @Deprecated
    public Boolean validateLineage(ResolveOptions resOpt) {
        HashSet<CdmAttributeContext> attCtxInTree = new HashSet<CdmAttributeContext>();
        this.collectAllNodes(this, attCtxInTree);
        this.CheckLineage(this, attCtxInTree);
        return true;
    }

    private void collectAllNodes(CdmObject subItem, HashSet<CdmAttributeContext> attCtxInTree) {
        CdmAttributeContext ac = (CdmAttributeContext)subItem;
        if (ac == null) {
            return;
        }
        attCtxInTree.add(ac);
        if (ac.getContents() == null || ac.getContents().size() == 0) {
            return;
        }
        ac.getContents().forEach(subSub -> {
            if (subSub.getObjectType() == CdmObjectType.AttributeContextDef) {
                this.collectAllNodes((CdmObject)subSub, attCtxInTree);
            }
        });
    }

    private boolean CheckLineage(CdmObject subItem, HashSet<CdmAttributeContext> attCtxInTree) {
        CdmAttributeContext ac = (CdmAttributeContext)subItem;
        if (ac == null) {
            return true;
        }
        if (ac.getLineage() != null && ac.getLineage().size() > 0) {
            for (CdmAttributeContextReference lin : ac.getLineage()) {
                if (attCtxInTree.contains(lin.getExplicitReference())) continue;
                return false;
            }
        }
        if (ac.getContents() == null || ac.getContents().size() == 0) {
            return true;
        }
        for (CdmObject subSub : ac.getContents()) {
            if (subSub.getObjectType() != CdmObjectType.AttributeContextDef || this.CheckLineage(subSub, attCtxInTree)) continue;
            return false;
        }
        return true;
    }
}

