/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.commondatamodel.objectmodel.cdm;

import com.microsoft.commondatamodel.objectmodel.cdm.CdmCollection;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmCorpusContext;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmCorpusDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmEntityDeclarationDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmEntityDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmObject;
import com.microsoft.commondatamodel.objectmodel.enums.CdmLogCode;
import com.microsoft.commondatamodel.objectmodel.enums.CdmObjectType;
import com.microsoft.commondatamodel.objectmodel.utilities.logger.Logger;
import java.util.List;
import java.util.Objects;

public class CdmEntityCollection
extends CdmCollection<CdmEntityDeclarationDefinition> {
    private String tag = CdmEntityCollection.class.getSimpleName();

    public CdmEntityCollection(CdmCorpusContext ctx, CdmObject owner) {
        super(ctx, owner, CdmObjectType.LocalEntityDeclarationDef);
    }

    @Override
    public CdmEntityDeclarationDefinition add(CdmEntityDefinition entity) {
        return this.add(entity, false);
    }

    public CdmEntityDeclarationDefinition add(CdmEntityDefinition entity, boolean simpleRef) {
        CdmCorpusDefinition cdmCorpus = this.getCtx().getCorpus();
        if (entity.getOwner() == null) {
            Logger.error(entity.getCtx(), this.tag, "add", entity.getAtCorpusPath(), CdmLogCode.ErrEntityCreationFailed, new String[0]);
            return null;
        }
        CdmEntityDeclarationDefinition entityDeclaration = (CdmEntityDeclarationDefinition)cdmCorpus.makeObject(CdmObjectType.LocalEntityDeclarationDef, entity.getName(), simpleRef);
        entityDeclaration.setOwner(this.getOwner());
        entityDeclaration.setEntityPath(this.getCtx().getCorpus().getStorage().createRelativeCorpusPath(entity.getOwner().getAtCorpusPath() + "/" + entity.getEntityName(), this.getOwner().getInDocument()));
        entityDeclaration.setExplanation(entity.getExplanation());
        return this.add(entityDeclaration);
    }

    public CdmEntityDeclarationDefinition add(String name, String entityPath) {
        return this.add(name, entityPath, false);
    }

    public CdmEntityDeclarationDefinition add(String name, String entityPath, boolean simpleRef) {
        CdmEntityDeclarationDefinition entityDefinition = (CdmEntityDeclarationDefinition)this.add(name, simpleRef);
        entityDefinition.setEntityPath(entityPath);
        return entityDefinition;
    }

    @Override
    public void addAll(List<CdmEntityDefinition> entityList) {
        entityList.forEach(this::add);
    }

    @Override
    public boolean remove(CdmEntityDefinition entityDefToRemove) {
        for (CdmEntityDeclarationDefinition entity : this.getAllItems()) {
            if (!Objects.equals(entity.getEntityName(), entityDefToRemove.getEntityName())) continue;
            return super.remove(entity);
        }
        return false;
    }
}

