/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.commondatamodel.objectmodel.cdm;

import com.microsoft.commondatamodel.objectmodel.cdm.CdmAttributeContext;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmCorpusContext;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmFileStatus;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmObject;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmObjectBase;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmObjectDefinitionBase;
import com.microsoft.commondatamodel.objectmodel.enums.CdmLogCode;
import com.microsoft.commondatamodel.objectmodel.enums.CdmObjectType;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.ResolvedAttributeSetBuilder;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.ResolvedTraitSetBuilder;
import com.microsoft.commondatamodel.objectmodel.utilities.CopyOptions;
import com.microsoft.commondatamodel.objectmodel.utilities.ResolveOptions;
import com.microsoft.commondatamodel.objectmodel.utilities.StringUtils;
import com.microsoft.commondatamodel.objectmodel.utilities.TimeUtils;
import com.microsoft.commondatamodel.objectmodel.utilities.VisitCallback;
import com.microsoft.commondatamodel.objectmodel.utilities.logger.Logger;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;

public class CdmManifestDeclarationDefinition
extends CdmObjectDefinitionBase
implements CdmFileStatus {
    private String tag = CdmManifestDeclarationDefinition.class.getSimpleName();
    private String manifestName;
    private OffsetDateTime lastFileStatusCheckTime;
    private OffsetDateTime lastFileModifiedTime;
    private OffsetDateTime lastChildModifiedTime;
    private String definition;

    public CdmManifestDeclarationDefinition(CdmCorpusContext ctx, String name) {
        super(ctx);
        this.setObjectType(CdmObjectType.ManifestDeclarationDef);
        this.manifestName = name;
    }

    public String getDefinition() {
        return this.definition;
    }

    public void setDefinition(String value) {
        this.definition = value;
    }

    public String getManifestName() {
        return this.manifestName;
    }

    public void setManifestName(String value) {
        this.manifestName = value;
    }

    @Override
    public OffsetDateTime getLastFileStatusCheckTime() {
        return this.lastFileStatusCheckTime;
    }

    @Override
    public void setLastFileStatusCheckTime(OffsetDateTime value) {
        this.lastFileStatusCheckTime = value;
    }

    @Override
    public OffsetDateTime getLastFileModifiedTime() {
        return this.lastFileModifiedTime;
    }

    @Override
    public void setLastFileModifiedTime(OffsetDateTime value) {
        this.lastFileModifiedTime = value;
    }

    @Override
    public OffsetDateTime getLastChildFileModifiedTime() {
        return this.lastChildModifiedTime;
    }

    @Override
    public void setLastChildFileModifiedTime(OffsetDateTime time) {
        this.lastChildModifiedTime = time;
    }

    @Override
    public CompletableFuture<Void> fileStatusCheckAsync() {
        String fullPath = this.getCtx().getCorpus().getStorage().createAbsoluteCorpusPath(this.getDefinition(), this.getInDocument());
        return this.getCtx().getCorpus().computeLastModifiedTimeAsync(fullPath, this).thenCompose(modifiedTime -> {
            this.setLastFileStatusCheckTime(OffsetDateTime.now(ZoneOffset.UTC));
            this.setLastFileModifiedTime(TimeUtils.maxTime(modifiedTime, this.getLastFileModifiedTime()));
            return this.reportMostRecentTimeAsync(this.getLastFileModifiedTime());
        });
    }

    @Override
    public CompletableFuture<Void> reportMostRecentTimeAsync(OffsetDateTime childTime) {
        if (this.getOwner() instanceof CdmFileStatus && childTime != null) {
            return ((CdmFileStatus)this.getOwner()).reportMostRecentTimeAsync(childTime);
        }
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public String getName() {
        return this.manifestName;
    }

    @Override
    public boolean isDerivedFrom(String baseDef, ResolveOptions resOpt) {
        return false;
    }

    @Override
    public boolean visit(String pathFrom, VisitCallback preChildren, VisitCallback postChildren) {
        String path = "";
        if (!this.getCtx().getCorpus().blockDeclaredPathChanges && (path = this.getDeclaredPath()) == null) {
            path = pathFrom + this.getName();
            this.setDeclaredPath(path);
        }
        if (preChildren != null && preChildren.invoke(this, path)) {
            return false;
        }
        if (this.visitDef(path, preChildren, postChildren)) {
            return true;
        }
        if (postChildren != null && postChildren.invoke(this, path)) {
            return false;
        }
        return false;
    }

    @Override
    public boolean validate() {
        ArrayList<String> missingFields = new ArrayList<String>();
        if (StringUtils.isNullOrTrimEmpty(this.getManifestName())) {
            missingFields.add("manifestName");
        }
        if (StringUtils.isNullOrTrimEmpty(this.getDefinition())) {
            missingFields.add("definition");
        }
        if (missingFields.size() > 0) {
            Logger.error(this.getCtx(), this.tag, "validate", this.getAtCorpusPath(), CdmLogCode.ErrValdnIntegrityCheckFailure, this.getAtCorpusPath(), String.join((CharSequence)", ", missingFields.parallelStream().map(s -> String.format("'%s'", s)).collect(Collectors.toList())));
            return false;
        }
        return true;
    }

    @Override
    public Object copyData(ResolveOptions resOpt, CopyOptions options) {
        return CdmObjectBase.copyData(this, resOpt, options, CdmManifestDeclarationDefinition.class);
    }

    @Override
    @Deprecated
    public CdmObject copy(ResolveOptions resOpt, CdmObject host) {
        CdmManifestDeclarationDefinition copy;
        if (resOpt == null) {
            resOpt = new ResolveOptions(this, this.getCtx().getCorpus().getDefaultResolutionDirectives());
        }
        if (host == null) {
            copy = new CdmManifestDeclarationDefinition(this.getCtx(), this.getManifestName());
        } else {
            copy = (CdmManifestDeclarationDefinition)host;
            copy.setCtx(this.getCtx());
            copy.setManifestName(this.getManifestName());
        }
        copy.setDefinition(this.getDefinition());
        copy.setLastFileStatusCheckTime(this.getLastFileStatusCheckTime());
        copy.setLastFileModifiedTime(this.getLastFileModifiedTime());
        this.copyDef(resOpt, copy);
        return copy;
    }

    @Override
    @Deprecated
    public ResolvedAttributeSetBuilder constructResolvedAttributes(ResolveOptions resOpt) {
        return this.constructResolvedAttributes(resOpt, null);
    }

    @Override
    @Deprecated
    public ResolvedAttributeSetBuilder constructResolvedAttributes(ResolveOptions resOpt, CdmAttributeContext under) {
        return null;
    }

    @Override
    void constructResolvedTraits(ResolvedTraitSetBuilder rtsb, ResolveOptions resOpt) {
    }
}

