/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.commondatamodel.objectmodel.cdm;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.base.Strings;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmAttributeContext;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmCorpusContext;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmCorpusDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmDocumentDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmObject;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmObjectBase;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmObjectDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmObjectDefinitionBase;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmObjectReference;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmTraitCollection;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmTraitReference;
import com.microsoft.commondatamodel.objectmodel.enums.CdmAttributeContextType;
import com.microsoft.commondatamodel.objectmodel.enums.CdmLogCode;
import com.microsoft.commondatamodel.objectmodel.enums.CdmObjectType;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.ResolveContext;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.ResolvedAttribute;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.ResolvedAttributeSet;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.ResolvedAttributeSetBuilder;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.ResolvedTraitSet;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.ResolvedTraitSetBuilder;
import com.microsoft.commondatamodel.objectmodel.utilities.AttributeContextParameters;
import com.microsoft.commondatamodel.objectmodel.utilities.ResolveOptions;
import com.microsoft.commondatamodel.objectmodel.utilities.StringUtils;
import com.microsoft.commondatamodel.objectmodel.utilities.SymbolSet;
import com.microsoft.commondatamodel.objectmodel.utilities.VisitCallback;
import com.microsoft.commondatamodel.objectmodel.utilities.logger.Logger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.stream.Collectors;

public abstract class CdmObjectReferenceBase
extends CdmObjectBase
implements CdmObjectReference {
    private String tag = CdmObjectReferenceBase.class.getSimpleName();
    private static String RES_ATT_TOKEN = "/(resolvedAttributes)/";
    private CdmTraitCollection appliedTraits = new CdmTraitCollection(this.getCtx(), this);
    private String namedReference;
    private CdmObjectDefinition explicitReference;
    private boolean simpleNamedReference;
    private CdmDocumentDefinition monikeredDocument;

    public CdmObjectReferenceBase(CdmCorpusContext ctx, Object referenceTo, boolean simpleReference) {
        super(ctx);
        if (null != referenceTo) {
            if (referenceTo instanceof CdmObject) {
                this.setExplicitReference((CdmObjectDefinitionBase)referenceTo);
            } else {
                this.setNamedReference((String)referenceTo);
            }
        }
        if (simpleReference) {
            this.setSimpleNamedReference(true);
        }
    }

    static int offsetAttributePromise(String ref) {
        if (Strings.isNullOrEmpty((String)ref)) {
            return -1;
        }
        return ref.indexOf(RES_ATT_TOKEN);
    }

    CdmObjectReferenceBase copyToHost(CdmCorpusContext ctx, Object refTo, boolean simpleReference) {
        this.setCtx(ctx);
        this.setExplicitReference(null);
        this.setNamedReference(null);
        if (refTo != null) {
            if (refTo instanceof CdmObject) {
                this.setExplicitReference((CdmObjectDefinitionBase)refTo);
            } else if (refTo instanceof JsonNode) {
                this.setNamedReference(((JsonNode)refTo).asText());
            } else {
                this.setNamedReference((String)refTo);
            }
        }
        this.setSimpleNamedReference(simpleReference);
        this.getAppliedTraits().clear();
        return this;
    }

    @Deprecated
    public abstract CdmObjectReferenceBase copyRefObject(ResolveOptions var1, Object var2, boolean var3);

    @Deprecated
    public abstract CdmObjectReferenceBase copyRefObject(ResolveOptions var1, Object var2, boolean var3, CdmObjectReferenceBase var4);

    @Deprecated
    public abstract boolean visitRef(String var1, VisitCallback var2, VisitCallback var3);

    @Override
    @Deprecated
    public ResolvedAttributeSetBuilder constructResolvedAttributes(ResolveOptions resOpt) {
        return this.constructResolvedAttributes(resOpt, null);
    }

    @Override
    @Deprecated
    public ResolvedAttributeSetBuilder constructResolvedAttributes(ResolveOptions resOpt, CdmAttributeContext under) {
        ResolvedAttributeSetBuilder rasb = new ResolvedAttributeSetBuilder();
        rasb.getResolvedAttributeSet().setAttributeContext(under);
        CdmObjectDefinitionBase def = (CdmObjectDefinitionBase)this.fetchObjectDefinition(resOpt);
        if (def != null) {
            ResolvedAttributeSet resAtts;
            AttributeContextParameters acpRef = null;
            if (under != null) {
                acpRef = new AttributeContextParameters();
                acpRef.setUnder(under);
                acpRef.setType(CdmAttributeContextType.PassThrough);
            }
            if ((resAtts = def.fetchResolvedAttributes(resOpt, acpRef)) != null && resAtts.getSet() != null && resAtts.getSet().size() > 0) {
                rasb.mergeAttributes(resAtts);
                rasb.removeRequestedAtts();
            }
        } else {
            String defName = this.fetchObjectDefinitionName();
            Logger.warning(this.getCtx(), this.tag, "constructResolvedAttributes", this.getAtCorpusPath(), CdmLogCode.WarnResolveObjectFailed, defName);
        }
        return rasb;
    }

    @Override
    @Deprecated
    public ResolvedTraitSet fetchResolvedTraits() {
        return this.fetchResolvedTraits(null);
    }

    @Override
    @Deprecated
    public ResolvedTraitSet fetchResolvedTraits(ResolveOptions resOpt) {
        boolean wasPreviouslyResolving = this.getCtx().getCorpus().isCurrentlyResolving;
        this.getCtx().getCorpus().isCurrentlyResolving = true;
        ResolvedTraitSet ret = this._fetchResolvedTraits(resOpt);
        this.getCtx().getCorpus().isCurrentlyResolving = wasPreviouslyResolving;
        return ret;
    }

    @Deprecated
    public ResolvedTraitSet _fetchResolvedTraits(ResolveOptions resOpt) {
        if (resOpt == null) {
            resOpt = new ResolveOptions(this, this.getCtx().getCorpus().getDefaultResolutionDirectives());
        }
        if (this.getNamedReference() != null && this.getAppliedTraits() == null) {
            String kind = "rts";
            ResolveContext ctx = (ResolveContext)this.getCtx();
            Object objDef = this.fetchObjectDefinition(resOpt);
            String cacheTag = ctx.getCorpus().createDefinitionCacheTag(resOpt, this, "rts", "", true, objDef != null ? objDef.getAtCorpusPath() : null);
            Object rtsResultDynamic = null;
            if (cacheTag != null) {
                rtsResultDynamic = ctx.getCache().get(cacheTag);
            }
            ResolvedTraitSet rtsResult = (ResolvedTraitSet)rtsResultDynamic;
            SymbolSet currSymRefSet = resOpt.getSymbolRefSet();
            if (currSymRefSet == null) {
                currSymRefSet = new SymbolSet();
            }
            resOpt.setSymbolRefSet(new SymbolSet());
            if (rtsResult == null) {
                if (objDef != null) {
                    rtsResult = objDef.fetchResolvedTraits(resOpt);
                    if (rtsResult != null) {
                        rtsResult = rtsResult.deepCopy();
                    }
                    ctx.getCorpus().registerDefinitionReferenceSymbols((CdmObject)objDef, "rts", resOpt.getSymbolRefSet());
                    cacheTag = ctx.getCorpus().createDefinitionCacheTag(resOpt, this, "rts", "", true, objDef.getAtCorpusPath());
                    if (!StringUtils.isNullOrTrimEmpty(cacheTag)) {
                        ctx.getCache().put(cacheTag, rtsResult);
                    }
                }
            } else {
                String key = CdmCorpusDefinition.createCacheKeyFromObject(this, "rts");
                SymbolSet tempDocRefSet = ctx.getCorpus().getDefinitionReferenceSymbols().get(key);
                resOpt.setSymbolRefSet(tempDocRefSet);
            }
            currSymRefSet.merge(resOpt.getSymbolRefSet());
            resOpt.setSymbolRefSet(currSymRefSet);
            return rtsResult;
        }
        return super.fetchResolvedTraits(resOpt);
    }

    @Override
    void constructResolvedTraits(ResolvedTraitSetBuilder rtsb, ResolveOptions resOpt) {
        Object objDef = this.fetchObjectDefinition(resOpt);
        if (objDef != null) {
            ResolvedTraitSet rtsInh = objDef.fetchResolvedTraits(resOpt);
            if (rtsInh != null) {
                rtsInh = rtsInh.deepCopy();
            }
            rtsb.takeReference(rtsInh);
        } else {
            String defName = this.fetchObjectDefinitionName();
            Logger.warning(this.getCtx(), this.tag, "constructResolvedTraits", this.getAtCorpusPath(), CdmLogCode.WarnResolveObjectFailed, defName);
        }
        if (this.getAppliedTraits() != null) {
            for (CdmTraitReference at : this.getAppliedTraits()) {
                rtsb.mergeTraits(at.fetchResolvedTraits(resOpt));
            }
        }
    }

    @Override
    @Deprecated
    public CdmObject fetchResolvedReference() {
        return this.fetchResolvedReference(null);
    }

    @Override
    @Deprecated
    public CdmObject fetchResolvedReference(ResolveOptions resOpt) {
        if (resOpt == null) {
            resOpt = new ResolveOptions(this, this.getCtx().getCorpus().getDefaultResolutionDirectives());
        }
        if (this.getExplicitReference() != null) {
            return this.getExplicitReference();
        }
        if (this.getCtx() == null) {
            return null;
        }
        ResolveContext ctx = (ResolveContext)this.getCtx();
        CdmObjectBase res = null;
        int seekResAtt = CdmObjectReferenceBase.offsetAttributePromise(this.getNamedReference());
        if (seekResAtt >= 0) {
            String entName = this.getNamedReference().substring(0, seekResAtt);
            String attName = this.getNamedReference().substring(seekResAtt + RES_ATT_TOKEN.length());
            CdmObjectBase ent = this.getCtx().getCorpus().resolveSymbolReference(resOpt, this.getInDocument(), entName, CdmObjectType.EntityDef, true);
            if (ent == null) {
                Logger.warning(ctx, this.tag, "FetchResolvedReference", this.getAtCorpusPath(), CdmLogCode.WarnResolveEntityFailed, entName, this.getNamedReference());
                return null;
            }
            ResolvedAttributeSet ras = ent.fetchResolvedAttributes(resOpt);
            ResolvedAttribute ra = null;
            if (ras != null) {
                ra = ras.get(attName);
            }
            if (ra != null) {
                res = (CdmObjectDefinitionBase)ra.getTarget();
            } else {
                Logger.warning(ctx, this.tag, "fetchResolvedReference", this.getAtCorpusPath(), CdmLogCode.WarnResolveAttrFailed, this.getNamedReference());
            }
        } else {
            res = this.getCtx().getCorpus().resolveSymbolReference(resOpt, this.getInDocument(), this.getNamedReference(), this.getObjectType(), true);
        }
        return res;
    }

    @Override
    @Deprecated
    public CdmObjectReference createPortableReference(ResolveOptions resOpt) {
        CdmObjectReferenceBase cdmObjectRef = (CdmObjectReferenceBase)this.getCtx().getCorpus().makeObject(CdmCorpusDefinition.mapReferenceType(this.getObjectType()), "portable", true);
        CdmObjectDefinitionBase cdmObjectDef = (CdmObjectDefinitionBase)this.fetchObjectDefinition(resOpt);
        if (cdmObjectDef == null || this.getInDocument() == null) {
            return null;
        }
        cdmObjectRef.setExplicitReference((CdmObjectDefinition)cdmObjectDef.copy());
        cdmObjectRef.setInDocument(this.getInDocument());
        cdmObjectRef.setOwner(this.getOwner());
        return cdmObjectRef;
    }

    @Deprecated
    public void localizePortableReference(ResolveOptions resOpt, String importPath) {
        String newDeclaredPath = ((CdmObjectBase)((Object)this.getExplicitReference())).getDeclaredPath();
        newDeclaredPath = newDeclaredPath != null && newDeclaredPath.endsWith("/(ref)") ? newDeclaredPath.substring(0, newDeclaredPath.length() - 6) : newDeclaredPath;
        this.setNamedReference(String.format("%s%s", importPath, newDeclaredPath));
    }

    @Override
    public String getNamedReference() {
        return this.namedReference;
    }

    @Override
    public void setNamedReference(String namedReference) {
        this.namedReference = namedReference;
    }

    @Override
    public CdmObjectDefinition getExplicitReference() {
        return this.explicitReference;
    }

    @Override
    public void setExplicitReference(CdmObjectDefinition explicitReference) {
        if (explicitReference != null) {
            explicitReference.setOwner(this);
        }
        this.explicitReference = explicitReference;
    }

    @Override
    public boolean isSimpleNamedReference() {
        return this.simpleNamedReference;
    }

    @Override
    public void setSimpleNamedReference(boolean simpleNamedReference) {
        this.simpleNamedReference = simpleNamedReference;
    }

    @Override
    public <T extends CdmObjectDefinition> T fetchObjectDefinition(ResolveOptions resOpt) {
        CdmObject def;
        if (resOpt == null) {
            resOpt = new ResolveOptions(this, this.getCtx().getCorpus().getDefaultResolutionDirectives());
        }
        if ((def = this.fetchResolvedReference(resOpt)) != null && def instanceof CdmObjectReference) {
            def = ((CdmObjectReference)def).fetchResolvedReference();
        }
        if (def != null && !(def instanceof CdmObjectReference)) {
            return (T)((CdmObjectDefinition)def);
        }
        return null;
    }

    @Override
    public boolean isDerivedFrom(String baseDef, ResolveOptions resOpt) {
        Object def;
        if (resOpt == null) {
            resOpt = new ResolveOptions(this, this.getCtx().getCorpus().getDefaultResolutionDirectives());
        }
        if ((def = this.fetchObjectDefinition(resOpt)) != null) {
            return def.isDerivedFrom(baseDef, resOpt);
        }
        return false;
    }

    @Override
    public CdmTraitCollection getAppliedTraits() {
        return this.appliedTraits;
    }

    @Override
    public String fetchObjectDefinitionName() {
        if (!Strings.isNullOrEmpty((String)this.namedReference)) {
            int pathEnd = this.getNamedReference().lastIndexOf(47);
            if (pathEnd == -1 || pathEnd + 1 == this.getNamedReference().length()) {
                return this.getNamedReference();
            }
            return this.getNamedReference().substring(pathEnd + 1);
        }
        if (this.explicitReference != null) {
            return this.explicitReference.getName();
        }
        return null;
    }

    @Override
    public boolean visit(String pathFrom, VisitCallback preChildren, VisitCallback postChildren) {
        String path = "";
        if (this.getCtx() != null && this.getCtx().getCorpus() != null && !this.getCtx().getCorpus().blockDeclaredPathChanges) {
            if (!Strings.isNullOrEmpty((String)this.getNamedReference())) {
                path = pathFrom + this.getNamedReference();
            } else if (this.explicitReference != null) {
                path = pathFrom + this.explicitReference.getName();
                ((CdmObjectDefinitionBase)this.getExplicitReference()).setDeclaredPath(path);
            } else {
                path = pathFrom;
            }
            this.setDeclaredPath(path + "/(ref)");
        }
        String refPath = this.getDeclaredPath();
        if (preChildren != null && preChildren.invoke(this, refPath)) {
            return false;
        }
        if (this.getExplicitReference() != null && Strings.isNullOrEmpty((String)this.getNamedReference()) && this.getExplicitReference().visit(path, preChildren, postChildren)) {
            return true;
        }
        if (this.visitRef(path, preChildren, postChildren)) {
            return true;
        }
        if (this.getAppliedTraits() != null && this.getAppliedTraits().visitList(refPath + "/appliedTraits/", preChildren, postChildren)) {
            return true;
        }
        return postChildren != null && postChildren.invoke(this, refPath);
    }

    @Override
    public boolean validate() {
        ArrayList<String> missingFields = new ArrayList<String>(Arrays.asList("namedReference", "explicitReference"));
        if (StringUtils.isNullOrTrimEmpty(this.namedReference) && this.explicitReference == null) {
            Logger.error(this.getCtx(), this.tag, "validate", this.getAtCorpusPath(), CdmLogCode.ErrValdnIntegrityCheckFailure, this.getAtCorpusPath(), String.join((CharSequence)", ", missingFields.parallelStream().map(s -> String.format("'%s'", s)).collect(Collectors.toList())));
            return false;
        }
        return true;
    }

    @Override
    public CdmObject copy(ResolveOptions resOpt, CdmObject host) {
        if (resOpt == null) {
            resOpt = new ResolveOptions(this, this.getCtx().getCorpus().getDefaultResolutionDirectives());
        }
        CdmObjectReferenceBase copy = !Strings.isNullOrEmpty((String)this.getNamedReference()) ? this.copyRefObject(resOpt, this.getNamedReference(), this.isSimpleNamedReference()) : this.copyRefObject(resOpt, this.getExplicitReference(), this.isSimpleNamedReference());
        if (resOpt.isSaveResolutionsOnCopy()) {
            CdmObjectDefinition explicitReference = this.getExplicitReference() != null ? (CdmObjectDefinition)this.getExplicitReference().copy() : null;
            copy.setExplicitReference(explicitReference);
        }
        copy.getAppliedTraits().clear();
        if (this.getAppliedTraits() != null) {
            for (CdmTraitReference appliedTrait : this.appliedTraits) {
                copy.getAppliedTraits().add(appliedTrait);
            }
        }
        copy.setInDocument(this.getInDocument());
        return copy;
    }

    @Override
    public CdmObjectReference createSimpleReference(ResolveOptions resOpt) {
        if (resOpt == null) {
            resOpt = new ResolveOptions(this, this.getCtx().getCorpus().getDefaultResolutionDirectives());
        }
        if (!Strings.isNullOrEmpty((String)this.namedReference)) {
            return this.copyRefObject(resOpt, this.namedReference, true);
        }
        String newDeclaredPath = this.getDeclaredPath() != null && this.getDeclaredPath().endsWith("/(ref)") ? this.getDeclaredPath().substring(0, this.getDeclaredPath().length() - 6) : this.getDeclaredPath();
        return this.copyRefObject(resOpt, newDeclaredPath, true);
    }

    CdmDocumentDefinition getMonikeredDocument() {
        return this.monikeredDocument;
    }

    void setMonikeredDocument(CdmDocumentDefinition monikeredDocument) {
        this.monikeredDocument = monikeredDocument;
    }
}

