/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.commondatamodel.objectmodel.cdm;

import com.google.common.base.Strings;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmCorpusContext;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmDataTypeReference;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmObject;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmObjectBase;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmObjectDefinitionBase;
import com.microsoft.commondatamodel.objectmodel.enums.CdmLogCode;
import com.microsoft.commondatamodel.objectmodel.enums.CdmObjectType;
import com.microsoft.commondatamodel.objectmodel.utilities.CopyOptions;
import com.microsoft.commondatamodel.objectmodel.utilities.ResolveOptions;
import com.microsoft.commondatamodel.objectmodel.utilities.StringUtils;
import com.microsoft.commondatamodel.objectmodel.utilities.VisitCallback;
import com.microsoft.commondatamodel.objectmodel.utilities.logger.Logger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.stream.Collectors;

public class CdmParameterDefinition
extends CdmObjectDefinitionBase {
    private String tag = CdmParameterDefinition.class.getSimpleName();
    private String name;
    private Boolean isRequired;
    private CdmDataTypeReference dataTypeRef;
    private Object defaultValue;

    public CdmParameterDefinition(CdmCorpusContext ctx, String name) {
        super(ctx);
        this.setName(name);
        this.setObjectType(CdmObjectType.ParameterDef);
    }

    @Override
    public boolean isDerivedFrom(String baseDef, ResolveOptions resOpt) {
        return false;
    }

    @Override
    public boolean visit(String pathFrom, VisitCallback preChildren, VisitCallback postChildren) {
        String path = "";
        if (this.getCtx() != null && this.getCtx().getCorpus() != null && !this.getCtx().getCorpus().blockDeclaredPathChanges && Strings.isNullOrEmpty((String)(path = this.getDeclaredPath()))) {
            path = pathFrom + this.getName();
            this.setDeclaredPath(path);
        }
        if (preChildren != null && preChildren.invoke(this, path)) {
            return false;
        }
        if (this.getDefaultValue() != null && this.getDefaultValue() instanceof CdmObject && ((CdmObject)this.getDefaultValue()).visit(path + "/defaultValue/", preChildren, postChildren)) {
            return true;
        }
        if (this.getDataTypeRef() != null && this.getDataTypeRef().visit(path + "/dataType/", preChildren, postChildren)) {
            return true;
        }
        return postChildren != null && postChildren.invoke(this, path);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String value) {
        this.name = value;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(Object value) {
        this.defaultValue = value;
    }

    public Boolean isRequired() {
        return this.isRequired;
    }

    public void setRequired(boolean value) {
        this.isRequired = value;
    }

    public CdmDataTypeReference getDataTypeRef() {
        return this.dataTypeRef;
    }

    public void setDataTypeRef(CdmDataTypeReference value) {
        this.dataTypeRef = value;
    }

    @Override
    public boolean validate() {
        if (StringUtils.isNullOrTrimEmpty(this.name)) {
            ArrayList<String> missingFields = new ArrayList<String>(Arrays.asList("Name"));
            Logger.error(this.getCtx(), this.tag, "validate", this.getAtCorpusPath(), CdmLogCode.ErrValdnIntegrityCheckFailure, this.getAtCorpusPath(), String.join((CharSequence)", ", missingFields.parallelStream().map(s -> String.format("'%s'", s)).collect(Collectors.toList())));
            return false;
        }
        return true;
    }

    @Override
    @Deprecated
    public Object copyData(ResolveOptions resOpt, CopyOptions options) {
        return CdmObjectBase.copyData(this, resOpt, options, CdmParameterDefinition.class);
    }

    @Override
    public CdmObject copy(ResolveOptions resOpt, CdmObject host) {
        CdmParameterDefinition copy;
        if (resOpt == null) {
            resOpt = new ResolveOptions(this, this.getCtx().getCorpus().getDefaultResolutionDirectives());
        }
        if (host == null) {
            copy = new CdmParameterDefinition(this.getCtx(), this.getName());
        } else {
            copy = (CdmParameterDefinition)host;
            copy.setCtx(this.getCtx());
            copy.setName(this.getName());
        }
        Object defVal = null;
        if (this.getDefaultValue() != null) {
            defVal = this.getDefaultValue() instanceof String ? this.getDefaultValue() : ((CdmObject)this.getDefaultValue()).copy(resOpt);
        }
        copy.setExplanation(this.getExplanation());
        copy.setDefaultValue(defVal);
        copy.setRequired(this.isRequired());
        copy.setDataTypeRef((CdmDataTypeReference)(this.getDataTypeRef() != null ? this.getDataTypeRef().copy(resOpt) : null));
        return copy;
    }
}

