/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.commondatamodel.objectmodel.persistence.cdmfolder;

import com.microsoft.commondatamodel.objectmodel.cdm.CdmCorpusContext;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmDataTypeDefinition;
import com.microsoft.commondatamodel.objectmodel.enums.CdmLogCode;
import com.microsoft.commondatamodel.objectmodel.enums.CdmObjectType;
import com.microsoft.commondatamodel.objectmodel.persistence.cdmfolder.DataTypeReferencePersistence;
import com.microsoft.commondatamodel.objectmodel.persistence.cdmfolder.Utils;
import com.microsoft.commondatamodel.objectmodel.persistence.cdmfolder.types.DataType;
import com.microsoft.commondatamodel.objectmodel.utilities.CopyOptions;
import com.microsoft.commondatamodel.objectmodel.utilities.ResolveOptions;
import com.microsoft.commondatamodel.objectmodel.utilities.logger.Logger;

public class DataTypePersistence {
    private static String tag = DataTypePersistence.class.getSimpleName();

    public static CdmDataTypeDefinition fromData(CdmCorpusContext ctx, DataType obj) {
        if (obj == null) {
            Logger.error(ctx, tag, "fromData", null, CdmLogCode.ErrPersistJsonDatatypeConversionError, new String[0]);
            return null;
        }
        CdmDataTypeDefinition dataType = (CdmDataTypeDefinition)ctx.getCorpus().makeObject(CdmObjectType.DataTypeDef, obj.getDataTypeName());
        dataType.setExtendsDataType(DataTypeReferencePersistence.fromData(ctx, obj.getExtendsDataType()));
        if (obj.getExplanation() != null) {
            dataType.setExplanation(obj.getExplanation());
        }
        Utils.addListToCdmCollection(dataType.getExhibitsTraits(), Utils.createTraitReferenceList(ctx, obj.getExhibitsTraits()));
        return dataType;
    }

    public static DataType toData(CdmDataTypeDefinition instance, ResolveOptions resOpt, CopyOptions options) {
        DataType result = new DataType();
        result.setExplanation(instance.getExplanation());
        result.setDataTypeName(instance.getDataTypeName());
        result.setExtendsDataType(Utils.jsonForm(instance.getExtendsDataType(), resOpt, options));
        result.setExhibitsTraits(Utils.listCopyDataAsArrayNode(instance.getExhibitsTraits(), resOpt, options));
        return result;
    }
}

