/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.commondatamodel.objectmodel.persistence.modeljson;

import com.google.common.base.Strings;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmCorpusContext;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmDataPartitionDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmFolderDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmTraitDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmTraitReference;
import com.microsoft.commondatamodel.objectmodel.enums.CdmLogCode;
import com.microsoft.commondatamodel.objectmodel.enums.CdmObjectType;
import com.microsoft.commondatamodel.objectmodel.persistence.modeljson.ExtensionHelper;
import com.microsoft.commondatamodel.objectmodel.persistence.modeljson.Utils;
import com.microsoft.commondatamodel.objectmodel.persistence.modeljson.types.CsvFormatSettings;
import com.microsoft.commondatamodel.objectmodel.persistence.modeljson.types.Partition;
import com.microsoft.commondatamodel.objectmodel.utilities.CopyOptions;
import com.microsoft.commondatamodel.objectmodel.utilities.ResolveOptions;
import com.microsoft.commondatamodel.objectmodel.utilities.StringUtils;
import com.microsoft.commondatamodel.objectmodel.utilities.TraitToPropertyMap;
import com.microsoft.commondatamodel.objectmodel.utilities.logger.Logger;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public class DataPartitionPersistence {
    private static String tag = DataPartitionPersistence.class.getSimpleName();

    public static CompletableFuture<CdmDataPartitionDefinition> fromData(CdmCorpusContext ctx, Partition obj, List<CdmTraitDefinition> extensionTraitDefList, List<CdmTraitDefinition> localExtensionTraitDefList, CdmFolderDefinition documentFolder) {
        CdmDataPartitionDefinition partition = (CdmDataPartitionDefinition)ctx.getCorpus().makeObject(CdmObjectType.DataPartitionDef, obj.getName());
        if (!StringUtils.isNullOrTrimEmpty(obj.getDescription())) {
            partition.setDescription(obj.getDescription());
        }
        partition.setLocation(ctx.getCorpus().getStorage().createRelativeCorpusPath(ctx.getCorpus().getStorage().adapterPathToCorpusPath(obj.getLocation()), documentFolder));
        partition.setRefreshTime(obj.getRefreshTime());
        partition.setLastFileModifiedTime(obj.getLastFileModifiedTime());
        partition.setLastFileStatusCheckTime(obj.getLastFileStatusCheckTime());
        if (Strings.isNullOrEmpty((String)partition.getLocation())) {
            Logger.warning(ctx, tag, "fromData", null, CdmLogCode.WarnPersistPartitionLocMissing, partition.getName());
        }
        if (obj.isHidden() != null && obj.isHidden().booleanValue()) {
            CdmTraitReference isHiddenTrait = (CdmTraitReference)ctx.getCorpus().makeRef(CdmObjectType.TraitRef, "is.hidden", true);
            partition.getExhibitsTraits().add(isHiddenTrait);
        }
        return Utils.processAnnotationsFromData(ctx, obj, partition.getExhibitsTraits()).thenCompose(v -> {
            if (obj.getFileFormatSettings() != null) {
                CdmTraitReference csvFormatTrait = Utils.createCsvTrait(obj.getFileFormatSettings(), ctx);
                if (csvFormatTrait == null) {
                    Logger.error(ctx, tag, "fromData", null, CdmLogCode.ErrPersistCsvProcessingError, new String[0]);
                    return CompletableFuture.completedFuture(null);
                }
                partition.getExhibitsTraits().add(csvFormatTrait);
            }
            ExtensionHelper.processExtensionFromJson(ctx, obj, partition.getExhibitsTraits(), extensionTraitDefList, localExtensionTraitDefList);
            return CompletableFuture.completedFuture(partition);
        });
    }

    public static CompletableFuture<Partition> toData(CdmDataPartitionDefinition instance, ResolveOptions resOpt, CopyOptions options) {
        CdmTraitReference csvTrait;
        Partition result = new Partition();
        result.setName(instance.getName());
        result.setDescription(instance.getDescription());
        result.setLocation(instance.getCtx().getCorpus().getStorage().corpusPathToAdapterPath(instance.getCtx().getCorpus().getStorage().createAbsoluteCorpusPath(instance.getLocation(), instance.getInDocument())));
        result.setRefreshTime(instance.getRefreshTime());
        result.setFileFormatSettings(null);
        result.setLastFileModifiedTime(instance.getLastFileModifiedTime());
        result.setLastFileStatusCheckTime(instance.getLastFileStatusCheckTime());
        if (result.getName() == null) {
            Logger.warning(instance.getCtx(), tag, "toData", instance.getAtCorpusPath(), CdmLogCode.WarnPersistPartitionNameNull, new String[0]);
            result.setName("");
        }
        if (Strings.isNullOrEmpty((String)result.getLocation())) {
            Logger.warning(instance.getCtx(), tag, "toData", instance.getAtCorpusPath(), CdmLogCode.WarnPersistPartitionLocMissing, result.getName());
        }
        Utils.processTraitsAndAnnotationsToData(instance.getCtx(), result, instance.getExhibitsTraits());
        TraitToPropertyMap t2pm = new TraitToPropertyMap(instance);
        if (t2pm.fetchTraitReferenceName("is.hidden") != null) {
            result.setHidden(true);
        }
        if ((csvTrait = t2pm.fetchTraitReferenceName("is.partition.format.CSV")) != null) {
            CsvFormatSettings csvFormatSettings = Utils.createCsvFormatSettings(csvTrait);
            if (csvFormatSettings != null) {
                result.setFileFormatSettings(csvFormatSettings);
                result.getFileFormatSettings().setType("CsvFormatSettings");
            } else {
                Logger.error(instance.getCtx(), tag, "toData", instance.getAtCorpusPath(), CdmLogCode.ErrPersistCsvProcessingError, new String[0]);
                return CompletableFuture.completedFuture(null);
            }
        }
        return CompletableFuture.completedFuture(result);
    }
}

