/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.commondatamodel.objectmodel.persistence.modeljson;

import com.microsoft.commondatamodel.objectmodel.cdm.CdmArgumentDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmCorpusContext;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmEntityDeclarationDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmTraitCollection;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmTraitDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmTraitReference;
import com.microsoft.commondatamodel.objectmodel.enums.CdmLogCode;
import com.microsoft.commondatamodel.objectmodel.enums.CdmObjectType;
import com.microsoft.commondatamodel.objectmodel.persistence.modeljson.ExtensionHelper;
import com.microsoft.commondatamodel.objectmodel.persistence.modeljson.Utils;
import com.microsoft.commondatamodel.objectmodel.persistence.modeljson.types.ReferenceEntity;
import com.microsoft.commondatamodel.objectmodel.utilities.CopyOptions;
import com.microsoft.commondatamodel.objectmodel.utilities.ResolveOptions;
import com.microsoft.commondatamodel.objectmodel.utilities.TraitToPropertyMap;
import com.microsoft.commondatamodel.objectmodel.utilities.logger.Logger;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;

public class ReferencedEntityDeclarationPersistence {
    private static String tag = ReferencedEntityDeclarationPersistence.class.getSimpleName();

    public static CompletableFuture<CdmEntityDeclarationDefinition> fromData(CdmCorpusContext ctx, ReferenceEntity obj, String location) {
        CdmEntityDeclarationDefinition referencedEntity = (CdmEntityDeclarationDefinition)ctx.getCorpus().makeObject(CdmObjectType.ReferencedEntityDeclarationDef, obj.getName());
        String corpusPath = ctx.getCorpus().getStorage().adapterPathToCorpusPath(location);
        referencedEntity.setEntityName(obj.getName());
        referencedEntity.setEntityPath(corpusPath + "/" + obj.getSource());
        referencedEntity.setExplanation(obj.getDescription());
        referencedEntity.setLastFileModifiedTime(obj.getLastFileModifiedTime());
        referencedEntity.setLastFileStatusCheckTime(obj.getLastFileStatusCheckTime());
        return Utils.processAnnotationsFromData(ctx, obj, referencedEntity.getExhibitsTraits()).thenCompose(v -> {
            if (obj.isHidden() != null && obj.isHidden().booleanValue()) {
                CdmTraitReference isHiddenTrait = (CdmTraitReference)ctx.getCorpus().makeRef(CdmObjectType.TraitRef, "is.hidden", true);
                isHiddenTrait.setFromProperty(true);
                referencedEntity.getExhibitsTraits().add(isHiddenTrait);
            }
            CdmTraitReference trait = (CdmTraitReference)ctx.getCorpus().makeRef(CdmObjectType.TraitRef, "is.propertyContent.multiTrait", false);
            trait.setFromProperty(true);
            CdmArgumentDefinition argument = (CdmArgumentDefinition)ctx.getCorpus().makeObject(CdmObjectType.ArgumentDef, "modelId");
            argument.setValue(obj.getModelId());
            trait.getArguments().add(argument);
            referencedEntity.getExhibitsTraits().add(trait);
            ArrayList<CdmTraitDefinition> extensionTraitDefList = new ArrayList<CdmTraitDefinition>();
            CdmTraitCollection extensionTraits = new CdmTraitCollection(ctx, referencedEntity);
            ExtensionHelper.processExtensionFromJson(ctx, obj, extensionTraits, extensionTraitDefList);
            if (extensionTraitDefList.size() > 0) {
                Logger.warning(ctx, tag, "fromData", null, CdmLogCode.WarnPersistCustomExtNotSupported, new String[0]);
            }
            return CompletableFuture.completedFuture(referencedEntity);
        });
    }

    public static CompletableFuture<ReferenceEntity> toData(CdmEntityDeclarationDefinition instance, ResolveOptions resOpt, CopyOptions options) {
        CdmTraitReference propertiesTrait;
        int sourceIndex = instance.getEntityPath().lastIndexOf("/");
        if (sourceIndex == -1) {
            Logger.error(instance.getCtx(), tag, "toData", instance.getAtCorpusPath(), CdmLogCode.ErrPersistModelJsonEntityPartitionConversionError, new String[0]);
            return CompletableFuture.completedFuture(null);
        }
        ReferenceEntity referenceEntity = new ReferenceEntity();
        referenceEntity.setType("ReferenceEntity");
        referenceEntity.setName(instance.getEntityName());
        referenceEntity.setSource(instance.getEntityPath().substring(sourceIndex + 1));
        referenceEntity.setDescription(instance.getExplanation());
        referenceEntity.setLastFileModifiedTime(instance.getLastFileModifiedTime());
        referenceEntity.setLastFileStatusCheckTime(instance.getLastFileStatusCheckTime());
        Utils.processTraitsAndAnnotationsToData(instance.getCtx(), referenceEntity, instance.getExhibitsTraits());
        TraitToPropertyMap t2pm = new TraitToPropertyMap(instance);
        CdmTraitReference isHiddenTrait = t2pm.fetchTraitReferenceName("is.hidden");
        if (isHiddenTrait != null) {
            referenceEntity.setHidden(true);
        }
        if ((propertiesTrait = t2pm.fetchTraitReferenceName("is.propertyContent.multiTrait")) != null) {
            referenceEntity.setModelId(((CdmArgumentDefinition)propertiesTrait.getArguments().get(0)).getValue().toString());
        }
        return CompletableFuture.completedFuture(referenceEntity);
    }
}

