/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.commondatamodel.objectmodel.persistence.modeljson;

import com.microsoft.commondatamodel.objectmodel.cdm.CdmCorpusContext;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmE2ERelationship;
import com.microsoft.commondatamodel.objectmodel.enums.CdmLogCode;
import com.microsoft.commondatamodel.objectmodel.enums.CdmObjectType;
import com.microsoft.commondatamodel.objectmodel.persistence.modeljson.Utils;
import com.microsoft.commondatamodel.objectmodel.persistence.modeljson.types.AttributeReference;
import com.microsoft.commondatamodel.objectmodel.persistence.modeljson.types.SingleKeyRelationship;
import com.microsoft.commondatamodel.objectmodel.utilities.CopyOptions;
import com.microsoft.commondatamodel.objectmodel.utilities.ResolveOptions;
import com.microsoft.commondatamodel.objectmodel.utilities.StringUtils;
import com.microsoft.commondatamodel.objectmodel.utilities.logger.Logger;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public class RelationshipPersistence {
    private static String tag = RelationshipPersistence.class.getSimpleName();

    public static CompletableFuture<CdmE2ERelationship> fromData(CdmCorpusContext ctx, SingleKeyRelationship obj, Map<String, String> entityPathByName) {
        if (!entityPathByName.containsKey(obj.getFromAttribute().getEntityName())) {
            Logger.warning(ctx, tag, "fromData", null, CdmLogCode.WarnPersistRelUndefinedSourceEntity, obj.getFromAttribute().getEntityName());
            return CompletableFuture.completedFuture(null);
        }
        if (!entityPathByName.containsKey(obj.getToAttribute().getEntityName())) {
            Logger.warning(ctx, tag, "fromData", null, CdmLogCode.WarnPersistRelUndefinedSourceEntity, obj.getFromAttribute().getEntityName());
            return CompletableFuture.completedFuture(null);
        }
        CdmE2ERelationship relationship = (CdmE2ERelationship)ctx.getCorpus().makeObject(CdmObjectType.E2ERelationshipDef, obj.getName());
        return Utils.processAnnotationsFromData(ctx, obj, relationship.getExhibitsTraits()).thenApply(v -> {
            relationship.setExplanation(obj.getDescription());
            relationship.setFromEntity((String)entityPathByName.get(obj.getFromAttribute().getEntityName()));
            relationship.setToEntity((String)entityPathByName.get(obj.getToAttribute().getEntityName()));
            relationship.setFromEntityAttribute(obj.getFromAttribute().getAttributeName());
            relationship.setToEntityAttribute(obj.getToAttribute().getAttributeName());
            return relationship;
        });
    }

    public static CompletableFuture<SingleKeyRelationship> toData(CdmE2ERelationship instance, ResolveOptions resOpt, CopyOptions options) {
        AttributeReference fromAttribute = new AttributeReference();
        fromAttribute.setEntityName(RelationshipPersistence.getEntityName(instance.getFromEntity()));
        fromAttribute.setAttributeName(instance.getFromEntityAttribute());
        AttributeReference toAttribute = new AttributeReference();
        toAttribute.setEntityName(RelationshipPersistence.getEntityName(instance.getToEntity()));
        toAttribute.setAttributeName(instance.getToEntityAttribute());
        SingleKeyRelationship result = new SingleKeyRelationship();
        result.setType("SingleKeyRelationship");
        result.setDescription(instance.getExplanation());
        result.setName(instance.getName());
        result.setFromAttribute(fromAttribute);
        result.setToAttribute(toAttribute);
        Utils.processTraitsAndAnnotationsToData(instance.getCtx(), result, instance.getExhibitsTraits());
        return CompletableFuture.completedFuture(result);
    }

    private static String getEntityName(String corpusPath) {
        int lastSlashIndex = corpusPath.lastIndexOf("/");
        if (lastSlashIndex != -1) {
            return StringUtils.slice(corpusPath, lastSlashIndex + 1);
        }
        return corpusPath;
    }
}

