/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.commondatamodel.objectmodel.storage;

import com.google.common.base.Strings;
import com.microsoft.aad.adal4j.AuthenticationContext;
import com.microsoft.aad.adal4j.AuthenticationResult;
import com.microsoft.aad.adal4j.ClientCredential;
import com.microsoft.commondatamodel.objectmodel.storage.StorageAdapterException;
import com.microsoft.commondatamodel.objectmodel.utilities.network.TokenProvider;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;

class AdlsAdapterAuthenticator {
    private static final String HMAC_SHA256 = "HmacSHA256";
    private static final String HTTP_AUTHORIZATION = "Authorization";
    private static final String HTTP_XMS_DATE = "x-ms-date";
    private static final String HTTP_XMS_VERSION = "x-ms-version";
    private String sharedKey = null;
    private String tenant = null;
    private String clientId = null;
    private String secret = null;
    private String sasToken;
    private AuthenticationResult lastAuthenticationResult;
    private TokenProvider tokenProvider = null;

    AdlsAdapterAuthenticator() {
    }

    Map<String, String> buildAuthenticationHeader(String url, String method, String content, String contentType) throws NoSuchAlgorithmException, InvalidKeyException, URISyntaxException, UnsupportedEncodingException {
        if (this.sharedKey != null) {
            return this.buildAuthenticationHeaderWithSharedKey(url, method, content, contentType);
        }
        if (this.tokenProvider != null) {
            LinkedHashMap<String, String> header = new LinkedHashMap<String, String>();
            header.put("authorization", this.tokenProvider.getToken());
            return header;
        }
        if (this.clientId != null) {
            return this.buildAuthenticationHeaderWithClientIdAndSecret();
        }
        throw new StorageAdapterException("Adls adapter is not configured with any auth method");
    }

    String buildSasAuthenticatedUrl(String url) {
        return url + (url.contains("?") ? "&" : "?") + this.sasToken;
    }

    private Map<String, String> buildAuthenticationHeaderWithSharedKey(String url, String method, String content, String contentType) throws URISyntaxException, NoSuchAlgorithmException, InvalidKeyException, UnsupportedEncodingException {
        LinkedHashMap<String, String> headers = new LinkedHashMap<String, String>();
        headers.put(HTTP_XMS_DATE, DateTimeFormatter.RFC_1123_DATE_TIME.format(ZonedDateTime.now(ZoneOffset.ofHours(0))));
        headers.put(HTTP_XMS_VERSION, "2018-06-17");
        int contentLength = 0;
        if (content != null) {
            contentLength = content.getBytes().length;
        }
        URI uri = new URI(url);
        StringBuilder builder = new StringBuilder();
        builder.append(method).append("\n");
        builder.append("\n");
        builder.append("\n");
        builder.append(contentLength != 0 ? Integer.valueOf(contentLength) : "").append("\n");
        builder.append("\n");
        builder.append(contentType != null ? contentType : "").append("\n");
        builder.append("\n");
        builder.append("\n");
        builder.append("\n");
        builder.append("\n");
        builder.append("\n");
        builder.append("\n");
        for (Map.Entry header : headers.entrySet()) {
            builder.append((String)header.getKey()).append(":").append((String)header.getValue()).append("\n");
        }
        String accountName = uri.getHost().split("\\.")[0];
        builder.append("/").append(accountName);
        builder.append(uri.getRawPath());
        if (!Strings.isNullOrEmpty((String)uri.getQuery())) {
            String[] queryParts;
            String queryParameters = uri.getRawQuery();
            for (String item : queryParts = queryParameters.split("&")) {
                String[] keyValuePair = item.split("=");
                String queryName = keyValuePair[0].toLowerCase();
                String decodedValue = URLDecoder.decode(keyValuePair[1], "UTF-8");
                builder.append("\n").append(queryName).append(":").append(decodedValue);
            }
        }
        Mac sha256_HMAC = Mac.getInstance(HMAC_SHA256);
        SecretKeySpec secret_key = new SecretKeySpec(Base64.decodeBase64((byte[])this.sharedKey.getBytes()), HMAC_SHA256);
        sha256_HMAC.init(secret_key);
        String hash = Base64.encodeBase64String((byte[])sha256_HMAC.doFinal(builder.toString().getBytes(StandardCharsets.UTF_8)));
        headers.put(HTTP_AUTHORIZATION, "SharedKey " + accountName + ":" + hash);
        return headers;
    }

    private Map<String, String> buildAuthenticationHeaderWithClientIdAndSecret() {
        LinkedHashMap<String, String> header = new LinkedHashMap<String, String>();
        if (this.needsRefreshToken()) {
            this.refreshToken();
        }
        header.put("authorization", this.lastAuthenticationResult.getAccessTokenType() + " " + this.lastAuthenticationResult.getAccessToken());
        return header;
    }

    private boolean needsRefreshToken() {
        if (this.lastAuthenticationResult == null) {
            return true;
        }
        Date now = new Date();
        return this.lastAuthenticationResult.getExpiresOnDate().before(now);
    }

    private void refreshToken() {
        ExecutorService executorService = Executors.newFixedThreadPool(10);
        AuthenticationContext authenticationContext = null;
        try {
            authenticationContext = new AuthenticationContext("https://login.windows.net/" + this.tenant, true, executorService);
            ClientCredential clientCredentials = new ClientCredential(this.clientId, this.secret);
            this.lastAuthenticationResult = (AuthenticationResult)authenticationContext.acquireToken("https://storage.azure.com", clientCredentials, null).get();
        }
        catch (InterruptedException | MalformedURLException | ExecutionException e) {
            throw new StorageAdapterException("Failed to refresh AdlsAdapter's token", e);
        }
        finally {
            executorService.shutdown();
        }
    }

    String getSharedKey() {
        return this.sharedKey;
    }

    void setSharedKey(String sharedKey) {
        this.sharedKey = sharedKey;
    }

    String getTenant() {
        return this.tenant;
    }

    void setTenant(String tenant) {
        this.tenant = tenant;
    }

    String getClientId() {
        return this.clientId;
    }

    void setClientId(String clientId) {
        this.clientId = clientId;
    }

    String getSecret() {
        return this.secret;
    }

    void setSecret(String secret) {
        this.secret = secret;
    }

    String getSasToken() {
        return this.sasToken;
    }

    void setSasToken(String sasToken) {
        this.sasToken = sasToken != null ? (sasToken.startsWith("?") ? sasToken.substring(1) : sasToken) : null;
    }

    TokenProvider getTokenProvider() {
        return this.tokenProvider;
    }

    void setTokenProvider(TokenProvider tokenProvider) {
        this.tokenProvider = tokenProvider;
    }
}

