/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.commondatamodel.objectmodel.storage;

import com.microsoft.aad.adal4j.AuthenticationContext;
import com.microsoft.aad.adal4j.AuthenticationResult;
import com.microsoft.aad.adal4j.ClientCredential;
import com.microsoft.commondatamodel.objectmodel.storage.StorageAdapterBase;
import com.microsoft.commondatamodel.objectmodel.storage.StorageAdapterException;
import com.microsoft.commondatamodel.objectmodel.utilities.JMapper;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;

public class AzureStorageAdapter
extends StorageAdapterBase {
    private static final String RFC_1123_DATETIME_FORMAT = "EEE, dd MMM yyyy HH:mm:ss zzz";
    private final AuthenticationContext context;
    private final String root;
    private final String hostname;
    private final String tenant;
    private final String clientId;
    private final String resource;
    private final String secret;
    private String locationHint;

    public AzureStorageAdapter(String root, String hostname, String tenant, String clientId, String resource, String secret) throws MalformedURLException {
        this.root = root;
        this.hostname = hostname;
        this.tenant = tenant;
        this.clientId = clientId;
        this.resource = resource;
        this.secret = secret;
        ExecutorService execService = Executors.newFixedThreadPool(10);
        this.context = new AuthenticationContext("https://login.windows.net/" + tenant, true, execService);
    }

    @Override
    public boolean canRead() {
        return true;
    }

    @Override
    public CompletableFuture<String> readAsync(String corpusPath) {
        return CompletableFuture.supplyAsync(() -> {
            try (CloseableHttpClient httpClient = HttpClientBuilder.create().build();){
                HttpRequestBase httpGet = this.buildMessage("GET", corpusPath);
                try (CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpGet);){
                    String string;
                    int code = response.getStatusLine().getStatusCode();
                    if (200 == code) {
                        BufferedReader in = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
                        StringBuilder content = new StringBuilder();
                        while (true) {
                            String inputLine;
                            if (null == (inputLine = in.readLine())) {
                                String string2 = content.toString();
                                return string2;
                            }
                            content.append(inputLine);
                        }
                    }
                    HttpEntity resEntity = response.getEntity();
                    StringBuilder stringBuilder = new StringBuilder().append("Could not read Azure Storage content at path: ").append(corpusPath).append(".");
                    if (resEntity != null) {
                        string = " Reason: " + EntityUtils.toString((HttpEntity)resEntity);
                        throw new StorageAdapterException(stringBuilder.append(string).toString());
                    }
                    string = "";
                    throw new StorageAdapterException(stringBuilder.append(string).toString());
                }
            }
            catch (Exception e) {
                throw new StorageAdapterException("Could not read Azure Storage content at path: " + corpusPath, e);
            }
        });
    }

    @Override
    public boolean canWrite() {
        return true;
    }

    @Override
    public CompletableFuture<Void> writeAsync(String corpusPath, String data) {
        if (!this.ensurePath(this.root + corpusPath)) {
            throw new IllegalArgumentException("Could not create folder for document '" + corpusPath + "'");
        }
        return CompletableFuture.runAsync(() -> {
            try (CloseableHttpClient httpClient = HttpClientBuilder.create().build();){
                HttpPut httpPut = (HttpPut)this.buildMessage("PUT", corpusPath);
                StringEntity entity = new StringEntity(JMapper.WRITER.writeValueAsString((Object)data), "UTF-8");
                entity.setContentType("application/json; charset=utf-8");
                httpPut.setEntity((HttpEntity)entity);
                try (CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPut);){
                    int code = response.getStatusLine().getStatusCode();
                    if (201 != code) {
                        HttpEntity resEntity = response.getEntity();
                        throw new StorageAdapterException("Could not write Azure Storage content at path: " + corpusPath + "." + (resEntity != null ? " Reason: " + EntityUtils.toString((HttpEntity)resEntity) : ""));
                    }
                }
            }
            catch (Exception e) {
                throw new StorageAdapterException("Could not write Azure Storage content at path: " + corpusPath, e);
            }
        });
    }

    public CompletableFuture<Boolean> dirExistsAsync(String folderName) {
        return CompletableFuture.completedFuture(true);
    }

    @Override
    public String createAdapterPath(String corpusPath) {
        return "https://" + this.hostname + this.root + corpusPath;
    }

    @Override
    public String createCorpusPath(String adapterPath) {
        String prefix = "https://" + this.hostname + this.root;
        if (adapterPath.startsWith(prefix)) {
            return adapterPath.substring(prefix.length());
        }
        return null;
    }

    private Future<AuthenticationResult> generateBearerToken() {
        ClientCredential clientCredentials = new ClientCredential(this.clientId, this.secret);
        return this.context.acquireToken(this.resource, clientCredentials, null);
    }

    private HttpRequestBase buildMessage(String method, String path) throws InterruptedException, ExecutionException {
        HttpGet result;
        String fullPath = "https://" + this.hostname + this.root + path;
        if (method.equalsIgnoreCase("GET")) {
            result = new HttpGet(fullPath);
        } else if (method.equalsIgnoreCase("PUT")) {
            result = new HttpPut(fullPath);
        } else {
            throw new IllegalArgumentException("Only HTTP methods GET and PUT are supported");
        }
        AuthenticationResult token = this.generateBearerToken().get();
        result.setHeader("authorization", token.getAccessTokenType() + " " + token.getAccessToken());
        SimpleDateFormat sdf = new SimpleDateFormat(RFC_1123_DATETIME_FORMAT, Locale.US);
        sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
        result.setHeader("x-ms-date", sdf.format(new Date()));
        result.setHeader("x-ms-version", "2018-03-28");
        if (method.equalsIgnoreCase("PUT")) {
            result.setHeader("x-ms-blob-type", "BlockBlob");
        }
        return result;
    }

    private boolean ensurePath(String pathFor) {
        return pathFor.lastIndexOf("/") != -1;
    }
}

