/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.commondatamodel.objectmodel.storage;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Strings;
import com.microsoft.commondatamodel.objectmodel.storage.NetworkAdapter;
import com.microsoft.commondatamodel.objectmodel.storage.StorageAdapterException;
import com.microsoft.commondatamodel.objectmodel.utilities.JMapper;
import com.microsoft.commondatamodel.objectmodel.utilities.StringUtils;
import com.microsoft.commondatamodel.objectmodel.utilities.network.CdmHttpClient;
import com.microsoft.commondatamodel.objectmodel.utilities.network.CdmHttpRequest;
import com.microsoft.commondatamodel.objectmodel.utilities.network.CdmHttpResponse;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public class CdmStandardsAdapter
extends NetworkAdapter {
    private static final String STANDARDS_ENDPOINT = "https://cdm-schema.microsoft.com";
    static final String TYPE = "cdm-standards";
    private String root;

    public CdmStandardsAdapter() {
        this("/logical");
    }

    public CdmStandardsAdapter(String root) {
        this.root = root;
        this.httpClient = new CdmHttpClient(STANDARDS_ENDPOINT);
    }

    @Override
    public String fetchConfig() {
        ObjectNode resultConfig = JsonNodeFactory.instance.objectNode();
        resultConfig.put("type", TYPE);
        ObjectNode configObject = JsonNodeFactory.instance.objectNode();
        for (Map.Entry<String, JsonNode> stringJsonNodeEntry : this.fetchNetworkConfig().entrySet()) {
            configObject.set(stringJsonNodeEntry.getKey(), stringJsonNodeEntry.getValue());
        }
        String locationHint = this.getLocationHint();
        if (locationHint != null) {
            configObject.put("locationHint", locationHint);
        }
        if (this.root != null) {
            configObject.put("root", this.root);
        }
        resultConfig.set("config", (JsonNode)configObject);
        try {
            return JMapper.WRITER.writeValueAsString((Object)resultConfig);
        }
        catch (JsonProcessingException e) {
            throw new StorageAdapterException("Failed to construct config string.", (Exception)((Object)e));
        }
    }

    @Override
    public boolean canRead() {
        return true;
    }

    @Override
    public CompletableFuture<String> readAsync(String corpusPath) {
        return CompletableFuture.supplyAsync(() -> {
            String path = this.root + corpusPath;
            CdmHttpRequest cdmHttpRequest = this.setUpCdmRequest(path, null, "GET");
            try {
                CdmHttpResponse res = this.executeRequest(cdmHttpRequest).get();
                return res != null ? res.getContent() : null;
            }
            catch (Exception e) {
                throw new StorageAdapterException("Could not read content at path: " + path, e);
            }
        });
    }

    @Override
    public String createAdapterPath(String corpusPath) {
        return this.getAbsolutePath() + corpusPath;
    }

    @Override
    public String createCorpusPath(String adapterPath) {
        if (Strings.isNullOrEmpty((String)adapterPath) || !adapterPath.startsWith(this.getAbsolutePath())) {
            return null;
        }
        return StringUtils.slice(adapterPath, this.getAbsolutePath().length());
    }

    @Override
    public void updateConfig(String config) throws IOException {
        if (config == null) {
            return;
        }
        this.updateNetworkConfig(config);
        JsonNode configsJson = JMapper.MAP.readTree(config);
        this.setLocationHint(configsJson.has("locationHint") ? configsJson.get("locationHint").asText() : null);
        this.root = configsJson.has("root") ? configsJson.get("root").asText() : null;
    }

    public void setRoot(String root) {
        this.root = root;
    }

    public String getRoot() {
        return this.root;
    }

    private String getAbsolutePath() {
        return STANDARDS_ENDPOINT + this.root;
    }
}

