/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.commondatamodel.objectmodel.storage;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.microsoft.commondatamodel.objectmodel.storage.StorageAdapterBase;
import com.microsoft.commondatamodel.objectmodel.storage.StorageAdapterException;
import com.microsoft.commondatamodel.objectmodel.utilities.JMapper;
import com.microsoft.commondatamodel.objectmodel.utilities.network.CdmHttpClient;
import com.microsoft.commondatamodel.objectmodel.utilities.network.CdmHttpRequest;
import com.microsoft.commondatamodel.objectmodel.utilities.network.CdmHttpRequestException;
import com.microsoft.commondatamodel.objectmodel.utilities.network.CdmHttpResponse;
import java.io.IOException;
import java.time.Duration;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;

public abstract class NetworkAdapter
extends StorageAdapterBase {
    protected static final Duration DEFAULT_TIMEOUT = Duration.ofMillis(5000L);
    private static final Duration DEFAULT_MAXIMUM_TIMEOUT = Duration.ofMillis(20000L);
    private static final int DEFAULT_NUMBER_OF_RETRIES = 2;
    private static final int DEFAULT_SHORTEST_TIME_WAIT = 500;
    protected CdmHttpClient httpClient;
    protected Duration timeout = DEFAULT_TIMEOUT;
    protected Duration maximumTimeout = DEFAULT_MAXIMUM_TIMEOUT;
    protected int numberOfRetries = 2;
    protected CdmHttpClient.Callback waitTimeCallback = NetworkAdapter::defaultCallback;

    public CdmHttpClient getHttpClient() {
        return this.httpClient;
    }

    public void setHttpClient(CdmHttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public Duration getTimeout() {
        return this.timeout;
    }

    public void setTimeout(Duration timeout) {
        this.timeout = timeout;
    }

    public Duration getMaximumTimeout() {
        return this.maximumTimeout;
    }

    public void setMaximumTimeout(Duration maximumTimeout) {
        this.maximumTimeout = maximumTimeout;
    }

    public int getNumberOfRetries() {
        return this.numberOfRetries;
    }

    public void setNumberOfRetries(int numberOfRetries) {
        this.numberOfRetries = numberOfRetries < 0 ? 2 : numberOfRetries;
    }

    public CdmHttpClient.Callback getWaitTimeCallback() {
        return this.waitTimeCallback;
    }

    public void setWaitTimeCallback(CdmHttpClient.Callback waitTimeCallback) {
        this.waitTimeCallback = waitTimeCallback;
    }

    CdmHttpRequest setUpCdmRequest(String path, String method) {
        return this.setUpCdmRequest(path, null, method);
    }

    CdmHttpRequest setUpCdmRequest(String path, Map<String, String> headers, String method) {
        CdmHttpRequest cdmHttpRequest = new CdmHttpRequest(path, this.numberOfRetries);
        LinkedHashMap<String, String> internalHeaders = headers != null ? headers : new LinkedHashMap<String, String>();
        cdmHttpRequest.setHeaders(internalHeaders);
        cdmHttpRequest.setTimeout(this.timeout);
        cdmHttpRequest.setMaximumTimeout(this.maximumTimeout);
        cdmHttpRequest.setNumberOfRetries(this.numberOfRetries);
        cdmHttpRequest.setMethod(method);
        return cdmHttpRequest;
    }

    CompletableFuture<CdmHttpResponse> executeRequest(CdmHttpRequest request) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                CdmHttpResponse response = this.httpClient.sendAsync(request, this.waitTimeCallback, this.getCtx()).get();
                if (response == null) {
                    return null;
                }
                if (!response.isSuccessful()) {
                    throw new CdmHttpRequestException(String.format("HTTP %d - %s. Response headers: %s. URL: %s", response.getStatusCode(), response.getReason(), response.getResponseHeaders().entrySet().stream().map(entry -> entry + (String)entry.getKey() + ":" + (String)entry.getValue()).collect(Collectors.joining(",")), request.stripSasSig()));
                }
                return response;
            }
            catch (InterruptedException | ExecutionException ex) {
                throw new RuntimeException(ex);
            }
        });
    }

    private static Duration defaultCallback(CdmHttpResponse response, boolean hasFailed, int retryNumber) {
        if (response != null && response.isSuccessful() && !hasFailed) {
            return null;
        }
        Random random = new Random();
        int waitTime = random.nextInt(1 << retryNumber) * 500;
        return Duration.ofMillis(waitTime);
    }

    public void updateNetworkConfig(String config) {
        JsonNode configsJson = null;
        try {
            configsJson = JMapper.MAP.readTree(config);
        }
        catch (IOException e) {
            throw new StorageAdapterException("Cannot convert config to JsonNode", e);
        }
        if (configsJson.has("timeout")) {
            this.timeout = Duration.ofMillis(configsJson.get("timeout").asLong());
        }
        if (configsJson.has("maximumTimeout")) {
            this.maximumTimeout = Duration.ofMillis(configsJson.get("maximumTimeout").asLong());
        }
        if (configsJson.has("numberOfRetries")) {
            this.numberOfRetries = configsJson.get("numberOfRetries").asInt();
        }
    }

    protected Map<String, JsonNode> fetchNetworkConfig() {
        LinkedHashMap<String, JsonNode> config = new LinkedHashMap<String, JsonNode>();
        config.put("timeout", (JsonNode)JsonNodeFactory.instance.numberNode(this.timeout.toMillis()));
        config.put("maximumTimeout", (JsonNode)JsonNodeFactory.instance.numberNode(this.maximumTimeout.toMillis()));
        config.put("numberOfRetries", (JsonNode)JsonNodeFactory.instance.numberNode(this.numberOfRetries));
        return config;
    }
}

