/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.commondatamodel.objectmodel.utilities.logger;

import com.microsoft.commondatamodel.objectmodel.cdm.CdmCorpusContext;
import com.microsoft.commondatamodel.objectmodel.enums.CdmLogCode;
import com.microsoft.commondatamodel.objectmodel.enums.CdmStatusLevel;
import com.microsoft.commondatamodel.objectmodel.utilities.TimeUtils;
import java.text.MessageFormat;
import java.time.Duration;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.function.Consumer;
import org.slf4j.LoggerFactory;

public class Logger {
    private static final org.slf4j.Logger defaultLogger = LoggerFactory.getLogger(Logger.class);
    private static final ResourceBundle resource = ResourceBundle.getBundle("LogMessages");

    public static void debug(CdmCorpusContext ctx, String classname, String method, String corpuspath, String message) {
        if (CdmStatusLevel.Progress.compareTo(ctx.getReportAtLevel()) >= 0) {
            Consumer<String> statusEvent = arg_0 -> ((org.slf4j.Logger)defaultLogger).debug(arg_0);
            Logger.log(CdmStatusLevel.Progress, ctx, classname, message, method, statusEvent, corpuspath, CdmLogCode.None);
        }
    }

    public static void info(CdmCorpusContext ctx, String classname, String method, String corpuspath, String message) {
        if (CdmStatusLevel.Info.compareTo(ctx.getReportAtLevel()) >= 0) {
            Consumer<String> statusEvent = arg_0 -> ((org.slf4j.Logger)defaultLogger).info(arg_0);
            Logger.log(CdmStatusLevel.Info, ctx, classname, message, method, statusEvent, corpuspath, CdmLogCode.None);
        }
    }

    public static void warning(CdmCorpusContext ctx, String classname, String method, String corpuspath, CdmLogCode code, String ... args) {
        if (CdmStatusLevel.Warning.compareTo(ctx.getReportAtLevel()) >= 0) {
            Consumer<String> statusEvent = arg_0 -> ((org.slf4j.Logger)defaultLogger).warn(arg_0);
            String message = Logger.getMessagefromResourceFile(code, args);
            Logger.log(CdmStatusLevel.Warning, ctx, classname, message, method, statusEvent, corpuspath, code);
        }
    }

    public static void error(CdmCorpusContext ctx, String classname, String method, String corpuspath, CdmLogCode code, String ... args) {
        if (CdmStatusLevel.Error.compareTo(ctx.getReportAtLevel()) >= 0) {
            Consumer<String> statusEvent = arg_0 -> ((org.slf4j.Logger)defaultLogger).error(arg_0);
            String message = Logger.getMessagefromResourceFile(code, args);
            Logger.log(CdmStatusLevel.Error, ctx, classname, message, method, statusEvent, corpuspath, code);
        }
    }

    private static String formatMessage(String classname, String message) {
        return Logger.formatMessage(classname, message, null, null, null);
    }

    private static String formatMessage(String classname, String message, String method) {
        return Logger.formatMessage(classname, message, method, null, null);
    }

    private static String formatMessage(String classname, String message, String method, String correlationId, String corpuspath) {
        StringBuilder strBuf = new StringBuilder();
        strBuf.append(classname).append(" | ").append(message);
        if (method != null) {
            strBuf.append(" | ").append(method);
        }
        if (correlationId != null) {
            strBuf.append(" | ").append(correlationId);
        }
        if (corpuspath != null) {
            strBuf.append(" | ").append(corpuspath);
        }
        return strBuf.toString();
    }

    private static void log(CdmStatusLevel level, CdmCorpusContext ctx, String classname, String message, String method, Consumer<String> defaultStatusEvent, String corpuspath, CdmLogCode code) {
        if (ctx.getEvents().isRecording()) {
            HashMap<String, String> theEvent = new HashMap<String, String>();
            theEvent.put("timestamp", TimeUtils.formatDateStringIfNotNull(OffsetDateTime.now(ZoneOffset.UTC)));
            theEvent.put("level", level.name());
            theEvent.put("class", classname);
            theEvent.put("message", message);
            theEvent.put("method", method);
            if (ctx.getCorrelationId() != null) {
                theEvent.put("code", code.name());
            }
            if (ctx.getCorrelationId() != null) {
                theEvent.put("correlationId", ctx.getCorrelationId());
            }
            if (corpuspath != null) {
                theEvent.put("corpuspath", corpuspath);
            }
            ctx.getEvents().add((Map<String, String>)theEvent);
        }
        String formattedMessage = Logger.formatMessage(classname, message, method, ctx.getCorrelationId(), corpuspath);
        if (ctx.getStatusEvent() != null) {
            ctx.getStatusEvent().apply(level, formattedMessage);
        } else {
            defaultStatusEvent.accept(message);
        }
    }

    private static String getMessagefromResourceFile(CdmLogCode code, String ... args) {
        StringBuilder builder = new StringBuilder(resource.getString(code.toString()));
        int i = 0;
        for (String x : args) {
            String from = "{" + i + "}";
            builder = builder.replace(builder.indexOf(from), builder.indexOf(from) + from.length(), x);
            ++i;
        }
        return builder.toString();
    }

    @Deprecated
    public static String format(String str, Object ... arguments) {
        if (str == null) {
            return null;
        }
        return MessageFormat.format(str.replace("'", "''"), arguments);
    }

    public static LoggerScope enterScope(String classname, CdmCorpusContext ctx, String path) {
        return new LoggerScope(new TState(classname, ctx, path));
    }

    public static class LoggerScope
    implements AutoCloseable {
        private final TState state;
        private Instant time = Instant.now();

        public LoggerScope(TState state) {
            this.state = state;
            state.ctx.getEvents().enable();
            Logger.debug(state.ctx, state.classname, state.path, null, "Entering scope");
        }

        @Override
        public void close() {
            Logger.debug(this.state.ctx, this.state.classname, this.state.path, null, Logger.format("Leaving scope. Time Elapsed: {0} ms :", String.valueOf(Duration.between(this.time, Instant.now()).toMillis())));
            this.state.ctx.getEvents().disable();
        }
    }

    private static class TState {
        public String classname;
        public CdmCorpusContext ctx;
        public String path;

        public TState(String classname, CdmCorpusContext ctx, String path) {
            this.classname = classname;
            this.ctx = ctx;
            this.path = path;
        }
    }
}

