/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.commondatamodel.objectmodel.cdm;

import com.microsoft.commondatamodel.objectmodel.cdm.CdmCorpusContext;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmObject;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmObjectBase;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmObjectSimple;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmTypeAttributeDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.EntityByReference;
import com.microsoft.commondatamodel.objectmodel.cdm.Expansion;
import com.microsoft.commondatamodel.objectmodel.cdm.SelectsSubAttribute;
import com.microsoft.commondatamodel.objectmodel.enums.CdmObjectType;
import com.microsoft.commondatamodel.objectmodel.utilities.CopyOptions;
import com.microsoft.commondatamodel.objectmodel.utilities.ResolveOptions;
import com.microsoft.commondatamodel.objectmodel.utilities.VisitCallback;
import java.util.ArrayList;
import java.util.List;

public class CdmAttributeResolutionGuidance
extends CdmObjectSimple {
    private Boolean removeAttribute;
    private List<String> imposedDirectives;
    private List<String> removedDirectives;
    private CdmTypeAttributeDefinition addSupportingAttribute;
    private String cardinality;
    private String renameFormat;
    private EntityByReference entityByReference;
    private Expansion expansion;
    private SelectsSubAttribute selectsSubAttribute;

    public CdmAttributeResolutionGuidance(CdmCorpusContext ctx) {
        super(ctx);
        this.setObjectType(CdmObjectType.AttributeResolutionGuidanceDef);
    }

    @Override
    public boolean visit(String pathFrom, VisitCallback preChildren, VisitCallback postChildren) {
        if (preChildren != null && preChildren.invoke(this, pathFrom)) {
            return false;
        }
        if (this.getAddSupportingAttribute() != null && this.getAddSupportingAttribute().visit(pathFrom + "addSupportingAttribute/", preChildren, postChildren)) {
            return true;
        }
        if (this.getExpansion() != null && this.getExpansion().getCountAttribute() != null && this.getExpansion().getCountAttribute().visit(pathFrom + "countAttribute/", preChildren, postChildren)) {
            return true;
        }
        if (this.getEntityByReference() != null && this.getEntityByReference().getForeignKeyAttribute() != null && this.getEntityByReference().getForeignKeyAttribute().visit(pathFrom + "foreignKeyAttribute/", preChildren, postChildren)) {
            return true;
        }
        if (this.getSelectsSubAttribute() != null && this.getSelectsSubAttribute().getSelectedTypeAttribute() != null && this.getSelectsSubAttribute().getSelectedTypeAttribute().visit(pathFrom + "selectedTypeAttribute/", preChildren, postChildren)) {
            return true;
        }
        return postChildren != null && postChildren.invoke(this, pathFrom);
    }

    void updateAttributeDefaults(String attName, CdmObject owner) {
        if (this.cardinality == null) {
            this.cardinality = this.expansion != null ? "many" : "one";
        }
        if ("many".equals(this.cardinality) && this.expansion == null) {
            this.expansion = new Expansion();
        }
        if ("many".equals(this.cardinality)) {
            if (this.expansion.getStartingOrdinal() == null) {
                this.expansion.setStartingOrdinal(0);
            }
            if (this.expansion.getMaximumExpansion() == null) {
                this.expansion.setMaximumExpansion(5);
            }
            if (this.expansion.getCountAttribute() == null) {
                this.expansion.setCountAttribute(this.getCtx().getCorpus().fetchArtifactAttribute("count"));
                this.expansion.countAttribute.setOwner(owner);
                this.expansion.countAttribute.setInDocument(owner.getInDocument());
            }
        }
        if (this.entityByReference != null) {
            if (this.entityByReference.doesAllowReference() == null) {
                this.entityByReference.setAllowReference(true);
            }
            if (this.entityByReference.doesAllowReference().booleanValue()) {
                if (this.entityByReference.doesAlwaysIncludeForeignKey() == null) {
                    this.entityByReference.setAlwaysIncludeForeignKey(false);
                }
                if (this.entityByReference.getForeignKeyAttribute() == null) {
                    this.entityByReference.setForeignKeyAttribute(this.getCtx().getCorpus().fetchArtifactAttribute("id"));
                    this.entityByReference.getForeignKeyAttribute().setOwner(owner);
                    this.entityByReference.getForeignKeyAttribute().setInDocument(owner.getInDocument());
                }
            }
        }
        if (this.selectsSubAttribute != null) {
            if (this.selectsSubAttribute.getSelects() == null) {
                this.selectsSubAttribute.setSelects("one");
            }
            if ("one".equals(this.selectsSubAttribute.getSelects()) && this.selectsSubAttribute.getSelectedTypeAttribute() == null) {
                this.selectsSubAttribute.setSelectedTypeAttribute(this.getCtx().getCorpus().fetchArtifactAttribute("type"));
                this.selectsSubAttribute.getSelectedTypeAttribute().setOwner(owner);
                this.selectsSubAttribute.getSelectedTypeAttribute().setInDocument(owner.getInDocument());
            }
        }
        if (this.renameFormat == null) {
            if (attName == null) {
                if ("many".equals(this.cardinality)) {
                    this.renameFormat = "{a}{o}";
                }
            } else {
                this.renameFormat = "many".equals(this.cardinality) ? "{a}{o}{M}" : "{a}{M}";
            }
        }
        if (this.renameFormat != null && attName != null) {
            int iM;
            boolean upper = false;
            int iA = this.renameFormat.indexOf("{a}");
            if (iA < 0) {
                iA = this.renameFormat.indexOf("{A}");
                upper = true;
            }
            if (iA >= 0) {
                if (upper) {
                    attName = Character.toString(attName.charAt(0)).toUpperCase() + attName.substring(1);
                }
                this.renameFormat = this.renameFormat.substring(0, iA) + attName + this.renameFormat.substring(iA + 3);
            }
            if ((iM = this.renameFormat.indexOf("{m}")) >= 0) {
                this.renameFormat = this.renameFormat.substring(0, iM) + "{a}" + this.renameFormat.substring(iM + 3);
            } else {
                iM = this.renameFormat.indexOf("{M}");
                if (iM >= 0) {
                    this.renameFormat = this.renameFormat.substring(0, iM) + "{A}" + this.renameFormat.substring(iM + 3);
                }
            }
        }
    }

    public Boolean getRemoveAttribute() {
        return this.removeAttribute;
    }

    public void setRemoveAttribute(Boolean value) {
        this.removeAttribute = value;
    }

    public List<String> getImposedDirectives() {
        return this.imposedDirectives;
    }

    public void setImposedDirectives(List<String> value) {
        this.imposedDirectives = value;
    }

    public List<String> getRemovedDirectives() {
        return this.removedDirectives;
    }

    public void setRemovedDirectives(List<String> value) {
        this.removedDirectives = value;
    }

    public CdmTypeAttributeDefinition getAddSupportingAttribute() {
        return this.addSupportingAttribute;
    }

    public void setAddSupportingAttribute(CdmTypeAttributeDefinition value) {
        this.addSupportingAttribute = value;
    }

    public String getCardinality() {
        return this.cardinality;
    }

    public void setCardinality(String value) {
        this.cardinality = value;
    }

    public String getRenameFormat() {
        return this.renameFormat;
    }

    public void setRenameFormat(String value) {
        this.renameFormat = value;
    }

    public Expansion getExpansion() {
        return this.expansion;
    }

    public void setExpansion(Expansion value) {
        this.expansion = value;
    }

    public Expansion makeExpansion() {
        return new Expansion();
    }

    public EntityByReference getEntityByReference() {
        return this.entityByReference;
    }

    public void setEntityByReference(EntityByReference value) {
        this.entityByReference = value;
    }

    public EntityByReference makeEntityByReference() {
        return new EntityByReference();
    }

    public SelectsSubAttribute getSelectsSubAttribute() {
        return this.selectsSubAttribute;
    }

    public void setSelectsSubAttribute(SelectsSubAttribute value) {
        this.selectsSubAttribute = value;
    }

    public SelectsSubAttribute makeSelectsSubAttribute() {
        return new SelectsSubAttribute();
    }

    @Override
    public boolean validate() {
        return true;
    }

    @Override
    @Deprecated
    public Object copyData(ResolveOptions resOpt, CopyOptions options) {
        return CdmObjectBase.copyData(this, resOpt, options, CdmAttributeResolutionGuidance.class);
    }

    @Override
    public CdmObject copy(ResolveOptions resOpt, CdmObject host) {
        CdmAttributeResolutionGuidance copy;
        if (resOpt == null) {
            resOpt = new ResolveOptions(this, this.getCtx().getCorpus().getDefaultResolutionDirectives());
        }
        if (host == null) {
            copy = new CdmAttributeResolutionGuidance(this.getCtx());
        } else {
            copy = (CdmAttributeResolutionGuidance)host;
            copy.setCtx(this.getCtx());
            copy.setExpansion(null);
            copy.setEntityByReference(null);
            copy.setSelectsSubAttribute(null);
        }
        copy.setRemoveAttribute(this.getRemoveAttribute());
        if (this.getImposedDirectives() != null) {
            copy.setImposedDirectives(new ArrayList<String>(this.getImposedDirectives()));
        }
        if (this.getRemovedDirectives() != null) {
            copy.setRemovedDirectives(new ArrayList<String>(this.getRemovedDirectives()));
        }
        copy.setAddSupportingAttribute(this.getAddSupportingAttribute());
        copy.setCardinality(this.getCardinality());
        copy.setRenameFormat(this.getRenameFormat());
        if (this.getExpansion() != null) {
            Expansion expansion = new Expansion();
            expansion.setStartingOrdinal(this.getExpansion().getStartingOrdinal());
            expansion.setMaximumExpansion(this.getExpansion().getMaximumExpansion());
            expansion.setCountAttribute(this.getExpansion().getCountAttribute());
            copy.setExpansion(expansion);
        }
        if (this.entityByReference != null) {
            EntityByReference entityByReference = new EntityByReference();
            entityByReference.setAlwaysIncludeForeignKey(this.getEntityByReference().doesAlwaysIncludeForeignKey());
            entityByReference.setReferenceOnlyAfterDepth(this.getEntityByReference().getReferenceOnlyAfterDepth());
            entityByReference.setAllowReference(this.getEntityByReference().doesAllowReference());
            entityByReference.setForeignKeyAttribute(this.getEntityByReference().getForeignKeyAttribute());
            copy.setEntityByReference(entityByReference);
        }
        if (this.selectsSubAttribute != null) {
            SelectsSubAttribute selectsSubAttribute = new SelectsSubAttribute();
            selectsSubAttribute.setSelects(this.getSelectsSubAttribute().getSelects());
            selectsSubAttribute.setSelectedTypeAttribute(this.getSelectsSubAttribute().getSelectedTypeAttribute());
            selectsSubAttribute.setSelectsSomeTakeNames(this.getSelectsSubAttribute().getSelectsSomeTakeNames());
            selectsSubAttribute.setSelectsSomeAvoidNames(this.getSelectsSubAttribute().getSelectsSomeAvoidNames());
            copy.setSelectsSubAttribute(selectsSubAttribute);
        }
        return copy;
    }

    @Deprecated
    public CdmAttributeResolutionGuidance combineResolutionGuidance(CdmAttributeResolutionGuidance addIn) {
        CdmAttributeResolutionGuidance startWith = this;
        if (addIn == null) {
            return startWith;
        }
        if (startWith == null) {
            return addIn;
        }
        CdmAttributeResolutionGuidance result = new CdmAttributeResolutionGuidance(this.getCtx());
        if (startWith.removeAttribute != null && startWith.removeAttribute.booleanValue()) {
            if (addIn.removeAttribute == null || addIn.removeAttribute.booleanValue()) {
                result.removeAttribute = true;
            }
        } else if (addIn.removeAttribute != null && addIn.removeAttribute.booleanValue()) {
            result.removeAttribute = true;
        }
        if (addIn.imposedDirectives != null) {
            result.imposedDirectives = startWith.imposedDirectives != null ? new ArrayList<String>(startWith.imposedDirectives) : new ArrayList<String>();
            result.imposedDirectives.addAll(addIn.imposedDirectives);
        } else {
            result.imposedDirectives = startWith.imposedDirectives;
        }
        if (addIn.removedDirectives != null) {
            result.removedDirectives = startWith.removedDirectives != null ? new ArrayList<String>(startWith.removedDirectives) : new ArrayList<String>();
            result.removedDirectives.addAll(addIn.removedDirectives);
        } else {
            result.removedDirectives = startWith.removedDirectives;
        }
        result.addSupportingAttribute = startWith.addSupportingAttribute;
        if (addIn.addSupportingAttribute != null) {
            result.addSupportingAttribute = addIn.addSupportingAttribute;
        }
        result.cardinality = startWith.cardinality;
        if (addIn.cardinality != null) {
            result.cardinality = addIn.cardinality;
        }
        result.renameFormat = startWith.renameFormat;
        if (addIn.renameFormat != null) {
            result.renameFormat = addIn.renameFormat;
        }
        if (addIn.expansion != null) {
            if (startWith.expansion != null) {
                result.expansion = new Expansion();
                result.expansion.setStartingOrdinal(startWith.expansion.getStartingOrdinal());
                if (addIn.expansion.getStartingOrdinal() != null) {
                    result.expansion.setStartingOrdinal(addIn.expansion.getStartingOrdinal());
                }
                result.expansion.setMaximumExpansion(startWith.expansion.getMaximumExpansion());
                if (addIn.expansion.getMaximumExpansion() != null) {
                    result.expansion.setMaximumExpansion(addIn.expansion.getMaximumExpansion());
                }
                result.expansion.setCountAttribute(startWith.expansion.getCountAttribute());
                if (addIn.expansion.getCountAttribute() != null) {
                    result.expansion.setCountAttribute(addIn.expansion.getCountAttribute());
                }
            } else {
                result.expansion = addIn.expansion;
            }
        } else {
            result.expansion = startWith.expansion;
        }
        if (addIn.entityByReference != null) {
            if (startWith.entityByReference != null) {
                result.entityByReference = new EntityByReference();
                result.entityByReference.setAlwaysIncludeForeignKey(startWith.entityByReference.doesAlwaysIncludeForeignKey());
                if (addIn.entityByReference.doesAlwaysIncludeForeignKey() != null) {
                    result.entityByReference.setAlwaysIncludeForeignKey(addIn.entityByReference.doesAlwaysIncludeForeignKey());
                }
                result.entityByReference.setReferenceOnlyAfterDepth(startWith.entityByReference.getReferenceOnlyAfterDepth());
                if (addIn.entityByReference.getReferenceOnlyAfterDepth() != null) {
                    result.entityByReference.setReferenceOnlyAfterDepth(addIn.entityByReference.getReferenceOnlyAfterDepth());
                }
                result.entityByReference.setForeignKeyAttribute(startWith.entityByReference.getForeignKeyAttribute());
                if (addIn.entityByReference.getForeignKeyAttribute() != null) {
                    result.entityByReference.setForeignKeyAttribute(addIn.entityByReference.getForeignKeyAttribute());
                }
                result.entityByReference.setAllowReference(startWith.entityByReference.doesAllowReference());
                if (addIn.entityByReference.doesAllowReference() != null) {
                    result.entityByReference.setAllowReference(addIn.entityByReference.doesAllowReference());
                }
            } else {
                result.entityByReference = addIn.entityByReference;
            }
        } else {
            result.entityByReference = startWith.entityByReference;
        }
        if (addIn.selectsSubAttribute != null) {
            if (startWith.selectsSubAttribute != null) {
                result.selectsSubAttribute = new SelectsSubAttribute();
                result.selectsSubAttribute.setSelectedTypeAttribute(startWith.selectsSubAttribute.getSelectedTypeAttribute());
                if (addIn.selectsSubAttribute.getSelectedTypeAttribute() != null) {
                    result.selectsSubAttribute.setSelectedTypeAttribute(addIn.selectsSubAttribute.getSelectedTypeAttribute());
                }
                result.selectsSubAttribute.setSelects(startWith.selectsSubAttribute.getSelects());
                if (addIn.selectsSubAttribute.getSelects() != null) {
                    result.selectsSubAttribute.setSelects(addIn.selectsSubAttribute.getSelects());
                }
                if (addIn.selectsSubAttribute.getSelectsSomeTakeNames() != null) {
                    if (startWith.selectsSubAttribute.getSelectsSomeTakeNames() != null) {
                        result.selectsSubAttribute.setSelectsSomeTakeNames(new ArrayList<String>(startWith.selectsSubAttribute.getSelectsSomeTakeNames()));
                    } else {
                        result.selectsSubAttribute.setSelectsSomeTakeNames(new ArrayList<String>());
                    }
                    result.selectsSubAttribute.getSelectsSomeTakeNames().addAll(addIn.selectsSubAttribute.getSelectsSomeTakeNames());
                }
                if (addIn.selectsSubAttribute.getSelectsSomeAvoidNames() != null) {
                    if (startWith.selectsSubAttribute.getSelectsSomeAvoidNames() != null) {
                        result.selectsSubAttribute.setSelectsSomeAvoidNames(new ArrayList<String>(startWith.selectsSubAttribute.getSelectsSomeAvoidNames()));
                    } else {
                        result.selectsSubAttribute.setSelectsSomeAvoidNames(new ArrayList<String>());
                    }
                    result.selectsSubAttribute.getSelectsSomeAvoidNames().addAll(addIn.selectsSubAttribute.getSelectsSomeAvoidNames());
                }
            } else {
                result.selectsSubAttribute = addIn.selectsSubAttribute;
            }
        } else {
            result.selectsSubAttribute = startWith.selectsSubAttribute;
        }
        return result;
    }
}

