/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.commondatamodel.objectmodel.persistence.cdmfolder;

import com.google.common.base.Strings;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmCorpusContext;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmImport;
import com.microsoft.commondatamodel.objectmodel.enums.CdmLogCode;
import com.microsoft.commondatamodel.objectmodel.enums.CdmObjectType;
import com.microsoft.commondatamodel.objectmodel.persistence.cdmfolder.types.Import;
import com.microsoft.commondatamodel.objectmodel.utilities.CopyOptions;
import com.microsoft.commondatamodel.objectmodel.utilities.ResolveOptions;
import com.microsoft.commondatamodel.objectmodel.utilities.logger.Logger;

public class ImportPersistence {
    private static final String TAG = ImportPersistence.class.getSimpleName();

    public static CdmImport fromData(CdmCorpusContext ctx, Import obj) {
        if (obj == null) {
            Logger.error(ctx, TAG, "fromData", null, CdmLogCode.ErrPersistJsonImportConversionError, new String[0]);
            return null;
        }
        CdmImport theImport = (CdmImport)ctx.getCorpus().makeObject(CdmObjectType.Import);
        String corpusPath = obj.getCorpusPath();
        if (Strings.isNullOrEmpty((String)corpusPath)) {
            corpusPath = obj.getUri();
        }
        theImport.setCorpusPath(corpusPath);
        theImport.setMoniker(obj.getMoniker());
        return theImport;
    }

    public static Import toData(CdmImport instance, ResolveOptions resOpt, CopyOptions options) {
        Import result = new Import();
        result.setMoniker(Strings.isNullOrEmpty((String)instance.getMoniker()) ? null : instance.getMoniker());
        result.setCorpusPath(Strings.isNullOrEmpty((String)instance.getCorpusPath()) ? null : instance.getCorpusPath());
        return result;
    }
}

