/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.commondatamodel.objectmodel.persistence.cdmfolder.projections;

import com.fasterxml.jackson.databind.JsonNode;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmCorpusContext;
import com.microsoft.commondatamodel.objectmodel.cdm.projections.CdmOperationBase;
import com.microsoft.commondatamodel.objectmodel.cdm.projections.OperationTypeConvertor;
import com.microsoft.commondatamodel.objectmodel.enums.CdmLogCode;
import com.microsoft.commondatamodel.objectmodel.enums.CdmObjectType;
import com.microsoft.commondatamodel.objectmodel.enums.CdmOperationType;
import com.microsoft.commondatamodel.objectmodel.persistence.cdmfolder.types.projections.OperationAddAttributeGroup;
import com.microsoft.commondatamodel.objectmodel.persistence.cdmfolder.types.projections.OperationAddCountAttribute;
import com.microsoft.commondatamodel.objectmodel.persistence.cdmfolder.types.projections.OperationAddSupportingAttribute;
import com.microsoft.commondatamodel.objectmodel.persistence.cdmfolder.types.projections.OperationAddTypeAttribute;
import com.microsoft.commondatamodel.objectmodel.persistence.cdmfolder.types.projections.OperationArrayExpansion;
import com.microsoft.commondatamodel.objectmodel.persistence.cdmfolder.types.projections.OperationBase;
import com.microsoft.commondatamodel.objectmodel.persistence.cdmfolder.types.projections.OperationCombineAttributes;
import com.microsoft.commondatamodel.objectmodel.persistence.cdmfolder.types.projections.OperationExcludeAttributes;
import com.microsoft.commondatamodel.objectmodel.persistence.cdmfolder.types.projections.OperationIncludeAttributes;
import com.microsoft.commondatamodel.objectmodel.persistence.cdmfolder.types.projections.OperationRenameAttributes;
import com.microsoft.commondatamodel.objectmodel.persistence.cdmfolder.types.projections.OperationReplaceAsForeignKey;
import com.microsoft.commondatamodel.objectmodel.utilities.CopyOptions;
import com.microsoft.commondatamodel.objectmodel.utilities.ResolveOptions;
import com.microsoft.commondatamodel.objectmodel.utilities.StringUtils;
import com.microsoft.commondatamodel.objectmodel.utilities.logger.Logger;

public class OperationBasePersistence {
    private static final String TAG = OperationBasePersistence.class.getSimpleName();

    public static <T extends CdmOperationBase> T fromData(CdmCorpusContext ctx, CdmObjectType objectType, JsonNode obj) {
        if (obj == null) {
            return null;
        }
        CdmOperationBase operation = (CdmOperationBase)ctx.getCorpus().makeObject(objectType);
        CdmOperationType operationType = OperationTypeConvertor.fromObjectType(objectType);
        String operationName = OperationTypeConvertor.operationTypeToString(operationType);
        if (obj.get("$type") != null && !StringUtils.equalsWithIgnoreCase(obj.get("$type").asText(), operationName)) {
            Logger.error(ctx, TAG, "fromData", operation.getAtCorpusPath(), CdmLogCode.ErrPersistProjInvalidType, obj.get("$type").toString());
        } else {
            operation.setType(operationType);
        }
        if (obj.get("condition") != null) {
            operation.setCondition(obj.get("condition").asText());
        }
        if (obj.get("explanation") != null) {
            operation.setExplanation(obj.get("explanation").asText());
        }
        if (obj.get("sourceInput") != null) {
            operation.setSourceInput(obj.get("sourceInput").asBoolean());
        }
        return (T)operation;
    }

    public static <T extends OperationBase> T toData(CdmOperationBase instance, ResolveOptions resOpt, CopyOptions options) {
        if (instance == null) {
            return null;
        }
        T obj = OperationBasePersistence.makeDataObject(instance.getObjectType());
        ((OperationBase)obj).setType(OperationTypeConvertor.operationTypeToString(instance.getType()));
        ((OperationBase)obj).setCondition(instance.getCondition());
        ((OperationBase)obj).setExplanation(instance.getExplanation());
        ((OperationBase)obj).setSourceInput(instance.getSourceInput());
        return obj;
    }

    private static <T extends OperationBase> T makeDataObject(CdmObjectType objectType) {
        OperationBase obj;
        switch (objectType) {
            case OperationAddAttributeGroupDef: {
                obj = new OperationAddAttributeGroup();
                break;
            }
            case OperationAddCountAttributeDef: {
                obj = new OperationAddCountAttribute();
                break;
            }
            case OperationAddSupportingAttributeDef: {
                obj = new OperationAddSupportingAttribute();
                break;
            }
            case OperationAddTypeAttributeDef: {
                obj = new OperationAddTypeAttribute();
                break;
            }
            case OperationArrayExpansionDef: {
                obj = new OperationArrayExpansion();
                break;
            }
            case OperationCombineAttributesDef: {
                obj = new OperationCombineAttributes();
                break;
            }
            case OperationExcludeAttributesDef: {
                obj = new OperationExcludeAttributes();
                break;
            }
            case OperationIncludeAttributesDef: {
                obj = new OperationIncludeAttributes();
                break;
            }
            case OperationRenameAttributesDef: {
                obj = new OperationRenameAttributes();
                break;
            }
            case OperationReplaceAsForeignKeyDef: {
                obj = new OperationReplaceAsForeignKey();
                break;
            }
            default: {
                return null;
            }
        }
        return (T)obj;
    }
}

