/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.commondatamodel.objectmodel.persistence.modeljson;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Strings;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmArgumentDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmCorpusContext;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmDataTypeReference;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmDocumentDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmImport;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmObjectDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmParameterDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmTraitCollection;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmTraitDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmTraitReference;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmTraitReferenceBase;
import com.microsoft.commondatamodel.objectmodel.enums.CdmLogCode;
import com.microsoft.commondatamodel.objectmodel.enums.CdmObjectType;
import com.microsoft.commondatamodel.objectmodel.persistence.modeljson.types.MetadataObject;
import com.microsoft.commondatamodel.objectmodel.utilities.JMapper;
import com.microsoft.commondatamodel.objectmodel.utilities.logger.Logger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;

final class ExtensionHelper {
    private static final String TAG = ExtensionHelper.class.getSimpleName();
    public static final String EXTENSION_DOC_NAME = "custom.extension.cdm.json";
    private static final Map<String, CdmDocumentDefinition> cachedDefDocs = new LinkedHashMap<String, CdmDocumentDefinition>();
    private static final Set<String> SUPPORTED_EXTENSIONS = new HashSet<String>(Collections.singletonList("pbi"));
    private static final String extensionTraitNamePrefix = "is.extension.";

    ExtensionHelper() {
    }

    static void addImportDocsToManifest(CdmCorpusContext ctx, List<CdmImport> importDocs, CdmDocumentDefinition document) {
        importDocs.forEach(importDoc -> {
            if (document.getImports().getAllItems().parallelStream().noneMatch(importPresent -> Objects.equals(importPresent.getCorpusPath(), importDoc.getCorpusPath()))) {
                document.getImports().add(importDoc);
            }
        });
    }

    static CompletableFuture<List<CdmImport>> standardImportDetection(CdmCorpusContext ctx, List<CdmTraitDefinition> extensionTraitDefList, List<CdmTraitDefinition> localExtensionTraitDefList) {
        return CompletableFuture.supplyAsync(() -> {
            ArrayList<CdmImport> importsList = new ArrayList<CdmImport>();
            boolean hasCustomExtensionImport = false;
            for (int traitIndex = localExtensionTraitDefList.size() - 1; traitIndex >= 0; --traitIndex) {
                CdmTraitDefinition matchingTrait;
                CdmTraitDefinition extensionTraitDef = (CdmTraitDefinition)localExtensionTraitDefList.get(traitIndex);
                if (!ExtensionHelper.traitDefIsExtension(extensionTraitDef)) {
                    Logger.error(ctx, TAG, "standardImportDetection", extensionTraitDef.getAtCorpusPath(), CdmLogCode.ErrPersistInvalidExtensionTrait, extensionTraitDef.getTraitName(), extensionTraitNamePrefix);
                    return null;
                }
                String[] extensionBreakdown = ExtensionHelper.removeExtensionTraitNamePrefix(extensionTraitDef.getTraitName()).split("[:]", -1);
                if (extensionBreakdown.length <= 1) continue;
                String extensionName = extensionBreakdown[0];
                if (!SUPPORTED_EXTENSIONS.contains(extensionName)) {
                    if (hasCustomExtensionImport) continue;
                    CdmImport importObject = (CdmImport)ctx.getCorpus().makeObject(CdmObjectType.Import);
                    importObject.setCorpusPath(EXTENSION_DOC_NAME);
                    importsList.add(importObject);
                    hasCustomExtensionImport = true;
                    continue;
                }
                String fileName = String.format("%1$s.extension.cdm.json", extensionName);
                String fileCorpusPath = String.format("cdm:/extensions/%1$s", fileName);
                CdmDocumentDefinition extensionDoc = ExtensionHelper.fetchDefDoc(ctx, fileName).join();
                if (null == extensionDoc) continue;
                CdmObjectDefinition cdmObjectDefinition = extensionDoc.getDefinitions().getAllItems().parallelStream().filter(item -> CdmObjectType.TraitDef == item.getObjectType() && extensionTraitDef.getTraitName().equals(item.fetchObjectDefinitionName())).findAny().orElse(null);
                for (CdmObjectDefinition item2 : extensionDoc.getDefinitions()) {
                    if (CdmObjectType.TraitDef != item2.getObjectType() || !extensionTraitDef.getTraitName().equals(item2.fetchObjectDefinitionName())) continue;
                    cdmObjectDefinition = item2;
                }
                CdmTraitDefinition cdmTraitDefinition = matchingTrait = cdmObjectDefinition instanceof CdmTraitDefinition ? (CdmTraitDefinition)cdmObjectDefinition : null;
                if (null == matchingTrait) continue;
                List<CdmParameterDefinition> parameterList = matchingTrait.getParameters().getAllItems();
                if (!extensionTraitDef.getParameters().getAllItems().parallelStream().allMatch(extensionParameter -> parameterList.parallelStream().anyMatch(defParameter -> defParameter.getName().equalsIgnoreCase(extensionParameter.getName())))) continue;
                extensionTraitDefList.remove(extensionTraitDef);
                if (!importsList.parallelStream().noneMatch(importDoc -> importDoc.getCorpusPath().equalsIgnoreCase(fileCorpusPath))) continue;
                CdmImport importObject = (CdmImport)ctx.getCorpus().makeObject(CdmObjectType.Import);
                importObject.setCorpusPath(fileCorpusPath);
                importsList.add(importObject);
            }
            return importsList;
        });
    }

    static void processExtensionFromJson(CdmCorpusContext ctx, MetadataObject sourceObject, CdmTraitCollection traitRefSet, List<CdmTraitDefinition> extensionTraitDefList) {
        ExtensionHelper.processExtensionFromJson(ctx, sourceObject, traitRefSet, extensionTraitDefList, null);
    }

    static void processExtensionFromJson(CdmCorpusContext ctx, MetadataObject sourceObject, CdmTraitCollection traitRefSet, List<CdmTraitDefinition> extensionTraitDefList, List<CdmTraitDefinition> localExtensionTraitDefList) {
        for (Map.Entry<String, Object> extension : sourceObject.getExtensionFields().entrySet()) {
            boolean isTraitExists;
            JsonNode jsonNode = JMapper.MAP.valueToTree(extension.getValue());
            String traitName = ExtensionHelper.addExtensionTraitNamePrefix(extension.getKey());
            CdmTraitDefinition extensionTraitDef = extensionTraitDefList.parallelStream().filter(trait -> trait.getTraitName().equalsIgnoreCase(traitName)).findFirst().orElse(null);
            boolean bl = isTraitExists = null != extensionTraitDef;
            if (!isTraitExists) {
                extensionTraitDef = (CdmTraitDefinition)ctx.getCorpus().makeObject(CdmObjectType.TraitDef, traitName);
                extensionTraitDef.setExtendsTrait((CdmTraitReference)ctx.getCorpus().makeObject(CdmObjectType.TraitRef, "is.extension", true));
            }
            CdmTraitReference extensionTraitRef = (CdmTraitReference)ctx.getCorpus().makeObject(CdmObjectType.TraitRef, traitName);
            if (jsonNode.isObject()) {
                Iterator fields = jsonNode.fields();
                while (fields.hasNext()) {
                    boolean parameterExists;
                    Map.Entry field = (Map.Entry)fields.next();
                    String extensionProperty = (String)field.getKey();
                    JsonNode extensionPropertyValue = (JsonNode)field.getValue();
                    if (extensionPropertyValue == null) continue;
                    CdmArgumentDefinition extensionArgument = (CdmArgumentDefinition)ctx.getCorpus().makeObject(CdmObjectType.ArgumentDef, extensionProperty);
                    List<CdmParameterDefinition> parameters = extensionTraitDef.getParameters().getAllItems();
                    CdmParameterDefinition extensionParameter = parameters.parallelStream().filter(parameter -> null != parameter && parameter.getName().equalsIgnoreCase(extensionProperty)).findFirst().orElse(null);
                    boolean bl2 = parameterExists = null != extensionParameter;
                    if (!parameterExists) {
                        extensionParameter = (CdmParameterDefinition)ctx.getCorpus().makeObject(CdmObjectType.ParameterDef, extensionProperty);
                        extensionParameter.setDataTypeRef((CdmDataTypeReference)ctx.getCorpus().makeObject(CdmObjectType.DataTypeRef, ExtensionHelper.convertJsonNodeTypeToExpectedString((JsonNode)field.getValue()), true));
                    }
                    extensionArgument.setValue(extensionPropertyValue);
                    extensionTraitRef.getArguments().add(extensionArgument);
                    if (parameterExists) continue;
                    extensionTraitDef.getParameters().add(extensionParameter);
                }
            } else {
                boolean parameterExists;
                CdmArgumentDefinition extensionArgument = (CdmArgumentDefinition)ctx.getCorpus().makeObject(CdmObjectType.ArgumentDef, traitName);
                CdmParameterDefinition extensionParameter = extensionTraitDef.getParameters().getAllItems().parallelStream().filter(parameter -> parameter.getName().equalsIgnoreCase(traitName)).findFirst().orElse(null);
                boolean bl3 = parameterExists = null != extensionParameter;
                if (!parameterExists) {
                    extensionParameter = (CdmParameterDefinition)ctx.getCorpus().makeObject(CdmObjectType.ParameterDef, traitName);
                    extensionParameter.setDataTypeRef((CdmDataTypeReference)ctx.getCorpus().makeObject(CdmObjectType.DataTypeRef, ExtensionHelper.convertJsonNodeTypeToExpectedString(jsonNode), true));
                }
                extensionArgument.setValue(jsonNode);
                extensionTraitRef.getArguments().add(extensionArgument);
                if (!parameterExists) {
                    extensionTraitDef.getParameters().add(extensionParameter);
                }
            }
            if (!isTraitExists) {
                extensionTraitDefList.add(extensionTraitDef);
            }
            if (localExtensionTraitDefList != null) {
                localExtensionTraitDefList.add(extensionTraitDef);
            }
            traitRefSet.add(extensionTraitRef);
        }
    }

    static void processExtensionTraitToObject(CdmTraitReference extensionTraitRef, MetadataObject destination) {
        ObjectNode extensionValue;
        if (null == destination.getExtensionFields()) {
            destination.setOverrideExtensionFields((Map<String, Object>)new LinkedHashMap<String, Object>(){
                {
                    this.put(UUID.randomUUID().toString(), JsonNodeFactory.instance.objectNode());
                }
            });
        }
        String originalExtensionName = ExtensionHelper.removeExtensionTraitNamePrefix(extensionTraitRef.getNamedReference());
        if (extensionTraitRef.getArguments().getCount() == 1 && ((CdmArgumentDefinition)extensionTraitRef.getArguments().get(0)).getName().equals(extensionTraitRef.getNamedReference())) {
            extensionValue = (JsonNode)((CdmArgumentDefinition)extensionTraitRef.getArguments().get(0)).getValue();
        } else {
            ObjectNode extensionValueAsJObject = JsonNodeFactory.instance.objectNode();
            for (CdmArgumentDefinition argument : extensionTraitRef.getArguments()) {
                String propertyName = argument.getName();
                Object propertyValue = argument.getValue();
                extensionValueAsJObject.put(propertyName, JMapper.MAP.valueToTree(propertyValue));
            }
            extensionValue = extensionValueAsJObject;
        }
        destination.getExtensionFields().put(originalExtensionName, extensionValue);
    }

    private static boolean traitNameHasExtensionMark(String traitName) {
        if (Strings.isNullOrEmpty((String)traitName)) {
            return false;
        }
        return traitName.startsWith(extensionTraitNamePrefix);
    }

    static boolean traitRefIsExtension(CdmTraitReferenceBase trait) {
        return ExtensionHelper.traitNameHasExtensionMark(trait.getNamedReference());
    }

    private static boolean traitDefIsExtension(CdmTraitDefinition trait) {
        return ExtensionHelper.traitNameHasExtensionMark(trait.getTraitName());
    }

    private static CompletableFuture<CdmDocumentDefinition> fetchDefDoc(CdmCorpusContext ctx, String fileName) {
        if (cachedDefDocs.containsKey(fileName)) {
            return CompletableFuture.completedFuture(cachedDefDocs.get(fileName));
        }
        String path = String.format("/extensions/%1$s", fileName);
        return ctx.getCorpus().fetchObjectAsync(path, ctx.getCorpus().getStorage().fetchRootFolder("cdm")).thenApply(document -> {
            if (document != null) {
                CdmDocumentDefinition extensionDoc = document instanceof CdmDocumentDefinition ? (CdmDocumentDefinition)document : null;
                cachedDefDocs.put(fileName, extensionDoc);
                return extensionDoc;
            }
            return null;
        });
    }

    private static String convertJsonNodeTypeToExpectedString(JsonNode type) {
        String stringType = type.getNodeType().name().toLowerCase();
        if ("array".equals(stringType)) {
            stringType = "object";
        }
        return stringType;
    }

    private static String removeExtensionTraitNamePrefix(String traitName) {
        return traitName.substring(extensionTraitNamePrefix.length());
    }

    private static String addExtensionTraitNamePrefix(String traitName) {
        return String.format("%1$s%2$s", extensionTraitNamePrefix, traitName);
    }
}

