/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.commondatamodel.objectmodel.storage;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.microsoft.commondatamodel.objectmodel.storage.StorageAdapterBase;
import com.microsoft.commondatamodel.objectmodel.storage.StorageAdapterException;
import com.microsoft.commondatamodel.objectmodel.utilities.JMapper;
import com.microsoft.commondatamodel.objectmodel.utilities.StorageUtils;
import com.microsoft.commondatamodel.objectmodel.utilities.StringUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalAdapter
extends StorageAdapterBase {
    private static final Logger LOGGER = LoggerFactory.getLogger(LocalAdapter.class);
    static final String TYPE = "local";
    private String root;
    private String fullRoot;

    public LocalAdapter(String root) {
        this.root = root;
        this.fullRoot = this.convertPathToAbsolutePath(root);
    }

    public LocalAdapter() {
    }

    @Override
    public String fetchConfig() {
        ObjectNode resultConfig = JsonNodeFactory.instance.objectNode();
        resultConfig.put("type", TYPE);
        ObjectNode configObject = JsonNodeFactory.instance.objectNode();
        configObject.put("root", this.root);
        String locationHint = this.getLocationHint();
        if (locationHint != null) {
            configObject.put("locationHint", locationHint);
        }
        resultConfig.put("config", (JsonNode)configObject);
        try {
            return JMapper.WRITER.writeValueAsString((Object)resultConfig);
        }
        catch (JsonProcessingException e) {
            throw new StorageAdapterException("Failed to construct config string", (Exception)((Object)e));
        }
    }

    @Override
    public boolean canRead() {
        return true;
    }

    @Override
    public CompletableFuture<String> readAsync(String corpusPath) {
        return CompletableFuture.supplyAsync(() -> {
            String string;
            String path = this.createAdapterPath(corpusPath);
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(path), StandardCharsets.UTF_8));
            try {
                String line;
                StringBuilder result = new StringBuilder();
                while ((line = br.readLine()) != null) {
                    result.append(line);
                }
                string = result.toString();
            }
            catch (Throwable throwable) {
                try {
                    try {
                        br.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new StorageAdapterException("Failed to read file at corpus path " + corpusPath, e);
                }
            }
            br.close();
            return string;
        });
    }

    @Override
    public boolean canWrite() {
        return true;
    }

    @Override
    public CompletableFuture<Void> writeAsync(String corpusPath, String data) {
        return CompletableFuture.runAsync(() -> {
            String path = this.createAdapterPath(corpusPath);
            if (!this.ensurePath(path)) {
                throw new StorageAdapterException("Could not create folder for document " + path);
            }
            File file = new File(path);
            try {
                FileUtils.writeStringToFile((File)file, (String)data, (Charset)StandardCharsets.UTF_8);
            }
            catch (IOException e) {
                throw new StorageAdapterException("Failed to write file at corpus path " + corpusPath, e);
            }
        });
    }

    public CompletableFuture<Boolean> dirExists(String folderPath) {
        return CompletableFuture.supplyAsync(() -> Files.isDirectory(Paths.get(this.createAdapterPath(folderPath), new String[0]), new LinkOption[0]));
    }

    @Override
    public String createAdapterPath(String corpusPath) {
        ImmutablePair<String, String> pathTuple = StorageUtils.splitNamespacePath(corpusPath);
        if (pathTuple == null) {
            return null;
        }
        corpusPath = (String)pathTuple.getRight();
        if (Paths.get(this.fullRoot, new String[0]).isAbsolute()) {
            return this.convertPathToAbsolutePath(Paths.get(this.fullRoot, corpusPath).toString());
        }
        return this.convertPathToAbsolutePath(Paths.get(Paths.get(System.getProperty("user.dir"), this.fullRoot).toString(), corpusPath).toString());
    }

    @Override
    public String createCorpusPath(String adapterPath) {
        String formattedRoot;
        if (StringUtils.isNullOrTrimEmpty(adapterPath) || adapterPath.startsWith("http")) {
            return null;
        }
        String formattedAdapterPath = this.convertPathToAbsolutePath(adapterPath);
        if (formattedAdapterPath == null) {
            return null;
        }
        if ((formattedAdapterPath = formattedAdapterPath.replace('\\', '/')).startsWith(formattedRoot = this.fullRoot.replace('\\', '/'))) {
            return StringUtils.slice(formattedAdapterPath, formattedRoot.length()).replace("\\", "/");
        }
        return null;
    }

    @Override
    public CompletableFuture<OffsetDateTime> computeLastModifiedTimeAsync(String corpusPath) {
        return CompletableFuture.supplyAsync(() -> {
            Path adapterPath = Paths.get(this.createAdapterPath(corpusPath), new String[0]);
            if (Files.exists(adapterPath, new LinkOption[0])) {
                try {
                    return OffsetDateTime.ofInstant(Files.getLastModifiedTime(adapterPath, new LinkOption[0]).toInstant(), ZoneOffset.UTC);
                }
                catch (IOException e) {
                    throw new StorageAdapterException("Failed to get last modified time of file at adapter path " + corpusPath, e);
                }
            }
            return null;
        });
    }

    @Override
    public CompletableFuture<List<String>> fetchAllFilesAsync(String folderCorpusPath) {
        return CompletableFuture.supplyAsync(() -> {
            ArrayList<String> allFiles = new ArrayList<String>();
            String adapterPath = this.createAdapterPath(folderCorpusPath);
            File[] content = new File(adapterPath).listFiles();
            if (content != null) {
                for (File childPath : content) {
                    String childCorpusPath = this.createCorpusPath(childPath.getPath());
                    try {
                        if (this.dirExistsAsync(childCorpusPath).get().booleanValue()) {
                            List<String> subFiles = this.fetchAllFilesAsync(childCorpusPath).get();
                            allFiles.addAll(subFiles);
                            continue;
                        }
                        allFiles.add(childCorpusPath);
                    }
                    catch (InterruptedException | ExecutionException e) {
                        throw new StorageAdapterException("Failed to get all files for folderCorpusPath:" + folderCorpusPath, e);
                    }
                }
            }
            return allFiles;
        });
    }

    private CompletableFuture<Boolean> dirExistsAsync(String folderPath) {
        return CompletableFuture.supplyAsync(() -> Files.isDirectory(Paths.get(this.createAdapterPath(folderPath), new String[0]), new LinkOption[0]));
    }

    private boolean ensurePath(String pathFor) throws StorageAdapterException {
        int pathEnd = pathFor.lastIndexOf(File.separator);
        if (pathEnd == -1) {
            return false;
        }
        String pathTo = pathFor.substring(0, pathEnd);
        if (Files.exists(Paths.get(pathTo, new String[0]), new LinkOption[0])) {
            return true;
        }
        if (!this.ensurePath(pathTo)) {
            return false;
        }
        try {
            Files.createDirectory(Paths.get(pathTo, new String[0]), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new StorageAdapterException("Failed to create directory at path " + pathTo, e);
        }
        return true;
    }

    private String convertPathToAbsolutePath(String path) {
        try {
            return new File(path).getCanonicalPath();
        }
        catch (Exception E) {
            LOGGER.error("Unable to parse path '{}'.", (Object)path);
            return null;
        }
    }

    @Deprecated
    public String getFullRoot() {
        return this.fullRoot;
    }

    public String getRoot() {
        return this.root;
    }

    @Override
    public void updateConfig(String config) throws IOException {
        if (config == null) {
            throw new StorageAdapterException("Local adapter needs a config.");
        }
        JsonNode configsJson = JMapper.MAP.readTree(config);
        if (!configsJson.has("root")) {
            throw new StorageAdapterException("The root has to be specified and cannot be null.");
        }
        this.root = configsJson.get("root").asText();
        if (configsJson.has("locationHint")) {
            this.setLocationHint(configsJson.get("locationHint").asText());
        }
        this.fullRoot = new File(this.root).toString();
    }
}

