/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.commondatamodel.objectmodel.cdm;

import com.microsoft.commondatamodel.objectmodel.cdm.CdmCorpusContext;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmDocumentDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmObject;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmObjectBase;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmObjectSimple;
import com.microsoft.commondatamodel.objectmodel.enums.CdmLogCode;
import com.microsoft.commondatamodel.objectmodel.enums.CdmObjectType;
import com.microsoft.commondatamodel.objectmodel.utilities.CopyOptions;
import com.microsoft.commondatamodel.objectmodel.utilities.ResolveOptions;
import com.microsoft.commondatamodel.objectmodel.utilities.StringUtils;
import com.microsoft.commondatamodel.objectmodel.utilities.VisitCallback;
import com.microsoft.commondatamodel.objectmodel.utilities.logger.Logger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.stream.Collectors;

public class CdmImport
extends CdmObjectSimple {
    private static final String TAG = CdmImport.class.getSimpleName();
    private String moniker;
    private String corpusPath;
    private CdmDocumentDefinition document;

    public CdmImport(CdmCorpusContext ctx, String corpusPath, String moniker) {
        super(ctx);
        this.setCorpusPath(corpusPath);
        this.setMoniker(moniker);
        this.setObjectType(CdmObjectType.Import);
    }

    @Override
    public boolean visit(String pathFrom, VisitCallback preChildren, VisitCallback postChildren) {
        if (preChildren != null && preChildren.invoke(this, pathFrom)) {
            return false;
        }
        return postChildren != null && postChildren.invoke(this, pathFrom);
    }

    CdmDocumentDefinition getDocument() {
        return this.document;
    }

    void setDocument(CdmDocumentDefinition document) {
        this.document = document;
    }

    public String getCorpusPath() {
        return this.corpusPath;
    }

    public void setCorpusPath(String value) {
        this.corpusPath = value;
    }

    public String getMoniker() {
        return this.moniker;
    }

    public void setMoniker(String value) {
        this.moniker = value;
    }

    @Override
    public boolean validate() {
        if (StringUtils.isNullOrTrimEmpty(this.corpusPath)) {
            ArrayList<String> missingFields = new ArrayList<String>(Arrays.asList("corpusPath"));
            Logger.error(this.getCtx(), TAG, "validate", this.getAtCorpusPath(), CdmLogCode.ErrValdnIntegrityCheckFailure, this.getAtCorpusPath(), String.join((CharSequence)", ", missingFields.parallelStream().map(s -> String.format("'%s'", s)).collect(Collectors.toList())));
            return false;
        }
        return true;
    }

    @Override
    public Object copyData(ResolveOptions resOpt, CopyOptions options) {
        return CdmObjectBase.copyData(this, resOpt, options, CdmImport.class);
    }

    @Override
    @Deprecated
    public CdmObject copy(ResolveOptions resOpt, CdmObject host) {
        CdmImport copy;
        if (resOpt == null) {
            resOpt = new ResolveOptions(this, this.getCtx().getCorpus().getDefaultResolutionDirectives());
        }
        if (host == null) {
            copy = new CdmImport(this.getCtx(), this.corpusPath, this.moniker);
        } else {
            copy = (CdmImport)host;
            copy.setCtx(this.getCtx());
            copy.setCorpusPath(this.getCorpusPath());
            copy.setMoniker(this.getMoniker());
        }
        copy.setDocument(this.document);
        return copy;
    }
}

