/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.commondatamodel.objectmodel.cdm;

import com.microsoft.commondatamodel.objectmodel.cdm.CdmCollection;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmCorpusContext;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmDataPartitionDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmDataPartitionPatternDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmDocumentDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmE2ERelationship;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmEntityCollection;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmEntityDeclarationDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmEntityDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmFileStatus;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmFolderDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmImport;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmManifestDeclarationDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmObject;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmObjectDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmReferencedEntityDeclarationDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmTraitCollection;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmTraitReferenceBase;
import com.microsoft.commondatamodel.objectmodel.enums.CdmLogCode;
import com.microsoft.commondatamodel.objectmodel.enums.CdmObjectType;
import com.microsoft.commondatamodel.objectmodel.enums.CdmRelationshipDiscoveryStyle;
import com.microsoft.commondatamodel.objectmodel.enums.ImportsLoadStrategy;
import com.microsoft.commondatamodel.objectmodel.storage.StorageAdapter;
import com.microsoft.commondatamodel.objectmodel.storage.StorageAdapterBase;
import com.microsoft.commondatamodel.objectmodel.utilities.AttributeResolutionDirectiveSet;
import com.microsoft.commondatamodel.objectmodel.utilities.CopyOptions;
import com.microsoft.commondatamodel.objectmodel.utilities.ResolveOptions;
import com.microsoft.commondatamodel.objectmodel.utilities.StringUtils;
import com.microsoft.commondatamodel.objectmodel.utilities.TimeUtils;
import com.microsoft.commondatamodel.objectmodel.utilities.VisitCallback;
import com.microsoft.commondatamodel.objectmodel.utilities.logger.Logger;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.tuple.Pair;

public class CdmManifestDefinition
extends CdmDocumentDefinition
implements CdmObjectDefinition,
CdmFileStatus {
    private static final String TAG = CdmManifestDefinition.class.getSimpleName();
    private String manifestName;
    private CdmCollection<CdmManifestDeclarationDefinition> subManifests;
    private CdmEntityCollection entities;
    private CdmCollection<CdmE2ERelationship> relationships;
    private String explanation;
    private CdmTraitCollection exhibitsTraits;
    private OffsetDateTime lastFileStatusCheckTime;
    private OffsetDateTime lastFileModifiedTime;
    private OffsetDateTime lastChildFileModifiedTime;

    public CdmManifestDefinition(CdmCorpusContext ctx, String name) {
        super(ctx, name + ".manifest.cdm.json");
        this.setObjectType(CdmObjectType.ManifestDef);
        this.manifestName = name;
        this.entities = new CdmEntityCollection(this.getCtx(), this);
        this.exhibitsTraits = new CdmTraitCollection(this.getCtx(), this);
    }

    public String getManifestName() {
        return this.manifestName;
    }

    public void setManifestName(String manifestName) {
        if (manifestName.endsWith(".folio.cdm.json")) {
            this.manifestName = manifestName.replace(".folio.cdm.json", ".manifest.cdm.json");
        }
        this.manifestName = manifestName;
    }

    @Override
    public OffsetDateTime getLastFileStatusCheckTime() {
        return this.lastFileStatusCheckTime;
    }

    @Override
    public void setLastFileStatusCheckTime(OffsetDateTime lastFileStatusCheckTime) {
        this.lastFileStatusCheckTime = lastFileStatusCheckTime;
    }

    @Override
    public OffsetDateTime getLastFileModifiedTime() {
        return this.lastFileModifiedTime;
    }

    @Override
    public void setLastFileModifiedTime(OffsetDateTime lastFileModifiedTime) {
        this.lastFileModifiedTime = lastFileModifiedTime;
    }

    @Override
    public OffsetDateTime getLastChildFileModifiedTime() {
        return this.lastChildFileModifiedTime;
    }

    @Override
    public void setLastChildFileModifiedTime(OffsetDateTime lastChildFileModifiedTime) {
        this.lastChildFileModifiedTime = lastChildFileModifiedTime;
    }

    @Override
    public String getExplanation() {
        return this.explanation;
    }

    @Override
    public void setExplanation(String explanation) {
        this.explanation = explanation;
    }

    public CdmEntityCollection getEntities() {
        return this.entities;
    }

    @Override
    public CdmObjectType getObjectType() {
        return CdmObjectType.ManifestDef;
    }

    public CdmCollection<CdmManifestDeclarationDefinition> getSubManifests() {
        if (this.subManifests == null) {
            this.subManifests = new CdmCollection(this.getCtx(), this, CdmObjectType.ManifestDeclarationDef);
        }
        return this.subManifests;
    }

    public CdmCollection<CdmE2ERelationship> getRelationships() {
        if (this.relationships == null) {
            this.relationships = new CdmCollection(this.getCtx(), this, CdmObjectType.E2ERelationshipDef);
        }
        return this.relationships;
    }

    @Override
    public CdmTraitCollection getExhibitsTraits() {
        return this.exhibitsTraits;
    }

    public void setExhibitsTraits(CdmTraitCollection exhibitsTraits) {
        this.exhibitsTraits = exhibitsTraits;
    }

    @Override
    @Deprecated
    public CompletableFuture<Boolean> saveLinkedDocumentsAsync(CopyOptions options) {
        return CompletableFuture.supplyAsync(() -> {
            HashSet<String> links = new HashSet<String>();
            if (this.getImports() != null) {
                for (CdmImport imp : this.getImports()) {
                    links.add(imp.getCorpusPath());
                }
            }
            if (this.getEntities() != null) {
                for (CdmEntityDeclarationDefinition def : this.getEntities()) {
                    if (def.getObjectType() != CdmObjectType.LocalEntityDeclarationDef) continue;
                    links.add(def.getEntityPath());
                    if (def.getDataPartitions() != null) {
                        for (CdmDataPartitionDefinition cdmDataPartitionDefinition : def.getDataPartitions()) {
                            if (cdmDataPartitionDefinition.getSpecializedSchema() == null) continue;
                            links.add(cdmDataPartitionDefinition.getSpecializedSchema());
                        }
                    }
                    if (def.getDataPartitionPatterns() == null) continue;
                    for (CdmDataPartitionPatternDefinition cdmDataPartitionPatternDefinition : def.getDataPartitionPatterns()) {
                        if (cdmDataPartitionPatternDefinition.getSpecializedSchema() == null) continue;
                        links.add(cdmDataPartitionPatternDefinition.getSpecializedSchema());
                    }
                }
            }
            if (this.getSubManifests() != null) {
                for (CdmManifestDeclarationDefinition sub : this.getSubManifests()) {
                    links.add(sub.getDefinition());
                }
            }
            for (String link : links) {
                Pair<CdmDocumentDefinition, Boolean> doc = this.fetchDocumentDefinition(link).join();
                if (!((Boolean)doc.getValue()).booleanValue()) {
                    Logger.error(this.getCtx(), TAG, "saveLinkedDocumentsAsync", this.getAtCorpusPath(), CdmLogCode.ErrPersistObjectNotFound, link);
                    return false;
                }
                this.saveDocumentIfDirty((CdmDocumentDefinition)doc.getKey(), options).join();
            }
            return true;
        });
    }

    private CompletableFuture<Boolean> saveDirtyLinkAsync(String relative, CopyOptions options) {
        return CompletableFuture.supplyAsync(() -> {
            String docPath = this.getCtx().getCorpus().getStorage().createAbsoluteCorpusPath(relative, this);
            if (docPath == null) {
                Logger.error(this.getCtx(), TAG, "saveDirtyLinkAsync", this.getAtCorpusPath(), CdmLogCode.ErrValdnInvalidCorpusPath, relative);
                return false;
            }
            CdmObject objAt = (CdmObject)this.getCtx().getCorpus().fetchObjectAsync(docPath).join();
            if (objAt == null) {
                Logger.error(this.getCtx(), TAG, "saveDirtyLinkAsync", this.getAtCorpusPath(), CdmLogCode.ErrPersistObjectNotFound, docPath);
                return false;
            }
            CdmDocumentDefinition docImp = objAt.getInDocument();
            if (docImp != null && docImp.isDirty() && !docImp.saveAsAsync(docImp.getName(), true, options).join().booleanValue()) {
                Logger.error(this.getCtx(), TAG, "saveDirtyLinkAsync", this.getAtCorpusPath(), CdmLogCode.ErrDocEntityDocSavingFailure, docImp.getName());
                return false;
            }
            return true;
        });
    }

    private CompletableFuture<Pair<CdmDocumentDefinition, Boolean>> fetchDocumentDefinition(String relativePath) {
        return CompletableFuture.supplyAsync(() -> {
            Pair result = Pair.of(null, (Object)false);
            String docPath = this.getCtx().getCorpus().getStorage().createAbsoluteCorpusPath(relativePath, this);
            if (docPath == null) {
                Logger.error(this.getCtx(), TAG, "fetchDocumentDefinition", this.getAtCorpusPath(), CdmLogCode.ErrValdnInvalidCorpusPath, relativePath);
                return result;
            }
            ResolveOptions resOpt = new ResolveOptions();
            resOpt.setImportsLoadStrategy(ImportsLoadStrategy.Load);
            CdmObject objAt = (CdmObject)this.getCtx().getCorpus().fetchObjectAsync(docPath, null, resOpt).join();
            if (objAt == null) {
                Logger.error(this.getCtx(), TAG, "fetchDocumentDefinition", this.getAtCorpusPath(), CdmLogCode.ErrPersistObjectNotFound, docPath);
                return result;
            }
            return Pair.of((Object)objAt.getInDocument(), (Object)true);
        });
    }

    private CompletableFuture<Boolean> saveDocumentIfDirty(CdmDocumentDefinition docImp, CopyOptions options) {
        return CompletableFuture.supplyAsync(() -> {
            if (docImp != null && docImp.isDirty() && !docImp.saveAsAsync(docImp.getName(), true, options).join().booleanValue()) {
                return false;
            }
            return true;
        });
    }

    public CompletableFuture<Void> populateManifestRelationshipsAsync() {
        return this.populateManifestRelationshipsAsync(CdmRelationshipDiscoveryStyle.All);
    }

    public CompletableFuture<Void> populateManifestRelationshipsAsync(CdmRelationshipDiscoveryStyle option) {
        return CompletableFuture.runAsync(() -> {
            try (Logger.LoggerScope logScope = Logger.enterScope(CdmManifestDefinition.class.getSimpleName(), this.getCtx(), "populateManifestRelationshipsAsync");){
                this.getRelationships().clear();
                ConcurrentHashMap.KeySetView relCache = ConcurrentHashMap.newKeySet();
                for (CdmEntityDeclarationDefinition entDec : this.getEntities()) {
                    ArrayList<CdmE2ERelationship> incomingRels;
                    String entPath = this.createEntityPathFromDeclarationAsync(entDec, this).join();
                    CdmEntityDefinition currEntity = (CdmEntityDefinition)this.getCtx().getCorpus().fetchObjectAsync(entPath).join();
                    if (currEntity == null) continue;
                    ArrayList<CdmE2ERelationship> outgoingRels = this.getCtx().getCorpus().fetchOutgoingRelationships(currEntity);
                    if (outgoingRels != null) {
                        for (CdmE2ERelationship outgoingRel : outgoingRels) {
                            String cacheKey = this.rel2CacheKey(outgoingRel);
                            if (relCache.contains(cacheKey) || !this.isRelAllowed(outgoingRel, option)) continue;
                            this.getRelationships().add(this.localizeRelToManifest(outgoingRel));
                            relCache.add(cacheKey);
                        }
                    }
                    if ((incomingRels = this.getCtx().getCorpus().fetchIncomingRelationships(currEntity)) == null) continue;
                    for (CdmE2ERelationship inRel : incomingRels) {
                        CdmEntityDefinition currentInBase = (CdmEntityDefinition)this.getCtx().getCorpus().fetchObjectAsync(inRel.getToEntity(), this).join();
                        if (currentInBase == null) continue;
                        CdmCollection<CdmEntityDefinition> toInheritanceGraph = new CdmCollection<CdmEntityDefinition>(this.getCtx(), this, this.getObjectType());
                        while (currentInBase != null) {
                            ResolveOptions resOpt = new ResolveOptions();
                            resOpt.setWrtDoc(currentInBase.getInDocument());
                            if ((currentInBase = currentInBase.getExtendsEntity() != null ? (CdmEntityDefinition)currentInBase.getExtendsEntity().fetchObjectDefinition(resOpt) : null) == null) continue;
                            toInheritanceGraph.add(currentInBase);
                        }
                        String cacheKey = this.rel2CacheKey(inRel);
                        if (!relCache.contains(cacheKey) && this.isRelAllowed(inRel, option)) {
                            this.getRelationships().add(this.localizeRelToManifest(inRel));
                            relCache.add(cacheKey);
                        }
                        for (CdmEntityDefinition baseEntity : toInheritanceGraph) {
                            ArrayList<CdmE2ERelationship> incomingRelsForBase = this.getCtx().getCorpus().fetchIncomingRelationships(baseEntity);
                            if (incomingRelsForBase == null) continue;
                            for (CdmE2ERelationship inRelBase : incomingRelsForBase) {
                                CdmE2ERelationship newRel = new CdmE2ERelationship(this.getCtx(), "");
                                newRel.setFromEntity(inRelBase.getFromEntity());
                                newRel.setFromEntityAttribute(inRelBase.getFromEntityAttribute());
                                newRel.setToEntity(inRel.getToEntity());
                                newRel.setToEntityAttribute(inRel.getToEntityAttribute());
                                String baseRelCacheKey = this.rel2CacheKey(newRel);
                                if (relCache.contains(baseRelCacheKey) || !this.isRelAllowed(newRel, option)) continue;
                                this.getRelationships().add(this.localizeRelToManifest(newRel));
                                relCache.add(baseRelCacheKey);
                            }
                        }
                    }
                }
                if (this.getSubManifests() != null) {
                    for (CdmManifestDeclarationDefinition subManifestDef : this.getSubManifests()) {
                        String corpusPath = this.getCtx().getCorpus().getStorage().createAbsoluteCorpusPath(subManifestDef.getDefinition(), this);
                        CdmManifestDefinition subManifest = (CdmManifestDefinition)this.getCtx().getCorpus().fetchObjectAsync(corpusPath).join();
                        subManifest.populateManifestRelationshipsAsync(option).join();
                    }
                }
            }
        });
    }

    @Override
    public CompletableFuture<Void> fileStatusCheckAsync() {
        return CompletableFuture.runAsync(() -> {
            try (Logger.LoggerScope logScope = Logger.enterScope(CdmManifestDefinition.class.getSimpleName(), this.getCtx(), "fileStatusCheckAsync");){
                StorageAdapter storageAdapterInterface = this.getCtx().getCorpus().getStorage().fetchAdapter(this.getInDocument().getNamespace());
                StorageAdapterBase.CacheContext cacheContext = null;
                if (storageAdapterInterface instanceof StorageAdapterBase) {
                    cacheContext = ((StorageAdapterBase)storageAdapterInterface).createFileQueryCacheContext();
                }
                try {
                    OffsetDateTime modifiedTime = this.getCtx().getCorpus().computeLastModifiedTimeFromObjectAsync(this).join();
                    this.setLastFileStatusCheckTime(OffsetDateTime.now(ZoneOffset.UTC));
                    if (this.getLastFileModifiedTime() == null) {
                        this.setLastFileModifiedTime(this.getFileSystemModifiedTime());
                    }
                    if (!Objects.equals(modifiedTime, this.getFileSystemModifiedTime())) {
                        this.reloadAsync().join();
                        this.setLastFileModifiedTime(TimeUtils.maxTime(modifiedTime, this.getLastFileModifiedTime()));
                        this.setFileSystemModifiedTime(this.getLastFileModifiedTime());
                    }
                    for (CdmEntityDeclarationDefinition entity : this.getEntities()) {
                        entity.fileStatusCheckAsync().join();
                    }
                    for (CdmManifestDeclarationDefinition subManifest : this.getSubManifests()) {
                        subManifest.fileStatusCheckAsync().join();
                    }
                }
                finally {
                    if (cacheContext != null) {
                        cacheContext.dispose();
                    }
                }
            }
        });
    }

    @Override
    public CompletableFuture<Void> reportMostRecentTimeAsync(OffsetDateTime childTime) {
        if (childTime != null) {
            this.setLastChildFileModifiedTime(TimeUtils.maxTime(childTime, this.getLastChildFileModifiedTime()));
        }
        return CompletableFuture.completedFuture(null);
    }

    private CompletableFuture<List<?>> queryOnTraitsAsync(Object querySpec) {
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public boolean isDerivedFrom(String baseDef, ResolveOptions resOpt) {
        return false;
    }

    @Override
    public boolean visit(String pathFrom, VisitCallback preChildren, VisitCallback postChildren) {
        if (preChildren != null && preChildren.invoke(this, pathFrom)) {
            return false;
        }
        if (this.getDefinitions() != null && this.getDefinitions().visitList(pathFrom, preChildren, postChildren)) {
            return true;
        }
        if (this.getEntities() != null && this.entities.visitList(pathFrom, preChildren, postChildren)) {
            return true;
        }
        if (this.getRelationships() != null && this.getRelationships().visitList(pathFrom + "/relationships/", preChildren, postChildren)) {
            return true;
        }
        if (this.getSubManifests() != null && this.getSubManifests().visitList(pathFrom + "/subManifests/", preChildren, postChildren)) {
            return true;
        }
        return postChildren != null && postChildren.invoke(this, pathFrom);
    }

    @Override
    public CdmObject copy(ResolveOptions resOpt, CdmObject host) {
        CdmManifestDefinition tempHost = (CdmManifestDefinition)host;
        if (tempHost == null) {
            tempHost = new CdmManifestDefinition(this.getCtx(), this.getManifestName());
        }
        CdmManifestDefinition copy = (CdmManifestDefinition)super.copy(resOpt, tempHost);
        copy.setManifestName(this.getManifestName());
        copy.setExplanation(this.getExplanation());
        copy.setLastFileStatusCheckTime(this.getLastFileStatusCheckTime());
        copy.setLastFileModifiedTime(this.getLastFileModifiedTime());
        copy.setLastChildFileModifiedTime(this.getLastChildFileModifiedTime());
        copy.getEntities().clear();
        this.getEntities().forEach(entityDec -> copy.getEntities().add((CdmEntityDeclarationDefinition)entityDec.copy(resOpt)));
        copy.getRelationships().clear();
        this.getRelationships().forEach(relationship -> copy.getRelationships().add((CdmE2ERelationship)relationship.copy(resOpt)));
        copy.getSubManifests().clear();
        this.getSubManifests().forEach(subManifest -> copy.getSubManifests().add((CdmManifestDeclarationDefinition)subManifest.copy(resOpt)));
        copy.getExhibitsTraits().clear();
        this.getExhibitsTraits().forEach(trait -> copy.getExhibitsTraits().add((CdmTraitReferenceBase)trait.copy(resOpt)));
        return copy;
    }

    public CompletableFuture<CdmManifestDefinition> createResolvedManifestAsync(String newManifestName, String newEntityDocumentNameFormat) {
        return this.createResolvedManifestAsync(newManifestName, newEntityDocumentNameFormat, null);
    }

    public CompletableFuture<CdmManifestDefinition> createResolvedManifestAsync(String newManifestName, String newEntityDocumentNameFormat, AttributeResolutionDirectiveSet directives) {
        return CompletableFuture.supplyAsync(() -> {
            try (Logger.LoggerScope logScope = Logger.enterScope(CdmManifestDefinition.class.getSimpleName(), this.getCtx(), "createResolvedManifestAsync");){
                Object object;
                CdmFolderDefinition resolvedManifestFolder;
                String innerNewEntityDocumentNameFormat = newEntityDocumentNameFormat;
                String innerNewManifestName = newManifestName;
                if (null == this.getEntities()) {
                    CdmManifestDefinition cdmManifestDefinition = null;
                    return cdmManifestDefinition;
                }
                if (this.getFolder() == null) {
                    Logger.error(this.getCtx(), TAG, "createResolvedManifestAsync", this.getAtCorpusPath(), CdmLogCode.ErrResolveManifestFailed, this.manifestName);
                    CdmManifestDefinition cdmManifestDefinition = null;
                    return cdmManifestDefinition;
                }
                if (null == innerNewEntityDocumentNameFormat) {
                    innerNewEntityDocumentNameFormat = "{f}resolved/{n}.cdm.json";
                } else if (innerNewEntityDocumentNameFormat.isEmpty()) {
                    innerNewEntityDocumentNameFormat = "{n}.cdm.json";
                } else if (!innerNewEntityDocumentNameFormat.contains("{n}")) {
                    innerNewEntityDocumentNameFormat = innerNewEntityDocumentNameFormat + "/{n}.cdm.json";
                }
                String sourceManifestPath = this.getCtx().getCorpus().getStorage().createAbsoluteCorpusPath(this.getAtCorpusPath(), this);
                String sourceManifestFolderPath = this.getCtx().getCorpus().getStorage().createAbsoluteCorpusPath(this.getFolder().getAtCorpusPath(), this);
                int resolvedManifestPathSplit = innerNewManifestName.lastIndexOf("/") + 1;
                if (resolvedManifestPathSplit > 0) {
                    String resolvedManifestPath = innerNewManifestName.substring(0, resolvedManifestPathSplit);
                    String newFolderPath = this.getCtx().getCorpus().getStorage().createAbsoluteCorpusPath(resolvedManifestPath, this);
                    resolvedManifestFolder = (CdmFolderDefinition)this.getCtx().getCorpus().fetchObjectAsync(newFolderPath).join();
                    if (resolvedManifestFolder == null) {
                        Logger.error(this.getCtx(), TAG, "createResolvedManifestAsync", this.getAtCorpusPath(), CdmLogCode.ErrResolveFolderNotFound, newFolderPath);
                        CdmManifestDefinition cdmManifestDefinition = null;
                        return cdmManifestDefinition;
                    }
                    innerNewManifestName = innerNewManifestName.substring(resolvedManifestPathSplit);
                } else {
                    resolvedManifestFolder = (CdmFolderDefinition)this.getOwner();
                }
                Logger.debug(this.getCtx(), TAG, "createResolvedManifestAsync", this.getAtCorpusPath(), Logger.format("Resolving manifest '{0}'", sourceManifestPath));
                if (innerNewManifestName.toLowerCase().endsWith(".manifest.cdm.json")) {
                    innerNewManifestName = innerNewManifestName.substring(0, innerNewManifestName.length() - ".manifest.cdm.json".length());
                }
                CdmManifestDefinition resolvedManifest = new CdmManifestDefinition(this.getCtx(), innerNewManifestName);
                resolvedManifest.setSchema(this.getSchema());
                resolvedManifest.setExplanation(this.getExplanation());
                resolvedManifest.setDocumentVersion(this.getDocumentVersion());
                for (CdmImport imp : this.getImports()) {
                    resolvedManifest.getImports().add((CdmImport)imp.copy());
                }
                if (resolvedManifestFolder.getDocuments().add(resolvedManifest) == null) {
                    object = null;
                    return object;
                }
                for (CdmEntityDeclarationDefinition entity : this.getEntities()) {
                    CdmManifestDefinition cdmManifestDefinition;
                    CdmEntityDefinition entDef = this.getEntityFromReferenceAsync(entity, this).join();
                    if (null == entDef) {
                        Logger.error(this.getCtx(), TAG, "createResolvedManifestAsync", this.getAtCorpusPath(), CdmLogCode.ErrResolveEntityRefError, new String[0]);
                        cdmManifestDefinition = null;
                        return cdmManifestDefinition;
                    }
                    if (entDef.getInDocument().getFolder() == null) {
                        Logger.error(this.getCtx(), TAG, "createResolvedManifestAsync", this.getAtCorpusPath(), CdmLogCode.ErrDocIsNotFolder, entDef.getEntityName());
                        cdmManifestDefinition = null;
                        return cdmManifestDefinition;
                    }
                    String sourceEntityFullPath = this.getCtx().getCorpus().getStorage().createAbsoluteCorpusPath(entDef.getInDocument().getFolder().getAtCorpusPath(), this);
                    String f = "";
                    if (sourceEntityFullPath.startsWith(sourceManifestFolderPath)) {
                        f = sourceEntityFullPath.substring(sourceManifestFolderPath.length());
                    }
                    String newDocumentFullPath = innerNewEntityDocumentNameFormat.replace("{n}", entDef.getEntityName());
                    newDocumentFullPath = newDocumentFullPath.replace("{f}", f);
                    newDocumentFullPath = this.getCtx().getCorpus().getStorage().createAbsoluteCorpusPath(newDocumentFullPath, this);
                    int newDocumentPathSplit = newDocumentFullPath.lastIndexOf("/") + 1;
                    String newDocumentPath = newDocumentFullPath.substring(0, newDocumentPathSplit);
                    String newDocumentName = newDocumentFullPath.substring(newDocumentPathSplit);
                    CdmFolderDefinition folder = (CdmFolderDefinition)this.getCtx().getCorpus().fetchObjectAsync(newDocumentPath).join();
                    if (null == folder) {
                        Logger.error(this.getCtx(), TAG, "createResolvedManifestAsync", this.getAtCorpusPath(), CdmLogCode.ErrResolveFolderNotFound, newDocumentPath);
                        CdmManifestDefinition cdmManifestDefinition2 = null;
                        return cdmManifestDefinition2;
                    }
                    AttributeResolutionDirectiveSet withDirectives = directives != null ? directives : this.getCtx().getCorpus().getDefaultResolutionDirectives();
                    ResolveOptions resOpt = new ResolveOptions(entDef.getInDocument(), withDirectives != null ? withDirectives.copy() : null);
                    Logger.debug(this.getCtx(), TAG, "createResolvedManifestAsync", this.getAtCorpusPath(), Logger.format("resolving entity {0} to document {1}", sourceEntityFullPath, newDocumentFullPath));
                    CdmEntityDefinition resolvedEntity = entDef.createResolvedEntityAsync(entDef.getEntityName(), resOpt, folder, newDocumentName).join();
                    if (null == resolvedEntity) {
                        CdmManifestDefinition cdmManifestDefinition3 = null;
                        return cdmManifestDefinition3;
                    }
                    CdmEntityDeclarationDefinition result = (CdmEntityDeclarationDefinition)entity.copy(resOpt);
                    if (result.getObjectType() == CdmObjectType.LocalEntityDeclarationDef) {
                        result.setEntityPath((String)ObjectUtils.firstNonNull((Object[])new String[]{this.getCtx().getCorpus().getStorage().createRelativeCorpusPath(resolvedEntity.getAtCorpusPath(), resolvedManifest), result.getAtCorpusPath()}));
                    }
                    resolvedManifest.getEntities().add(result);
                }
                Logger.debug(this.getCtx(), TAG, "createResolvedManifestAsync", this.getAtCorpusPath(), "calculating relationships");
                this.getCtx().getCorpus().calculateEntityGraphAsync(resolvedManifest).join();
                resolvedManifest.populateManifestRelationshipsAsync(CdmRelationshipDiscoveryStyle.Exclusive).join();
                resolvedManifest.setDirty(true);
                object = resolvedManifest;
                return object;
            }
        });
    }

    private CompletableFuture<CdmEntityDefinition> getEntityFromReferenceAsync(CdmEntityDeclarationDefinition entity, CdmManifestDefinition manifest) {
        return CompletableFuture.supplyAsync(() -> {
            String entityPath = this.createEntityPathFromDeclarationAsync(entity, manifest).join();
            CdmEntityDefinition result = (CdmEntityDefinition)this.getCtx().getCorpus().fetchObjectAsync(entityPath).join();
            if (null == result) {
                Logger.error(this.getCtx(), TAG, "getEntityFromReferenceAsync", this.getAtCorpusPath(), CdmLogCode.ErrResolveEntityFailure, entityPath);
            }
            return result;
        });
    }

    @Deprecated
    public CompletableFuture<String> createEntityPathFromDeclarationAsync(CdmEntityDeclarationDefinition entityDec) {
        return this.createEntityPathFromDeclarationAsync(entityDec, null);
    }

    CompletableFuture<String> createEntityPathFromDeclarationAsync(CdmEntityDeclarationDefinition entityDec, CdmObject obj) {
        while (entityDec instanceof CdmReferencedEntityDeclarationDefinition) {
            String currCorpusPath = this.getCtx().getCorpus().getStorage().createAbsoluteCorpusPath(entityDec.getEntityPath(), obj);
            entityDec = (CdmEntityDeclarationDefinition)this.getCtx().getCorpus().fetchObjectAsync(currCorpusPath).join();
            if (entityDec == null) {
                return null;
            }
            obj = entityDec.getInDocument();
        }
        return CompletableFuture.completedFuture(entityDec != null ? this.getCtx().getCorpus().getStorage().createAbsoluteCorpusPath(entityDec.getEntityPath(), obj) : null);
    }

    boolean isRelAllowed(CdmE2ERelationship rel, CdmRelationshipDiscoveryStyle option) {
        if (option == CdmRelationshipDiscoveryStyle.None) {
            return false;
        }
        if (option == CdmRelationshipDiscoveryStyle.Exclusive) {
            String absoluteFromEntString = this.getCtx().getCorpus().getStorage().createAbsoluteCorpusPath(rel.getFromEntity(), this);
            boolean fromEntInManifest = this.getEntities().getAllItems().stream().anyMatch(x -> Objects.equals(this.getCtx().getCorpus().getStorage().createAbsoluteCorpusPath(x.getEntityPath(), this), absoluteFromEntString));
            String absoluteToEntString = this.getCtx().getCorpus().getStorage().createAbsoluteCorpusPath(rel.getToEntity(), this);
            boolean toEntInManifest = this.getEntities().getAllItems().parallelStream().anyMatch(x -> Objects.equals(this.getCtx().getCorpus().getStorage().createAbsoluteCorpusPath(x.getEntityPath(), this), absoluteToEntString));
            return fromEntInManifest && toEntInManifest;
        }
        return true;
    }

    CdmE2ERelationship localizeRelToManifest(CdmE2ERelationship rel) {
        CdmE2ERelationship relCopy = (CdmE2ERelationship)this.getCtx().getCorpus().makeObject(CdmObjectType.E2ERelationshipDef, rel.getName());
        relCopy.setToEntity(this.getCtx().getCorpus().getStorage().createRelativeCorpusPath(rel.getToEntity(), this));
        relCopy.setFromEntity(this.getCtx().getCorpus().getStorage().createRelativeCorpusPath(rel.getFromEntity(), this));
        relCopy.setToEntityAttribute(rel.getToEntityAttribute());
        relCopy.setFromEntityAttribute(rel.getFromEntityAttribute());
        relCopy.getExhibitsTraits().addAll(rel.getExhibitsTraits());
        return relCopy;
    }

    String rel2CacheKey(CdmE2ERelationship rel) {
        String nameAndPipe = "";
        if (!StringUtils.isNullOrTrimEmpty(rel.getName())) {
            nameAndPipe = rel.getName() + "|";
        }
        return nameAndPipe + rel.getToEntity() + "|" + rel.getToEntityAttribute() + "|" + rel.getFromEntity() + "|" + rel.getFromEntityAttribute();
    }
}

