/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.commondatamodel.objectmodel.cdm;

import com.microsoft.commondatamodel.objectmodel.cdm.CdmAttributeContext;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmCorpusContext;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmObject;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmObjectBase;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmObjectDefinitionBase;
import com.microsoft.commondatamodel.objectmodel.enums.CdmLogCode;
import com.microsoft.commondatamodel.objectmodel.enums.CdmObjectType;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.ResolvedAttributeSetBuilder;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.ResolvedTraitSetBuilder;
import com.microsoft.commondatamodel.objectmodel.utilities.CopyOptions;
import com.microsoft.commondatamodel.objectmodel.utilities.ResolveOptions;
import com.microsoft.commondatamodel.objectmodel.utilities.StringUtils;
import com.microsoft.commondatamodel.objectmodel.utilities.VisitCallback;
import com.microsoft.commondatamodel.objectmodel.utilities.logger.Logger;
import java.util.ArrayList;
import java.util.stream.Collectors;

public class CdmTraitGroupDefinition
extends CdmObjectDefinitionBase {
    private final String TAG = CdmObjectDefinitionBase.class.getSimpleName();
    private String traitGroupName;

    public CdmTraitGroupDefinition(CdmCorpusContext ctx, String traitGroupName) {
        super(ctx);
        this.setObjectType(CdmObjectType.TraitGroupDef);
        this.traitGroupName = traitGroupName;
    }

    @Override
    public CdmObject copy(ResolveOptions resOpt, CdmObject host) {
        CdmTraitGroupDefinition copy;
        if (resOpt == null) {
            resOpt = new ResolveOptions(this, this.getCtx().getCorpus().getDefaultResolutionDirectives());
        }
        if (host == null) {
            copy = new CdmTraitGroupDefinition(this.getCtx(), this.getTraitGroupName());
        } else {
            copy = (CdmTraitGroupDefinition)host;
            copy.setCtx(this.getCtx());
            copy.setTraitGroupName(this.getTraitGroupName());
        }
        this.copyDef(resOpt, copy);
        return copy;
    }

    @Override
    public boolean validate() {
        if (StringUtils.isNullOrTrimEmpty(this.getTraitGroupName())) {
            ArrayList<String> missingFields = new ArrayList<String>();
            missingFields.add("TraitGroupName");
            Logger.error(this.getCtx(), this.TAG, "validate", this.getAtCorpusPath(), CdmLogCode.ErrValdnIntegrityCheckFailure, this.getAtCorpusPath(), missingFields.parallelStream().map(s -> String.format("'%s'", s)).collect(Collectors.joining(", ")));
            return false;
        }
        return true;
    }

    @Override
    @Deprecated
    public Object copyData(ResolveOptions resOpt, CopyOptions options) {
        return CdmObjectBase.copyData(this, resOpt, options);
    }

    @Override
    public boolean isDerivedFrom(String baseDef, ResolveOptions resOpt) {
        return false;
    }

    @Override
    public boolean visit(String pathFrom, VisitCallback preChildren, VisitCallback postChildren) {
        String path = "";
        if (!this.getCtx().getCorpus().getBlockDeclaredPathChanges() && StringUtils.isNullOrTrimEmpty(path = this.getDeclaredPath())) {
            path = pathFrom + this.getTraitGroupName();
            this.setDeclaredPath(path);
        }
        if (preChildren != null && preChildren.invoke(this, path)) {
            return false;
        }
        if (this.visitDef(path, preChildren, postChildren)) {
            return true;
        }
        return postChildren != null && postChildren.invoke(this, path);
    }

    @Override
    @Deprecated
    void constructResolvedTraits(ResolvedTraitSetBuilder rtsb, ResolveOptions resOpt) {
        this.constructResolvedTraitsDef(null, rtsb, resOpt);
    }

    @Override
    @Deprecated
    public ResolvedAttributeSetBuilder constructResolvedAttributes(ResolveOptions resOpt) {
        return null;
    }

    @Override
    @Deprecated
    public ResolvedAttributeSetBuilder constructResolvedAttributes(ResolveOptions resOpt, CdmAttributeContext under) {
        return null;
    }

    public String getTraitGroupName() {
        return this.traitGroupName;
    }

    public void setTraitGroupName(String traitGroupName) {
        this.traitGroupName = traitGroupName;
    }

    @Override
    public String getName() {
        return this.getTraitGroupName();
    }
}

