/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.commondatamodel.objectmodel.resolvedmodel;

import com.microsoft.commondatamodel.objectmodel.cdm.CdmCorpusContext;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmCorpusDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmObjectBase;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmTraitDefinition;
import com.microsoft.commondatamodel.objectmodel.enums.CdmStatusLevel;
import com.microsoft.commondatamodel.objectmodel.utilities.EventCallback;
import com.microsoft.commondatamodel.objectmodel.utilities.ResolveContextScope;
import com.microsoft.commondatamodel.objectmodel.utilities.ResolveOptions;
import com.microsoft.commondatamodel.objectmodel.utilities.logger.EventList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Stack;

public class ResolveContext
implements CdmCorpusContext {
    protected final Map<String, Object> cache;
    String corpusPathRoot;
    private Stack<ResolveContextScope> scopeStack;
    private ResolveContextScope currentScope;
    private CdmCorpusDefinition corpus;
    private String relativePath;
    private CdmStatusLevel reportAtLevel;
    private EventCallback statusEvent;
    private EventList events;
    private String correlationId;

    public ResolveContext(CdmCorpusDefinition corpus) {
        this(corpus, null);
    }

    public ResolveContext(CdmCorpusDefinition corpus, EventCallback statusEvent) {
        this(corpus, statusEvent, null);
    }

    public ResolveContext(CdmCorpusDefinition corpus, EventCallback statusEvent, CdmStatusLevel reportAtLevel) {
        this.reportAtLevel = reportAtLevel != null ? reportAtLevel : CdmStatusLevel.Warning;
        this.statusEvent = statusEvent;
        this.cache = new LinkedHashMap<String, Object>();
        this.corpus = corpus;
        this.events = new EventList();
    }

    @Override
    public CdmCorpusDefinition getCorpus() {
        return this.corpus;
    }

    @Override
    public void setCorpus(CdmCorpusDefinition value) {
        this.corpus = value;
    }

    @Override
    public CdmStatusLevel getReportAtLevel() {
        return this.reportAtLevel;
    }

    @Override
    public void setReportAtLevel(CdmStatusLevel value) {
        this.reportAtLevel = value;
    }

    @Override
    public EventCallback getStatusEvent() {
        return this.statusEvent;
    }

    @Override
    public void setStatusEvent(EventCallback value) {
        this.statusEvent = value;
    }

    @Override
    public EventList getEvents() {
        return this.events;
    }

    @Override
    public String getCorrelationId() {
        return this.correlationId;
    }

    @Override
    public void setCorrelationId(String correlationId) {
        this.correlationId = correlationId;
    }

    public void pushScope(CdmTraitDefinition currentTrait) {
        if (this.scopeStack == null) {
            this.scopeStack = new Stack();
        }
        ResolveContextScope ctxNew = new ResolveContextScope();
        if (currentTrait == null && this.currentScope != null) {
            currentTrait = this.currentScope.getCurrentTrait();
        }
        ctxNew.setCurrentTrait(currentTrait);
        ctxNew.setCurrentParameter(0);
        this.currentScope = ctxNew;
        this.scopeStack.push(ctxNew);
    }

    public void popScope() {
        this.scopeStack.pop();
        this.currentScope = this.scopeStack.size() > 0 ? this.scopeStack.peek() : null;
    }

    public Object fetchCache(CdmObjectBase forObj, String kind, ResolveOptions resOpt) {
        String key = forObj.getId() + "_" + (resOpt.getWrtDoc() != null ? Integer.valueOf(resOpt.getWrtDoc().getId()) : "NULL") + "_" + kind;
        return this.cache.get(key);
    }

    public Map<String, Object> fetchCache() {
        return this.cache;
    }

    public void updateCache(CdmObjectBase forObj, String kind, Object value, ResolveOptions resOpt) {
        String key = forObj.getId() + "_" + (resOpt.getWrtDoc() != null ? Integer.valueOf(resOpt.getWrtDoc().getId()) : "NULL") + "_" + kind;
        if (!this.cache.containsKey(key)) {
            this.cache.put(key, value);
        } else {
            this.cache.replace(key, value);
        }
    }

    @Deprecated
    public String getRelativePath() {
        return this.relativePath;
    }

    @Deprecated
    public void setRelativePath(String relativePath) {
        this.relativePath = relativePath;
    }

    @Deprecated
    public Stack<ResolveContextScope> getScopeStack() {
        return this.scopeStack;
    }

    @Deprecated
    public ResolveContextScope getCurrentScope() {
        return this.currentScope;
    }

    @Deprecated
    public String getCorpusPathRoot() {
        return this.corpusPathRoot;
    }

    @Deprecated
    public void setCorpusPathRoot(String corpusPathRoot) {
        this.corpusPathRoot = corpusPathRoot;
    }

    @Deprecated
    public Map<String, Object> getCache() {
        return this.cache;
    }
}

