/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.commondatamodel.objectmodel.storage;

import com.microsoft.aad.msal4j.AzureCloudEndpoint;
import com.microsoft.aad.msal4j.ClientCredentialFactory;
import com.microsoft.aad.msal4j.ClientCredentialParameters;
import com.microsoft.aad.msal4j.ConfidentialClientApplication;
import com.microsoft.aad.msal4j.IAuthenticationResult;
import com.microsoft.aad.msal4j.IClientCredential;
import com.microsoft.aad.msal4j.IClientSecret;
import com.microsoft.commondatamodel.objectmodel.storage.StorageAdapterException;
import com.microsoft.commondatamodel.objectmodel.utilities.StringUtils;
import com.microsoft.commondatamodel.objectmodel.utilities.network.TokenProvider;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;

class AdlsAdapterAuthenticator {
    private static final String HMAC_SHA256 = "HmacSHA256";
    private static final String HTTP_AUTHORIZATION = "Authorization";
    private static final String HTTP_XMS_DATE = "x-ms-date";
    private static final String HTTP_XMS_VERSION = "x-ms-version";
    private static final Set<String> SCOPE = Collections.singleton("https://storage.azure.com/.default");
    private String sharedKey = null;
    private String tenant = null;
    private String clientId = null;
    private String secret = null;
    private ConfidentialClientApplication context;
    private String sasToken;
    private IAuthenticationResult lastAuthenticationResult;
    private TokenProvider tokenProvider = null;

    AdlsAdapterAuthenticator() {
    }

    Map<String, String> buildAuthenticationHeader(String url, String method, String content, String contentType) throws NoSuchAlgorithmException, InvalidKeyException, URISyntaxException, UnsupportedEncodingException {
        if (this.sharedKey != null) {
            return this.buildAuthenticationHeaderWithSharedKey(url, method, content, contentType);
        }
        if (this.tokenProvider != null) {
            LinkedHashMap<String, String> header = new LinkedHashMap<String, String>();
            header.put("authorization", this.tokenProvider.getToken());
            return header;
        }
        if (this.clientId != null && this.tenant != null && this.secret != null) {
            return this.buildAuthenticationHeaderWithClientIdAndSecret();
        }
        throw new StorageAdapterException("ADLS adapter is not configured with any auth method");
    }

    String buildSasAuthenticatedUrl(String url) {
        return url + (url.contains("?") ? "&" : "?") + this.sasToken;
    }

    private Map<String, String> buildAuthenticationHeaderWithSharedKey(String url, String method, String content, String contentType) throws URISyntaxException, NoSuchAlgorithmException, InvalidKeyException, UnsupportedEncodingException {
        LinkedHashMap<String, String> headers = new LinkedHashMap<String, String>();
        headers.put(HTTP_XMS_DATE, DateTimeFormatter.RFC_1123_DATE_TIME.format(ZonedDateTime.now(ZoneOffset.ofHours(0))));
        headers.put(HTTP_XMS_VERSION, "2018-06-17");
        int contentLength = 0;
        if (content != null) {
            contentLength = content.getBytes().length;
        }
        URI uri = new URI(url);
        StringBuilder builder = new StringBuilder();
        builder.append(method).append("\n");
        builder.append("\n");
        builder.append("\n");
        builder.append(contentLength != 0 ? Integer.valueOf(contentLength) : "").append("\n");
        builder.append("\n");
        builder.append(contentType != null ? contentType : "").append("\n");
        builder.append("\n");
        builder.append("\n");
        builder.append("\n");
        builder.append("\n");
        builder.append("\n");
        builder.append("\n");
        for (Map.Entry header : headers.entrySet()) {
            builder.append((String)header.getKey()).append(":").append((String)header.getValue()).append("\n");
        }
        String accountName = uri.getHost().split("\\.")[0];
        builder.append("/").append(accountName);
        builder.append(uri.getRawPath());
        if (!StringUtils.isNullOrEmpty(uri.getQuery())) {
            String[] queryParts;
            String queryParameters = uri.getRawQuery();
            for (String item : queryParts = queryParameters.split("&")) {
                String[] keyValuePair = item.split("=");
                String queryName = keyValuePair[0].toLowerCase();
                String decodedValue = URLDecoder.decode(keyValuePair[1], "UTF-8");
                builder.append("\n").append(queryName).append(":").append(decodedValue);
            }
        }
        Mac sha256_HMAC = Mac.getInstance(HMAC_SHA256);
        SecretKeySpec secret_key = new SecretKeySpec(Base64.decodeBase64((byte[])this.sharedKey.getBytes()), HMAC_SHA256);
        sha256_HMAC.init(secret_key);
        String hash = Base64.encodeBase64String((byte[])sha256_HMAC.doFinal(builder.toString().getBytes(StandardCharsets.UTF_8)));
        headers.put(HTTP_AUTHORIZATION, "SharedKey " + accountName + ":" + hash);
        return headers;
    }

    private Map<String, String> buildAuthenticationHeaderWithClientIdAndSecret() {
        LinkedHashMap<String, String> header = new LinkedHashMap<String, String>();
        if (this.needsRefreshToken()) {
            this.refreshToken();
        }
        header.put("authorization", "Bearer " + this.lastAuthenticationResult.accessToken());
        return header;
    }

    private boolean needsRefreshToken() {
        if (this.lastAuthenticationResult == null) {
            return true;
        }
        Date now = new Date();
        return this.lastAuthenticationResult.expiresOnDate().before(now);
    }

    private void refreshToken() {
        IAuthenticationResult result;
        this.buildContext();
        try {
            ClientCredentialParameters parameters = ClientCredentialParameters.builder(SCOPE).build();
            result = (IAuthenticationResult)this.context.acquireToken(parameters).join();
        }
        catch (Exception ex) {
            throw new StorageAdapterException("There was an error while acquiring ADLS Adapter's Token with client ID/secret authentication. Exception: ", ex);
        }
        if (result == null || result.accessToken() == null) {
            throw new StorageAdapterException("Received invalid ADLS Adapter's authentication result. The result might be null, or missing access token from the authentication result.");
        }
        this.lastAuthenticationResult = result;
    }

    private void buildContext() {
        if (this.context == null) {
            IClientSecret credential = ClientCredentialFactory.createFromSecret((String)this.secret);
            try {
                this.context = ((ConfidentialClientApplication.Builder)ConfidentialClientApplication.builder((String)this.clientId, (IClientCredential)credential).authority(AzureCloudEndpoint.AzurePublic.endpoint + this.tenant)).build();
            }
            catch (MalformedURLException e) {
                throw new StorageAdapterException("There was an error while building context. Exception: ", e);
            }
        }
    }

    String getSharedKey() {
        return this.sharedKey;
    }

    void setSharedKey(String sharedKey) {
        this.sharedKey = sharedKey;
    }

    String getTenant() {
        return this.tenant;
    }

    void setTenant(String tenant) {
        this.tenant = tenant;
    }

    String getClientId() {
        return this.clientId;
    }

    void setClientId(String clientId) {
        this.clientId = clientId;
    }

    String getSecret() {
        return this.secret;
    }

    void setSecret(String secret) {
        this.secret = secret;
    }

    String getSasToken() {
        return this.sasToken;
    }

    void setSasToken(String sasToken) {
        this.sasToken = sasToken != null ? (sasToken.startsWith("?") ? sasToken.substring(1) : sasToken) : null;
    }

    TokenProvider getTokenProvider() {
        return this.tokenProvider;
    }

    void setTokenProvider(TokenProvider tokenProvider) {
        this.tokenProvider = tokenProvider;
    }
}

