/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.commondatamodel.objectmodel.cdm;

import com.microsoft.commondatamodel.objectmodel.cdm.CdmContainerDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmCorpusContext;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmCorpusDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmDocumentCollection;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmDocumentDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmFolderCollection;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmObject;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmObjectBase;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmObjectDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmObjectDefinitionBase;
import com.microsoft.commondatamodel.objectmodel.enums.CdmLogCode;
import com.microsoft.commondatamodel.objectmodel.enums.CdmObjectType;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.ResolvedTraitSet;
import com.microsoft.commondatamodel.objectmodel.storage.StorageAdapter;
import com.microsoft.commondatamodel.objectmodel.utilities.CopyOptions;
import com.microsoft.commondatamodel.objectmodel.utilities.ResolveOptions;
import com.microsoft.commondatamodel.objectmodel.utilities.StringUtils;
import com.microsoft.commondatamodel.objectmodel.utilities.VisitCallback;
import com.microsoft.commondatamodel.objectmodel.utilities.logger.Logger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;

public class CdmFolderDefinition
extends CdmObjectDefinitionBase
implements CdmContainerDefinition {
    private static final String TAG = CdmFolderDefinition.class.getSimpleName();
    private final Map<String, CdmDocumentDefinition> documentLookup = new LinkedHashMap<String, CdmDocumentDefinition>();
    private final CdmFolderCollection childFolders = new CdmFolderCollection(this.getCtx(), this);
    private final CdmDocumentCollection documents = new CdmDocumentCollection(this.getCtx(), this);
    private CdmCorpusDefinition corpus;
    private String name;
    private String folderPath;
    private String namespace;

    public CdmFolderDefinition(CdmCorpusContext ctx, String name) {
        super(ctx);
        this.name = name;
        this.folderPath = name + "/";
        this.setObjectType(CdmObjectType.FolderDef);
    }

    @Deprecated
    public CdmCorpusDefinition getCorpus() {
        return this.corpus;
    }

    @Deprecated
    public void setCorpus(CdmCorpusDefinition corpus) {
        this.corpus = corpus;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getFolderPath() {
        return this.folderPath;
    }

    @Override
    @Deprecated
    public void setFolderPath(String folderPath) {
        this.folderPath = folderPath;
    }

    public CdmFolderCollection getChildFolders() {
        return this.childFolders;
    }

    public CdmDocumentCollection getDocuments() {
        return this.documents;
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    @Deprecated
    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    CompletableFuture<CdmDocumentDefinition> fetchDocumentFromFolderPathAsync(String path, StorageAdapter adapter) {
        return this.fetchDocumentFromFolderPathAsync(path, adapter, false);
    }

    CompletableFuture<CdmDocumentDefinition> fetchDocumentFromFolderPathAsync(String path, StorageAdapter adapter, boolean forceReload) {
        return this.fetchDocumentFromFolderPathAsync(path, adapter, forceReload, null);
    }

    @Deprecated
    public Map<String, CdmDocumentDefinition> getDocumentLookup() {
        return this.documentLookup;
    }

    @Deprecated
    CompletableFuture<CdmDocumentDefinition> fetchDocumentFromFolderPathAsync(String objectPath, StorageAdapter adapter, boolean forceReload, ResolveOptions resOpt) {
        int first = objectPath.indexOf("/");
        String docName = first < 0 ? objectPath : objectPath.substring(0, first);
        CdmDocumentDefinition doc = this.documentLookup.get(docName);
        if (this.documentLookup.containsKey(docName)) {
            if (!forceReload) {
                return CompletableFuture.completedFuture(doc);
            }
            if (doc.isDirty()) {
                Logger.warning(this.getCtx(), TAG, "fetchDocumentFromFolderPathAsync", this.getAtCorpusPath(), CdmLogCode.WarnDocChangesDiscarded, doc.getName());
            }
            this.documents.remove(docName);
        }
        return this.corpus.getPersistence().loadDocumentFromPathAsync(this, docName, doc, resOpt);
    }

    @Override
    public <T extends CdmObjectDefinition> T fetchObjectDefinition(ResolveOptions resOpt) {
        return null;
    }

    @Override
    @Deprecated
    public ResolvedTraitSet fetchResolvedTraits(ResolveOptions resOpt) {
        return null;
    }

    @Deprecated
    public CdmFolderDefinition fetchChildFolderFromPath(String path, boolean makeFolder) {
        String remainingPath = path;
        CdmFolderDefinition childFolder = this;
        while (childFolder != null && remainingPath.indexOf(47) != -1) {
            String name;
            int first = remainingPath.indexOf(47);
            if (first < 0) {
                name = remainingPath;
                remainingPath = "";
            } else {
                name = StringUtils.slice(remainingPath, 0, first);
                remainingPath = StringUtils.slice(remainingPath, first + 1);
            }
            if (!name.equalsIgnoreCase(childFolder.getName())) {
                Logger.error(this.getCtx(), TAG, "fetchChildFolderFromPath", this.getAtCorpusPath(), CdmLogCode.ErrInvalidPath, path);
                return null;
            }
            if (remainingPath.length() == 0) {
                return childFolder;
            }
            first = remainingPath.indexOf(47);
            String childFolderName = remainingPath;
            if (first == -1) break;
            childFolderName = StringUtils.slice(remainingPath, 0, first);
            CdmFolderDefinition result = null;
            for (int i = 0; i < childFolder.getChildFolders().size(); ++i) {
                CdmFolderDefinition folder = (CdmFolderDefinition)childFolder.getChildFolders().get(i);
                if (!childFolderName.equalsIgnoreCase(folder.getName())) continue;
                result = folder;
                break;
            }
            if (result == null) {
                result = childFolder.getChildFolders().add(childFolderName);
            }
            childFolder = result;
        }
        if (makeFolder) {
            childFolder = childFolder.childFolders.add(remainingPath);
        }
        return childFolder;
    }

    @Deprecated
    CompletableFuture<CdmFolderDefinition> fetchChildFolderFromPathAsync(String path) {
        return this.fetchChildFolderFromPathAsync(path, false);
    }

    @Deprecated
    public CompletableFuture<CdmFolderDefinition> fetchChildFolderFromPathAsync(String path, boolean makeFolder) {
        return CompletableFuture.completedFuture(this.fetchChildFolderFromPath(path, makeFolder));
    }

    @Override
    public boolean visit(String pathRoot, VisitCallback preChildren, VisitCallback postChildren) {
        return false;
    }

    @Override
    public boolean isDerivedFrom(String baseDef, ResolveOptions resOpt) {
        return false;
    }

    @Override
    public String getAtCorpusPath() {
        if (this.namespace == null) {
            return "NULL:" + this.folderPath;
        }
        return this.namespace + ":" + this.folderPath;
    }

    @Override
    public boolean validate() {
        if (StringUtils.isNullOrTrimEmpty(this.name)) {
            ArrayList<String> missingFields = new ArrayList<String>(Arrays.asList("name"));
            Logger.error(this.getCtx(), TAG, "validate", this.getAtCorpusPath(), CdmLogCode.ErrValdnIntegrityCheckFailure, this.getAtCorpusPath(), String.join((CharSequence)", ", missingFields.parallelStream().map(s -> String.format("'%s'", s)).collect(Collectors.toList())));
            return false;
        }
        return true;
    }

    @Override
    @Deprecated
    public Object copyData(ResolveOptions resOpt, CopyOptions options) {
        return CdmObjectBase.copyData(this, resOpt, options, CdmFolderDefinition.class);
    }

    @Override
    public CdmObject copy(ResolveOptions resOpt, CdmObject host) {
        return null;
    }
}

