/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.commondatamodel.objectmodel.cdm;

import com.microsoft.commondatamodel.objectmodel.cdm.CdmCorpusContext;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmCorpusDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmObject;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmObjectBase;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmObjectDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmObjectReference;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmObjectReferenceBase;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmTraitCollection;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmTraitReferenceBase;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.ResolvedTraitSetBuilder;
import com.microsoft.commondatamodel.objectmodel.utilities.ResolveOptions;
import com.microsoft.commondatamodel.objectmodel.utilities.StringUtils;
import com.microsoft.commondatamodel.objectmodel.utilities.VisitCallback;

public abstract class CdmObjectDefinitionBase
extends CdmObjectBase
implements CdmObjectDefinition {
    private String explanation;
    private CdmTraitCollection exhibitsTraits = new CdmTraitCollection(this.getCtx(), this);

    public CdmObjectDefinitionBase(CdmCorpusContext ctx) {
        super(ctx);
    }

    @Override
    public abstract String getName();

    @Override
    public CdmTraitCollection getExhibitsTraits() {
        return this.exhibitsTraits;
    }

    @Override
    public String getExplanation() {
        return this.explanation;
    }

    @Override
    public void setExplanation(String explanation) {
        this.explanation = explanation;
    }

    @Override
    public CdmObjectReference createSimpleReference(ResolveOptions resOpt) {
        if (resOpt == null) {
            resOpt = new ResolveOptions(this, this.getCtx().getCorpus().getDefaultResolutionDirectives());
        }
        String name = !StringUtils.isNullOrEmpty(this.getDeclaredPath()) ? this.getDeclaredPath() : this.getName();
        CdmObjectReferenceBase cdmObjectRef = (CdmObjectReferenceBase)this.getCtx().getCorpus().makeObject(CdmCorpusDefinition.mapReferenceType(this.getObjectType()), name, true);
        if (resOpt.isSaveResolutionsOnCopy()) {
            cdmObjectRef.setExplicitReference(this);
            cdmObjectRef.setInDocument(this.getInDocument());
        }
        return cdmObjectRef;
    }

    @Override
    public <T extends CdmObjectDefinition> T fetchObjectDefinition(ResolveOptions resOpt) {
        if (resOpt == null) {
            resOpt = new ResolveOptions(this, this.getCtx().getCorpus().getDefaultResolutionDirectives());
        }
        return (T)this;
    }

    @Override
    public String fetchObjectDefinitionName() {
        return this.getName();
    }

    @Deprecated
    public void copyDef(ResolveOptions resOpt, CdmObjectDefinitionBase copy) {
        copy.setDeclaredPath(this.getDeclaredPath());
        copy.setExplanation(this.getExplanation());
        copy.getExhibitsTraits().clear();
        for (CdmTraitReferenceBase trait : this.getExhibitsTraits()) {
            copy.getExhibitsTraits().add(trait);
        }
        copy.setInDocument(this.getInDocument());
    }

    boolean isDerivedFromDef(ResolveOptions resOpt, CdmObjectReference baseCdmObjectReference, String name, String seek) {
        if (seek != null && seek.equals(name)) {
            return true;
        }
        CdmObject def = null;
        if (baseCdmObjectReference != null) {
            def = (CdmObject)baseCdmObjectReference.fetchObjectDefinition(resOpt);
        }
        if (def != null) {
            return def.isDerivedFrom(seek, resOpt);
        }
        return false;
    }

    void constructResolvedTraitsDef(CdmObjectReference baseCdmObjectReference, ResolvedTraitSetBuilder rtsb, ResolveOptions resOpt) {
        if (null != baseCdmObjectReference) {
            rtsb.mergeTraits(baseCdmObjectReference.fetchResolvedTraits(resOpt));
        }
        if (null != this.getExhibitsTraits()) {
            for (CdmTraitReferenceBase exhibitsTrait : this.getExhibitsTraits()) {
                rtsb.mergeTraits(exhibitsTrait.fetchResolvedTraits(resOpt));
            }
        }
    }

    boolean visitDef(String pathFrom, VisitCallback preChildren, VisitCallback postChildren) {
        return this.getExhibitsTraits() != null && this.exhibitsTraits.visitList(pathFrom + "/exhibitsTraits/", preChildren, postChildren);
    }

    @Override
    @Deprecated
    public CdmObjectReference createPortableReference(ResolveOptions resOpt) {
        CdmObjectReferenceBase cdmObjectRef = (CdmObjectReferenceBase)this.getCtx().getCorpus().makeObject(CdmCorpusDefinition.mapReferenceType(this.getObjectType()), "portable", true);
        cdmObjectRef.portableReference = this;
        cdmObjectRef.setInDocument(this.getInDocument());
        cdmObjectRef.setOwner(this.getOwner());
        return cdmObjectRef;
    }
}

