/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.commondatamodel.objectmodel.cdm.projections;

import com.microsoft.commondatamodel.objectmodel.cdm.CdmAttribute;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmCorpusContext;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmTypeAttributeDefinition;
import com.microsoft.commondatamodel.objectmodel.enums.CdmLogCode;
import com.microsoft.commondatamodel.objectmodel.utilities.StringUtils;
import com.microsoft.commondatamodel.objectmodel.utilities.logger.Logger;

public class CardinalitySettings {
    private static final String TAG = CardinalitySettings.class.getSimpleName();
    private static final int defaultMinimum = 1;
    private static final int defaultMaximum = 1;
    private final int infiniteMaximum = -1;
    private int _minimumNumber = 1;
    private int _maximumNumber = 1;
    private String _minimum;
    private String _maximum;
    private CdmCorpusContext ctx;
    private CdmAttribute owner;

    public CardinalitySettings(CdmAttribute owner) {
        this.owner = owner;
        this.ctx = owner != null ? owner.getCtx() : null;
    }

    @Deprecated
    public int getMinimumNumber() {
        return this._minimumNumber;
    }

    @Deprecated
    public void setMinimumNumber(int minimumNumber) {
        this._minimumNumber = minimumNumber;
    }

    @Deprecated
    public int getMaximumNumber() {
        return this._maximumNumber;
    }

    @Deprecated
    public void setMaximumNumber(int maximumNumber) {
        this._maximumNumber = maximumNumber;
    }

    public String getMinimum() {
        return this._minimum;
    }

    public void setMinimum(String minimum) {
        if (!CardinalitySettings.isMinimumValid(minimum)) {
            Logger.error(this.ctx, TAG, "setMinimum", this.owner.getAtCorpusPath(), CdmLogCode.ErrValdnInvalidMinCardinality, minimum);
        } else {
            this._minimum = minimum;
            this._minimumNumber = this.getNumber(this._minimum, 1);
            if (this.owner != null && this.owner instanceof CdmTypeAttributeDefinition) {
                ((CdmTypeAttributeDefinition)this.owner).updateIsNullable(this._minimumNumber == 0);
            }
        }
    }

    public String getMaximum() {
        return this._maximum;
    }

    public void setMaximum(String maximum) {
        if (!CardinalitySettings.isMaximumValid(maximum)) {
            Logger.error(this.ctx, TAG, "setMaximum", this.owner.getAtCorpusPath(), CdmLogCode.ErrValdnInvalidMaxCardinality, maximum);
        } else {
            this._maximum = maximum;
            this._maximumNumber = this.getNumber(this._maximum, 1);
        }
    }

    private int getNumber(String value, int defaultValue) {
        if (StringUtils.equalsWithIgnoreCase(value, "*")) {
            return -1;
        }
        try {
            int number = Integer.parseInt(value);
            return number;
        }
        catch (NumberFormatException e) {
            Logger.error(this.ctx, TAG, "getNumber", this.owner.getAtCorpusPath(), CdmLogCode.ErrProjStringError, value, Integer.toString(defaultValue));
            return defaultValue;
        }
    }

    @Deprecated
    public static boolean isMinimumValid(String minimum) {
        if (!StringUtils.isNullOrTrimEmpty(minimum)) {
            try {
                int minNumber = Integer.parseInt(minimum);
                return minNumber >= 0 && minNumber <= Integer.MAX_VALUE;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        return false;
    }

    @Deprecated
    public static boolean isMaximumValid(String maximum) {
        if (!StringUtils.isNullOrTrimEmpty(maximum)) {
            if (StringUtils.equalsWithIgnoreCase(maximum, "*")) {
                return true;
            }
            try {
                int maxNumber = Integer.parseInt(maximum);
                return maxNumber >= 1 && maxNumber <= Integer.MAX_VALUE;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        return false;
    }
}

