/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.commondatamodel.objectmodel.cdm.projections;

import com.microsoft.commondatamodel.objectmodel.cdm.CdmAttributeContext;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmCorpusContext;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmObject;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmObjectBase;
import com.microsoft.commondatamodel.objectmodel.cdm.projections.CdmOperationBase;
import com.microsoft.commondatamodel.objectmodel.enums.CdmAttributeContextType;
import com.microsoft.commondatamodel.objectmodel.enums.CdmLogCode;
import com.microsoft.commondatamodel.objectmodel.enums.CdmObjectType;
import com.microsoft.commondatamodel.objectmodel.enums.CdmOperationType;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.ResolvedAttribute;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.ResolvedAttributeSet;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.projections.ProjectionAttributeState;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.projections.ProjectionAttributeStateSet;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.projections.ProjectionContext;
import com.microsoft.commondatamodel.objectmodel.utilities.AttributeContextParameters;
import com.microsoft.commondatamodel.objectmodel.utilities.CopyOptions;
import com.microsoft.commondatamodel.objectmodel.utilities.ResolveOptions;
import com.microsoft.commondatamodel.objectmodel.utilities.StringUtils;
import com.microsoft.commondatamodel.objectmodel.utilities.VisitCallback;
import com.microsoft.commondatamodel.objectmodel.utilities.logger.Logger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.stream.Collectors;

public class CdmOperationArrayExpansion
extends CdmOperationBase {
    private static final String TAG = CdmOperationArrayExpansion.class.getSimpleName();
    private Integer startOrdinal;
    private Integer endOrdinal;

    public CdmOperationArrayExpansion(CdmCorpusContext ctx) {
        super(ctx);
        this.setObjectType(CdmObjectType.OperationArrayExpansionDef);
        this.setType(CdmOperationType.ArrayExpansion);
    }

    public Integer getStartOrdinal() {
        return this.startOrdinal;
    }

    public void setStartOrdinal(Integer startOrdinal) {
        this.startOrdinal = startOrdinal;
    }

    public Integer getEndOrdinal() {
        return this.endOrdinal;
    }

    public void setEndOrdinal(Integer endOrdinal) {
        this.endOrdinal = endOrdinal;
    }

    @Override
    public CdmObject copy(ResolveOptions resOpt, CdmObject host) {
        CdmOperationArrayExpansion copy = new CdmOperationArrayExpansion(this.getCtx());
        copy.startOrdinal = this.startOrdinal;
        copy.endOrdinal = this.endOrdinal;
        return copy;
    }

    @Override
    @Deprecated
    public Object copyData(ResolveOptions resOpt, CopyOptions options) {
        return CdmObjectBase.copyData(this, resOpt, options, CdmOperationArrayExpansion.class);
    }

    @Override
    public String getName() {
        return "operationArrayExpansion";
    }

    @Override
    @Deprecated
    public CdmObjectType getObjectType() {
        return CdmObjectType.OperationArrayExpansionDef;
    }

    @Override
    public boolean validate() {
        ArrayList<String> missingFields = new ArrayList<String>();
        if (this.startOrdinal == null) {
            missingFields.add("startOrdinal");
        }
        if (this.endOrdinal == null) {
            missingFields.add("endOrdinal");
        }
        if (missingFields.size() > 0) {
            Logger.error(this.getCtx(), TAG, "validate", this.getAtCorpusPath(), CdmLogCode.ErrValdnIntegrityCheckFailure, this.getAtCorpusPath(), String.join((CharSequence)", ", missingFields.parallelStream().map(s -> String.format("'%s'", s)).collect(Collectors.toList())));
            return false;
        }
        return true;
    }

    @Override
    public boolean visit(String pathFrom, VisitCallback preChildren, VisitCallback postChildren) {
        String path = "";
        if (!this.getCtx().getCorpus().getBlockDeclaredPathChanges() && StringUtils.isNullOrEmpty(path = this.getDeclaredPath())) {
            path = pathFrom + "operationArrayExpansion";
            this.setDeclaredPath(path);
        }
        if (preChildren != null && preChildren.invoke(this, path)) {
            return false;
        }
        return postChildren != null && postChildren.invoke(this, path);
    }

    @Override
    @Deprecated
    public ProjectionAttributeStateSet appendProjectionAttributeState(ProjectionContext projCtx, ProjectionAttributeStateSet projOutputSet, CdmAttributeContext attrCtx) {
        AttributeContextParameters attrCtxOpArrayExpansionParam = new AttributeContextParameters();
        attrCtxOpArrayExpansionParam.setUnder(attrCtx);
        attrCtxOpArrayExpansionParam.setType(CdmAttributeContextType.OperationArrayExpansion);
        attrCtxOpArrayExpansionParam.setName("operation/index" + this.getIndex() + "/operationArrayExpansion");
        CdmAttributeContext attrCtxOpArrayExpansion = CdmAttributeContext.createChildUnder(projCtx.getProjectionDirective().getResOpt(), attrCtxOpArrayExpansionParam);
        int round = 0;
        ArrayList<ProjectionAttributeState> projAttrStatesFromRounds = new ArrayList<ProjectionAttributeState>();
        if (this.startOrdinal > this.endOrdinal) {
            Logger.warning(this.getCtx(), TAG, "appendProjectionAttributeState", this.getAtCorpusPath(), CdmLogCode.WarnValdnOrdinalStartEndOrder, this.startOrdinal.toString(), this.endOrdinal.toString());
        } else {
            int startingOrdinal = Math.max(0, this.startOrdinal);
            if (this.endOrdinal > projCtx.getProjectionDirective().getResOpt().getMaxOrdinalForArrayExpansion()) {
                Logger.warning(this.getCtx(), TAG, "appendProjectionAttributeState", this.getAtCorpusPath(), CdmLogCode.WarnValdnMaxOrdinalTooHigh, this.endOrdinal.toString(), String.valueOf(projCtx.getProjectionDirective().getResOpt().getMaxOrdinalForArrayExpansion()));
            }
            int endingOrdinal = Math.min(projCtx.getProjectionDirective().getResOpt().getMaxOrdinalForArrayExpansion(), this.endOrdinal);
            for (int i = startingOrdinal; i <= endingOrdinal; ++i) {
                AttributeContextParameters attrCtxRoundParam = new AttributeContextParameters();
                attrCtxRoundParam.setUnder(attrCtxOpArrayExpansion);
                attrCtxRoundParam.setType(CdmAttributeContextType.GeneratedRound);
                attrCtxRoundParam.setName("_generatedAttributeRound" + round);
                CdmAttributeContext attrCtxRound = CdmAttributeContext.createChildUnder(projCtx.getProjectionDirective().getResOpt(), attrCtxRoundParam);
                for (ProjectionAttributeState currentPAS : projCtx.getCurrentAttributeStateSet().getStates()) {
                    AttributeContextParameters attrCtxExpandedAttrParam = new AttributeContextParameters();
                    attrCtxExpandedAttrParam.setUnder(attrCtxRound);
                    attrCtxExpandedAttrParam.setType(CdmAttributeContextType.AttributeDefinition);
                    attrCtxExpandedAttrParam.setName(currentPAS.getCurrentResolvedAttribute().getResolvedName() + "@" + i);
                    CdmAttributeContext attrCtxExpandedAttr = CdmAttributeContext.createChildUnder(projCtx.getProjectionDirective().getResOpt(), attrCtxExpandedAttrParam);
                    if (currentPAS.getCurrentResolvedAttribute().getTarget() instanceof ResolvedAttributeSet) {
                        Logger.error(this.getCtx(), TAG, "appendProjectionAttributeState", this.getAtCorpusPath(), CdmLogCode.ErrProjUnsupportedAttrGroups, new String[0]);
                        projAttrStatesFromRounds.clear();
                        break;
                    }
                    ResolvedAttribute newResAttr = CdmOperationArrayExpansion.createNewResolvedAttribute(projCtx, attrCtxExpandedAttr, currentPAS.getCurrentResolvedAttribute(), currentPAS.getCurrentResolvedAttribute().getResolvedName());
                    ProjectionAttributeState newPAS = new ProjectionAttributeState(projOutputSet.getCtx());
                    newPAS.setCurrentResolvedAttribute(newResAttr);
                    newPAS.setPreviousStateList(new ArrayList<ProjectionAttributeState>(Collections.singletonList(currentPAS)));
                    newPAS.setOrdinal(i);
                    projAttrStatesFromRounds.add(newPAS);
                }
                if (i == endingOrdinal) break;
                ++round;
            }
        }
        if (projAttrStatesFromRounds.size() == 0) {
            for (ProjectionAttributeState pas : projCtx.getCurrentAttributeStateSet().getStates()) {
                projOutputSet.add(pas);
            }
        } else {
            for (ProjectionAttributeState pas : projAttrStatesFromRounds) {
                projOutputSet.add(pas);
            }
        }
        return projOutputSet;
    }
}

