/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.commondatamodel.objectmodel.cdm.projections;

import com.microsoft.commondatamodel.objectmodel.cdm.CdmAttribute;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmAttributeContext;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmCorpusContext;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmObject;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmObjectBase;
import com.microsoft.commondatamodel.objectmodel.cdm.projections.CdmOperationBase;
import com.microsoft.commondatamodel.objectmodel.enums.CdmAttributeContextType;
import com.microsoft.commondatamodel.objectmodel.enums.CdmLogCode;
import com.microsoft.commondatamodel.objectmodel.enums.CdmObjectType;
import com.microsoft.commondatamodel.objectmodel.enums.CdmOperationType;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.ResolvedAttribute;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.projections.ProjectionAttributeContextTreeBuilder;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.projections.ProjectionAttributeState;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.projections.ProjectionAttributeStateSet;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.projections.ProjectionContext;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.projections.ProjectionResolutionCommonUtil;
import com.microsoft.commondatamodel.objectmodel.utilities.AttributeContextParameters;
import com.microsoft.commondatamodel.objectmodel.utilities.CopyOptions;
import com.microsoft.commondatamodel.objectmodel.utilities.ResolveOptions;
import com.microsoft.commondatamodel.objectmodel.utilities.StringUtils;
import com.microsoft.commondatamodel.objectmodel.utilities.VisitCallback;
import com.microsoft.commondatamodel.objectmodel.utilities.logger.Logger;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class CdmOperationRenameAttributes
extends CdmOperationBase {
    private static final String TAG = CdmOperationRenameAttributes.class.getSimpleName();
    private String renameFormat;
    private List<String> applyTo;

    public CdmOperationRenameAttributes(CdmCorpusContext ctx) {
        super(ctx);
        this.setObjectType(CdmObjectType.OperationRenameAttributesDef);
        this.setType(CdmOperationType.RenameAttributes);
    }

    @Override
    public CdmObject copy(ResolveOptions resOpt, CdmObject host) {
        ArrayList<String> applyTo = null;
        if (this.applyTo != null) {
            applyTo = new ArrayList<String>(this.applyTo);
        }
        CdmOperationRenameAttributes copy = new CdmOperationRenameAttributes(this.getCtx());
        copy.renameFormat = this.renameFormat;
        copy.applyTo = applyTo;
        return copy;
    }

    public String getRenameFormat() {
        return this.renameFormat;
    }

    public void setRenameFormat(String renameFormat) {
        this.renameFormat = renameFormat;
    }

    public List<String> getApplyTo() {
        return this.applyTo;
    }

    public void setApplyTo(List<String> applyTo) {
        this.applyTo = applyTo;
    }

    @Override
    @Deprecated
    public Object copyData(ResolveOptions resOpt, CopyOptions options) {
        return CdmObjectBase.copyData(this, resOpt, options, CdmOperationRenameAttributes.class);
    }

    @Override
    public String getName() {
        return "operationRenameAttributes";
    }

    @Override
    @Deprecated
    public CdmObjectType getObjectType() {
        return CdmObjectType.OperationRenameAttributesDef;
    }

    @Override
    public boolean validate() {
        ArrayList<String> missingFields = new ArrayList<String>();
        if (StringUtils.isNullOrTrimEmpty(this.renameFormat)) {
            missingFields.add(this.renameFormat.toString());
        }
        if (missingFields.size() > 0) {
            Logger.error(this.getCtx(), TAG, "validate", this.getAtCorpusPath(), CdmLogCode.ErrValdnIntegrityCheckFailure, this.getAtCorpusPath(), String.join((CharSequence)", ", missingFields.parallelStream().map(s -> String.format("'%s'", s)).collect(Collectors.toList())));
            return false;
        }
        return true;
    }

    @Override
    public boolean visit(String pathFrom, VisitCallback preChildren, VisitCallback postChildren) {
        String path = "";
        if (!this.getCtx().getCorpus().getBlockDeclaredPathChanges() && StringUtils.isNullOrEmpty(path = this.getDeclaredPath())) {
            path = pathFrom + "operationRenameAttributes";
            this.setDeclaredPath(path);
        }
        if (preChildren != null && preChildren.invoke(this, path)) {
            return false;
        }
        return postChildren != null && postChildren.invoke(this, path);
    }

    @Override
    @Deprecated
    public ProjectionAttributeStateSet appendProjectionAttributeState(ProjectionContext projCtx, ProjectionAttributeStateSet projOutputSet, CdmAttributeContext attrCtx) {
        List<String> renameAttributes;
        AttributeContextParameters attrCtxOpRenameAttrsParam = new AttributeContextParameters();
        attrCtxOpRenameAttrsParam.setUnder(attrCtx);
        attrCtxOpRenameAttrsParam.setType(CdmAttributeContextType.OperationRenameAttributes);
        attrCtxOpRenameAttrsParam.setName("operation/index" + this.getIndex() + "/operationRenameAttributes");
        CdmAttributeContext attrCtxOpRenameAttrs = CdmAttributeContext.createChildUnder(projCtx.getProjectionDirective().getResOpt(), attrCtxOpRenameAttrsParam);
        if (this.applyTo != null) {
            renameAttributes = this.applyTo;
        } else {
            renameAttributes = new ArrayList<String>();
            for (ProjectionAttributeState currentPAS : projCtx.getCurrentAttributeStateSet().getStates()) {
                renameAttributes.add(currentPAS.getCurrentResolvedAttribute().getResolvedName());
            }
        }
        Map<String, String> topLevelRenameAttributeNames = ProjectionResolutionCommonUtil.getTopList(projCtx, renameAttributes);
        String sourceAttributeName = projCtx.getProjectionDirective().getOriginalSourceEntityAttributeName();
        ProjectionAttributeContextTreeBuilder attrCtxTreeBuilder = new ProjectionAttributeContextTreeBuilder(attrCtxOpRenameAttrs);
        for (ProjectionAttributeState currentPAS : projCtx.getCurrentAttributeStateSet().getStates()) {
            if (topLevelRenameAttributeNames.containsKey(currentPAS.getCurrentResolvedAttribute().getResolvedName())) {
                if (currentPAS.getCurrentResolvedAttribute().getTarget() instanceof CdmAttribute) {
                    String newAttributeName = this.getNewAttributeName(currentPAS, sourceAttributeName);
                    ResolvedAttribute resAttrNew = CdmOperationRenameAttributes.createNewResolvedAttribute(projCtx, null, currentPAS.getCurrentResolvedAttribute(), newAttributeName, null);
                    String applyToName = topLevelRenameAttributeNames.get(currentPAS.getCurrentResolvedAttribute().getResolvedName());
                    attrCtxTreeBuilder.createAndStoreAttributeContextParameters(applyToName, currentPAS, resAttrNew, CdmAttributeContextType.AttributeDefinition, currentPAS.getCurrentResolvedAttribute().getAttCtx(), null);
                    ProjectionAttributeState newPAS = currentPAS.copy();
                    newPAS.setCurrentResolvedAttribute(resAttrNew);
                    projOutputSet.add(newPAS);
                    continue;
                }
                Logger.warning(this.getCtx(), TAG, "appendProjectionAttributeState", this.getAtCorpusPath(), CdmLogCode.WarnProjRenameAttrNotSupported, new String[0]);
                projOutputSet.add(currentPAS);
                continue;
            }
            projOutputSet.add(currentPAS);
        }
        attrCtxTreeBuilder.constructAttributeContextTree(projCtx);
        return projOutputSet;
    }

    private String getNewAttributeName(ProjectionAttributeState attributeState, String sourceAttributeName) {
        String currentAttributeName = attributeState.getCurrentResolvedAttribute().getResolvedName();
        String ordinal = attributeState.getOrdinal() != null ? attributeState.getOrdinal().toString() : "";
        String format = this.renameFormat;
        if (StringUtils.isNullOrTrimEmpty(format)) {
            Logger.error(this.getCtx(), TAG, "getNewAttributeName", this.getAtCorpusPath(), CdmLogCode.ErrProjRenameFormatIsNotSet, new String[0]);
            return "";
        }
        return CdmOperationRenameAttributes.replaceWildcardCharacters(format, sourceAttributeName, ordinal, currentAttributeName);
    }
}

