/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.commondatamodel.objectmodel.persistence.cdmfolder;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmAttributeItem;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmCollection;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmCorpusContext;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmObject;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmObjectReference;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmTraitReferenceBase;
import com.microsoft.commondatamodel.objectmodel.persistence.cdmfolder.AttributeGroupReferencePersistence;
import com.microsoft.commondatamodel.objectmodel.persistence.cdmfolder.DataTypeReferencePersistence;
import com.microsoft.commondatamodel.objectmodel.persistence.cdmfolder.EntityAttributePersistence;
import com.microsoft.commondatamodel.objectmodel.persistence.cdmfolder.EntityReferencePersistence;
import com.microsoft.commondatamodel.objectmodel.persistence.cdmfolder.PurposeReferencePersistence;
import com.microsoft.commondatamodel.objectmodel.persistence.cdmfolder.TraitGroupReferencePersistence;
import com.microsoft.commondatamodel.objectmodel.persistence.cdmfolder.TraitReferencePersistence;
import com.microsoft.commondatamodel.objectmodel.persistence.cdmfolder.TypeAttributePersistence;
import com.microsoft.commondatamodel.objectmodel.utilities.CopyOptions;
import com.microsoft.commondatamodel.objectmodel.utilities.JMapper;
import com.microsoft.commondatamodel.objectmodel.utilities.ResolveOptions;
import java.util.ArrayList;
import java.util.List;

public class Utils {
    public static Object copyIdentifierRef(CdmObjectReference objRef, ResolveOptions resOpt, CopyOptions options) {
        String identifier = objRef.getNamedReference();
        if (options == null || options.getIsStringRefs() == null || !options.getIsStringRefs().booleanValue()) {
            return identifier;
        }
        Object resolved = objRef.fetchObjectDefinition(resOpt);
        if (resolved == null) {
            return identifier;
        }
        CopyIdentifierRef result = new CopyIdentifierRef();
        result.setAtCorpusPath(resolved.getAtCorpusPath());
        result.setIdentifier(identifier);
        return result;
    }

    public static JsonNode jsonForm(Object instance, ResolveOptions resOpt, CopyOptions options) {
        if (instance == null) {
            return null;
        }
        if (instance instanceof CdmObject) {
            Object dataForm = ((CdmObject)instance).copyData(resOpt, options);
            if (dataForm == null) {
                throw new RuntimeException("serializationError");
            }
            if (dataForm instanceof String) {
                return JMapper.MAP.valueToTree(dataForm);
            }
            return JMapper.MAP.valueToTree(dataForm);
        }
        throw new ClassCastException("Fail to find cast instance, Class Name: " + instance.getClass().getName());
    }

    public static CdmAttributeItem createAttribute(CdmCorpusContext ctx, Object obj) {
        return Utils.createAttribute(ctx, obj, null);
    }

    public static CdmAttributeItem createAttribute(CdmCorpusContext ctx, Object obj, String entityName) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof JsonNode && ((JsonNode)obj).isValueNode()) {
            return AttributeGroupReferencePersistence.fromData(ctx, (JsonNode)obj);
        }
        if (obj instanceof JsonNode) {
            JsonNode jsonObject = (JsonNode)obj;
            if (jsonObject.get("attributeGroupReference") != null) {
                return AttributeGroupReferencePersistence.fromData(ctx, (JsonNode)obj, entityName);
            }
            if (jsonObject.get("entity") != null) {
                return EntityAttributePersistence.fromData(ctx, (JsonNode)obj);
            }
            if (jsonObject.get("name") != null) {
                return TypeAttributePersistence.fromData(ctx, (JsonNode)obj, entityName);
            }
        }
        return null;
    }

    public static Object createConstant(CdmCorpusContext ctx, Object obj) {
        if (obj instanceof JsonNode && ((JsonNode)obj).isNull() || obj == null) {
            return null;
        }
        if (obj instanceof JsonNode && ((JsonNode)obj).isValueNode()) {
            return ((JsonNode)obj).asText();
        }
        if (obj instanceof JsonNode && ((JsonNode)obj).isObject()) {
            JsonNode newObj = (JsonNode)obj;
            if (newObj.has("purpose") || newObj.has("dataType") || newObj.has("entity")) {
                if (newObj.has("dataType")) {
                    return TypeAttributePersistence.fromData(ctx, newObj);
                }
                if (newObj.has("entity")) {
                    return EntityAttributePersistence.fromData(ctx, newObj);
                }
                return null;
            }
            if (newObj.has("purposeReference")) {
                return PurposeReferencePersistence.fromData(ctx, newObj);
            }
            if (newObj.has("traitReference")) {
                return TraitReferencePersistence.fromData(ctx, newObj);
            }
            if (newObj.has("traitGroupReference")) {
                return TraitGroupReferencePersistence.fromData(ctx, newObj);
            }
            if (newObj.has("dataTypeReference")) {
                return DataTypeReferencePersistence.fromData(ctx, newObj);
            }
            if (newObj.has("entityReference")) {
                return EntityReferencePersistence.fromData(ctx, newObj);
            }
            if (newObj.has("attributeGroupReference")) {
                return AttributeGroupReferencePersistence.fromData(ctx, newObj);
            }
            return newObj;
        }
        return obj;
    }

    public static ArrayList<CdmAttributeItem> createAttributeList(CdmCorpusContext ctx, JsonNode obj) {
        return Utils.createAttributeList(ctx, obj, null);
    }

    public static ArrayList<CdmAttributeItem> createAttributeList(CdmCorpusContext ctx, JsonNode obj, String entityName) {
        if (obj == null) {
            return null;
        }
        ArrayList<CdmAttributeItem> result = new ArrayList<CdmAttributeItem>();
        obj.forEach(node -> result.add(Utils.createAttribute(ctx, node, entityName)));
        return result;
    }

    public static ArrayList<CdmTraitReferenceBase> createTraitReferenceList(CdmCorpusContext ctx, Object obj) {
        if (obj == null) {
            return null;
        }
        ArrayList<CdmTraitReferenceBase> result = new ArrayList<CdmTraitReferenceBase>();
        ArrayNode traitRefObj = null;
        if (obj instanceof ObjectNode) {
            ObjectNode objectNode = (ObjectNode)obj;
            if (objectNode.get("value") != null && objectNode.get("value") instanceof ArrayNode) {
                traitRefObj = (ArrayNode)objectNode.get("value");
            }
        } else {
            traitRefObj = (ArrayNode)obj;
        }
        if (traitRefObj != null) {
            for (int i = 0; i < traitRefObj.size(); ++i) {
                JsonNode tr = traitRefObj.get(i);
                if (!tr.isValueNode() && tr.get("traitGroupReference") != null) {
                    result.add(TraitGroupReferencePersistence.fromData(ctx, tr));
                    continue;
                }
                result.add(TraitReferencePersistence.fromData(ctx, tr));
            }
        }
        return result;
    }

    public static <T extends CdmObject> void addListToCdmCollection(CdmCollection<T> cdmCollection, List<T> list) {
        if (cdmCollection != null && list != null) {
            for (CdmObject element : list) {
                cdmCollection.add(element);
            }
        }
    }

    public static <T, U extends CdmObject> ArrayList<T> listCopyDataAsCdmObject(Iterable<U> source, ResolveOptions resOpt, CopyOptions options) {
        if (source == null) {
            return null;
        }
        ArrayList<Object> casted = new ArrayList<Object>();
        for (U element : source) {
            if (!(element instanceof CdmObject)) continue;
            casted.add(((CdmObject)element).copyData(resOpt, options));
        }
        if (casted.size() == 0) {
            return null;
        }
        return casted;
    }

    public static <T> ArrayNode listCopyDataAsArrayNode(Iterable<T> source, ResolveOptions resOpt, CopyOptions options) {
        if (source == null) {
            return null;
        }
        ArrayNode casted = JsonNodeFactory.instance.arrayNode();
        for (T element : source) {
            if (!(element instanceof CdmObject)) continue;
            Object serialized = ((CdmObject)element).copyData(resOpt, options);
            if (serialized instanceof JsonNode) {
                casted.add((JsonNode)serialized);
                continue;
            }
            casted.add(JMapper.MAP.valueToTree(serialized));
        }
        if (casted.size() == 0) {
            return null;
        }
        return casted;
    }

    static String propertyFromDataToString(Object value) {
        String stringValue = Utils.getStringFromJson(value);
        if (stringValue != null && !stringValue.equals("")) {
            return stringValue;
        }
        Integer intValue = Utils.getIntFromJson(value);
        if (intValue != null) {
            return Integer.toString(intValue);
        }
        return null;
    }

    static Integer propertyFromDataToInt(Object value) {
        Integer intValue = Utils.getIntFromJson(value);
        if (intValue != null) {
            return intValue;
        }
        String stringValue = Utils.getStringFromJson(value);
        if (stringValue != null) {
            try {
                return Integer.valueOf(stringValue);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    static Boolean propertyFromDataToBoolean(Object value) {
        if (value == null || value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof BooleanNode) {
            return ((BooleanNode)value).asBoolean();
        }
        String stringValue = Utils.getStringFromJson(value);
        if (stringValue.equals("True") || stringValue.equals("true")) {
            return true;
        }
        if (stringValue.equals("False") || stringValue.equals("false")) {
            return false;
        }
        return null;
    }

    static String getStringFromJson(Object value) {
        if (value instanceof String) {
            return (String)value;
        }
        if (value instanceof TextNode) {
            return ((TextNode)value).asText();
        }
        return null;
    }

    static Integer getIntFromJson(Object value) {
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof IntNode) {
            return ((IntNode)value).intValue();
        }
        return null;
    }

    public static class CopyIdentifierRef {
        @JsonProperty(value="atCorpusPath")
        private String atCorpusPath;
        @JsonProperty(value="identifier")
        private String identifier;

        public String getAtCorpusPath() {
            return this.atCorpusPath;
        }

        public void setAtCorpusPath(String atCorpusPath) {
            this.atCorpusPath = atCorpusPath;
        }

        public String getIdentifier() {
            return this.identifier;
        }

        public void setIdentifier(String identifier) {
            this.identifier = identifier;
        }
    }
}

