/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.commondatamodel.objectmodel.cdm;

import com.microsoft.commondatamodel.objectmodel.cdm.CdmAttributeContext;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmAttributeContextReference;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmAttributeItem;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmCollection;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmCorpusContext;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmObject;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmObjectBase;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmObjectDefinitionBase;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmReferencesEntities;
import com.microsoft.commondatamodel.objectmodel.enums.CdmAttributeContextType;
import com.microsoft.commondatamodel.objectmodel.enums.CdmLogCode;
import com.microsoft.commondatamodel.objectmodel.enums.CdmObjectType;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.ResolvedAttributeSet;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.ResolvedAttributeSetBuilder;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.ResolvedEntityReferenceSet;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.ResolvedTraitSet;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.ResolvedTraitSetBuilder;
import com.microsoft.commondatamodel.objectmodel.utilities.AttributeContextParameters;
import com.microsoft.commondatamodel.objectmodel.utilities.CopyOptions;
import com.microsoft.commondatamodel.objectmodel.utilities.ResolveOptions;
import com.microsoft.commondatamodel.objectmodel.utilities.StringUtils;
import com.microsoft.commondatamodel.objectmodel.utilities.VisitCallback;
import com.microsoft.commondatamodel.objectmodel.utilities.logger.Logger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.stream.Collectors;

public class CdmAttributeGroupDefinition
extends CdmObjectDefinitionBase
implements CdmReferencesEntities {
    private static final String TAG = CdmAttributeGroupDefinition.class.getSimpleName();
    private CdmAttributeContextReference attributeContext;
    private String attributeGroupName;
    private CdmCollection<CdmAttributeItem> members;

    public CdmAttributeGroupDefinition(CdmCorpusContext ctx, String attributeGroupName) {
        super(ctx);
        this.setObjectType(CdmObjectType.AttributeGroupDef);
        this.attributeGroupName = attributeGroupName;
        this.members = new CdmCollection(this.getCtx(), this, CdmObjectType.TypeAttributeDef);
    }

    @Override
    public String getName() {
        return this.attributeGroupName;
    }

    @Override
    public boolean isDerivedFrom(String baseDef, ResolveOptions resOpt) {
        return false;
    }

    @Override
    public boolean visit(String pathFrom, VisitCallback preChildren, VisitCallback postChildren) {
        String path = "";
        if (this.getCtx() != null && this.getCtx().getCorpus() != null && !this.getCtx().getCorpus().blockDeclaredPathChanges && StringUtils.isNullOrTrimEmpty(path = this.getDeclaredPath())) {
            path = pathFrom + this.attributeGroupName;
            this.setDeclaredPath(path);
        }
        if (preChildren != null && preChildren.invoke(this, path)) {
            return false;
        }
        if (this.attributeContext != null) {
            this.attributeContext.setOwner(this);
            if (this.attributeContext.visit(path + "/attributeContext/", preChildren, postChildren)) {
                return true;
            }
        }
        if (this.getMembers() != null && this.members.visitList(path + "/members/", preChildren, postChildren)) {
            return true;
        }
        if (this.visitDef(path, preChildren, postChildren)) {
            return true;
        }
        return postChildren != null && postChildren.invoke(this, path);
    }

    public CdmAttributeContextReference getAttributeContext() {
        return this.attributeContext;
    }

    public void setAttributeContext(CdmAttributeContextReference value) {
        this.attributeContext = value;
    }

    public String getAttributeGroupName() {
        return this.attributeGroupName;
    }

    public void setAttributeGroupName(String value) {
        this.attributeGroupName = value;
    }

    public CdmCollection<CdmAttributeItem> getMembers() {
        return this.members;
    }

    @Override
    public ResolvedEntityReferenceSet fetchResolvedEntityReferences(ResolveOptions resOpt) {
        if (resOpt == null) {
            resOpt = new ResolveOptions(this, this.getCtx().getCorpus().getDefaultResolutionDirectives());
        }
        ResolvedEntityReferenceSet rers = new ResolvedEntityReferenceSet(resOpt);
        if (this.members != null) {
            for (int i = 0; i < this.members.getCount(); ++i) {
                rers.add(this.members.getAllItems().get(i).fetchResolvedEntityReferences(resOpt));
            }
        }
        return rers;
    }

    @Override
    public boolean validate() {
        if (StringUtils.isNullOrTrimEmpty(this.attributeGroupName)) {
            ArrayList<String> missingFields = new ArrayList<String>(Arrays.asList("attributeGroupName"));
            Logger.error(this.getCtx(), TAG, "validate", this.getAtCorpusPath(), CdmLogCode.ErrValdnIntegrityCheckFailure, this.getAtCorpusPath(), String.join((CharSequence)", ", missingFields.parallelStream().map(s -> String.format("'%s'", s)).collect(Collectors.toList())));
            return false;
        }
        return true;
    }

    @Override
    @Deprecated
    public Object copyData(ResolveOptions resOpt, CopyOptions options) {
        return CdmObjectBase.copyData(this, resOpt, options, CdmAttributeGroupDefinition.class);
    }

    @Override
    public CdmObject copy(ResolveOptions resOpt, CdmObject host) {
        CdmAttributeGroupDefinition copy;
        if (resOpt == null) {
            resOpt = new ResolveOptions(this, this.getCtx().getCorpus().getDefaultResolutionDirectives());
        }
        if (host == null) {
            copy = new CdmAttributeGroupDefinition(this.getCtx(), this.getAttributeGroupName());
        } else {
            copy = (CdmAttributeGroupDefinition)host;
            copy.setAttributeGroupName(this.getAttributeGroupName());
            copy.getMembers().clear();
        }
        if (this.getAttributeContext() != null) {
            copy.setAttributeContext((CdmAttributeContextReference)this.getAttributeContext().copy(resOpt));
        }
        for (CdmAttributeItem newMember : this.getMembers()) {
            copy.getMembers().add((CdmAttributeItem)newMember.copy(resOpt));
        }
        this.copyDef(resOpt, copy);
        return copy;
    }

    @Override
    @Deprecated
    public ResolvedAttributeSetBuilder constructResolvedAttributes(ResolveOptions resOpt) {
        return this.constructResolvedAttributes(resOpt, null);
    }

    @Override
    @Deprecated
    public ResolvedAttributeSetBuilder constructResolvedAttributes(ResolveOptions resOpt, CdmAttributeContext under) {
        ResolvedAttributeSetBuilder rasb = new ResolvedAttributeSetBuilder();
        CdmAttributeContext allUnder = under;
        if (under != null) {
            AttributeContextParameters acpAttGrp = new AttributeContextParameters();
            acpAttGrp.setUnder(under);
            acpAttGrp.setType(CdmAttributeContextType.AttributeGroup);
            acpAttGrp.setName(this.getName());
            acpAttGrp.setRegarding(this);
            acpAttGrp.setIncludeTraits(false);
            under = rasb.getResolvedAttributeSet().createAttributeContext(resOpt, acpAttGrp);
        }
        if (this.getMembers() != null) {
            for (int i = 0; i < this.getMembers().getCount(); ++i) {
                CdmAttributeItem att = this.members.get(i);
                AttributeContextParameters acpAtt = null;
                if (under != null) {
                    acpAtt = new AttributeContextParameters();
                    acpAtt.setUnder(under);
                    acpAtt.setType(CdmAttributeContextType.AttributeDefinition);
                    acpAtt.setName(att.fetchObjectDefinitionName());
                    acpAtt.setRegarding(att);
                    acpAtt.setIncludeTraits(false);
                }
                ResolvedAttributeSet rasFromAtt = att.fetchResolvedAttributes(resOpt, acpAtt);
                rasb.getResolvedAttributeSet().markOrphansForRemoval(att.fetchObjectDefinitionName(), rasFromAtt);
                rasb.mergeAttributes(rasFromAtt);
            }
        }
        rasb.getResolvedAttributeSet().setAttributeContext(allUnder);
        rasb.removeRequestedAtts();
        return rasb;
    }

    @Override
    void constructResolvedTraits(ResolvedTraitSetBuilder rtsb, ResolveOptions resOpt) {
        if (this.getMembers() != null) {
            ResolvedTraitSet rtsElevated = new ResolvedTraitSet(resOpt);
            for (int i = 0; i < this.getMembers().getCount(); ++i) {
                CdmAttributeItem att = this.members.getAllItems().get(i);
                ResolvedTraitSet rtsAtt = ((CdmObject)att).fetchResolvedTraits(resOpt);
                if (rtsAtt == null || rtsAtt.getHasElevated() == null || !rtsAtt.getHasElevated().booleanValue()) continue;
                rtsElevated = rtsElevated.mergeSet(rtsAtt, true);
            }
            rtsb.mergeTraits(rtsElevated);
        }
        this.constructResolvedTraitsDef(null, rtsb, resOpt);
    }

    CdmAttributeItem addAttributeDef(CdmAttributeItem attributeDef) {
        this.getMembers().add(attributeDef);
        return attributeDef;
    }
}

