/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.commondatamodel.objectmodel.cdm;

import com.microsoft.commondatamodel.objectmodel.cdm.CdmCollection;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmCorpusContext;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmDataPartitionDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmDataPartitionPatternDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmEntityDeclarationDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmFileStatus;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmObject;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmObjectBase;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmObjectDefinitionBase;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmTraitCollection;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmTraitReferenceBase;
import com.microsoft.commondatamodel.objectmodel.enums.CdmLogCode;
import com.microsoft.commondatamodel.objectmodel.enums.CdmObjectType;
import com.microsoft.commondatamodel.objectmodel.storage.StorageAdapter;
import com.microsoft.commondatamodel.objectmodel.storage.StorageAdapterBase;
import com.microsoft.commondatamodel.objectmodel.utilities.CopyOptions;
import com.microsoft.commondatamodel.objectmodel.utilities.ResolveOptions;
import com.microsoft.commondatamodel.objectmodel.utilities.StringUtils;
import com.microsoft.commondatamodel.objectmodel.utilities.TimeUtils;
import com.microsoft.commondatamodel.objectmodel.utilities.VisitCallback;
import com.microsoft.commondatamodel.objectmodel.utilities.logger.Logger;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;

public class CdmLocalEntityDeclarationDefinition
extends CdmObjectDefinitionBase
implements CdmEntityDeclarationDefinition {
    private static final String TAG = CdmLocalEntityDeclarationDefinition.class.getSimpleName();
    public String entityName;
    public String entityPath;
    public String prefixPath;
    public OffsetDateTime lastFileStatusCheckTime;
    public OffsetDateTime lastFileModifiedTime;
    public OffsetDateTime lastFileModifiedOldTime;
    public OffsetDateTime lastChildFileModifiedTime;
    private CdmCollection<CdmDataPartitionDefinition> dataPartitions;
    private CdmCollection<CdmDataPartitionPatternDefinition> dataPartitionPatterns;

    public CdmLocalEntityDeclarationDefinition(CdmCorpusContext ctx, String entityName) {
        super(ctx);
        this.setObjectType(CdmObjectType.LocalEntityDeclarationDef);
        this.setEntityName(entityName);
        this.dataPartitions = new CdmCollection(this.getCtx(), this, CdmObjectType.DataPartitionDef);
        this.dataPartitionPatterns = new CdmCollection(this.getCtx(), this, CdmObjectType.DataPartitionPatternDef);
        this.lastFileModifiedOldTime = null;
        this.lastFileModifiedTime = null;
    }

    @Override
    public String getName() {
        return this.getEntityName();
    }

    @Override
    public boolean isDerivedFrom(String baseDef, ResolveOptions resOpt) {
        return false;
    }

    @Override
    public boolean visit(String pathFrom, VisitCallback preChildren, VisitCallback postChildren) {
        String path = "";
        if (this.getCtx() != null && this.getCtx().getCorpus() != null && !this.getCtx().getCorpus().blockDeclaredPathChanges && (path = this.getDeclaredPath()) == null) {
            path = pathFrom + this.getEntityName();
            this.setDeclaredPath(path);
        }
        if (preChildren != null && preChildren.invoke(this, path)) {
            return false;
        }
        if (this.dataPartitions != null && this.dataPartitions.visitList(path + "/dataPartitions/", preChildren, postChildren)) {
            return true;
        }
        if (this.dataPartitionPatterns != null && this.dataPartitionPatterns.visitList(path + "/dataPartitionPatterns/", preChildren, postChildren)) {
            return true;
        }
        if (this.visitDef(path, preChildren, postChildren)) {
            return true;
        }
        return postChildren != null && postChildren.invoke(this, path);
    }

    @Override
    public String getEntityPath() {
        return this.entityPath;
    }

    @Override
    public void setEntityPath(String value) {
        this.entityPath = value;
    }

    @Override
    public CdmCollection<CdmDataPartitionDefinition> getDataPartitions() {
        return this.dataPartitions;
    }

    @Override
    public CdmCollection<CdmDataPartitionPatternDefinition> getDataPartitionPatterns() {
        return this.dataPartitionPatterns;
    }

    @Override
    public String getEntityName() {
        return this.entityName;
    }

    @Override
    public void setEntityName(String value) {
        this.entityName = value;
    }

    @Override
    public OffsetDateTime getLastChildFileModifiedTime() {
        return this.lastChildFileModifiedTime;
    }

    @Override
    public void setLastChildFileModifiedTime(OffsetDateTime value) {
        this.lastChildFileModifiedTime = value;
    }

    @Override
    public OffsetDateTime getLastFileStatusCheckTime() {
        return this.lastFileStatusCheckTime;
    }

    @Override
    public void setLastFileStatusCheckTime(OffsetDateTime value) {
        this.lastFileStatusCheckTime = value;
    }

    @Override
    public OffsetDateTime getLastFileModifiedTime() {
        return this.lastFileModifiedTime;
    }

    @Override
    public void setLastFileModifiedTime(OffsetDateTime value) {
        this.setlastFileModifiedOldTime(this.lastFileModifiedTime);
        this.lastFileModifiedTime = value;
    }

    public OffsetDateTime getlastFileModifiedOldTime() {
        return this.lastFileModifiedOldTime;
    }

    private void setlastFileModifiedOldTime(OffsetDateTime value) {
        this.lastFileModifiedOldTime = value;
    }

    @Override
    public CompletableFuture<Void> fileStatusCheckAsync() {
        return CompletableFuture.runAsync(() -> {
            StorageAdapter storageAdapterInterface = this.getCtx().getCorpus().getStorage().fetchAdapter(this.getInDocument().getNamespace());
            StorageAdapterBase.CacheContext cacheContext = null;
            if (storageAdapterInterface instanceof StorageAdapterBase) {
                cacheContext = ((StorageAdapterBase)storageAdapterInterface).createFileQueryCacheContext();
            }
            try {
                String fullPath = this.getCtx().getCorpus().getStorage().createAbsoluteCorpusPath(this.getEntityPath(), this.getInDocument());
                OffsetDateTime modifiedTime = this.getCtx().getCorpus().computeLastModifiedTimeAsync(fullPath, this).join();
                for (CdmDataPartitionPatternDefinition pattern : this.getDataPartitionPatterns()) {
                    pattern.fileStatusCheckAsync().join();
                }
                for (CdmDataPartitionDefinition partition : this.getDataPartitions()) {
                    partition.fileStatusCheckAsync().join();
                }
                this.setLastFileStatusCheckTime(OffsetDateTime.now(ZoneOffset.UTC));
                this.setLastFileModifiedTime(TimeUtils.maxTime(modifiedTime, this.getLastFileModifiedTime()));
                this.reportMostRecentTimeAsync(this.getLastFileModifiedTime()).join();
            }
            finally {
                if (cacheContext != null) {
                    cacheContext.dispose();
                }
            }
        });
    }

    @Override
    public CompletableFuture<Void> reportMostRecentTimeAsync(OffsetDateTime childTime) {
        this.setLastChildFileModifiedTime(childTime);
        OffsetDateTime mostRecentAtThisLevel = TimeUtils.maxTime(childTime, this.getLastFileModifiedTime());
        if (this.getOwner() instanceof CdmFileStatus && mostRecentAtThisLevel != null) {
            return ((CdmFileStatus)this.getOwner()).reportMostRecentTimeAsync(mostRecentAtThisLevel);
        }
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public boolean validate() {
        if (StringUtils.isNullOrTrimEmpty(this.entityName)) {
            ArrayList<String> missingFields = new ArrayList<String>(Arrays.asList("entityName"));
            Logger.error(this.getCtx(), TAG, "validate", this.getAtCorpusPath(), CdmLogCode.ErrValdnIntegrityCheckFailure, this.getAtCorpusPath(), String.join((CharSequence)", ", missingFields.parallelStream().map(s -> String.format("'%s'", s)).collect(Collectors.toList())));
            return false;
        }
        return true;
    }

    @Override
    public Object copyData(ResolveOptions resOpt, CopyOptions options) {
        return CdmObjectBase.copyData(this, resOpt, options, CdmLocalEntityDeclarationDefinition.class);
    }

    @Override
    @Deprecated
    public CdmObject copy(ResolveOptions resOpt, CdmObject host) {
        CdmLocalEntityDeclarationDefinition copy;
        if (resOpt == null) {
            resOpt = new ResolveOptions(this, this.getCtx().getCorpus().getDefaultResolutionDirectives());
        }
        if (host == null) {
            copy = new CdmLocalEntityDeclarationDefinition(this.getCtx(), this.getEntityName());
        } else {
            copy = (CdmLocalEntityDeclarationDefinition)host;
            copy.setCtx(this.getCtx());
            copy.setEntityName(this.getEntityName());
            copy.getDataPartitions().clear();
            copy.getDataPartitionPatterns().clear();
        }
        copy.setEntityPath(this.getEntityPath());
        copy.setLastFileStatusCheckTime(this.getLastFileStatusCheckTime());
        copy.setLastFileModifiedTime(this.getLastFileModifiedTime());
        copy.setLastChildFileModifiedTime(this.getLastChildFileModifiedTime());
        for (CdmDataPartitionDefinition dataPartition : this.getDataPartitions()) {
            copy.getDataPartitions().add((CdmDataPartitionDefinition)dataPartition.copy(resOpt));
        }
        for (CdmDataPartitionPatternDefinition dataPartitionPattern : this.getDataPartitionPatterns()) {
            copy.getDataPartitionPatterns().add((CdmDataPartitionPatternDefinition)dataPartitionPattern.copy(resOpt));
        }
        this.copyDef(resOpt, copy);
        return copy;
    }

    void createDataPartitionFromPattern(String filePath, CdmTraitCollection exhibitsTraits, Map<String, List<String>> args, String schema, OffsetDateTime modifiedTime) {
        Optional<CdmDataPartitionDefinition> existingPartition = this.getDataPartitions().getAllItems().stream().filter(x -> x.getLocation().equals(filePath)).findFirst();
        if (!existingPartition.isPresent()) {
            CdmDataPartitionDefinition newPartition = (CdmDataPartitionDefinition)this.getCtx().getCorpus().makeObject(CdmObjectType.DataPartitionDef);
            newPartition.setLocation(filePath);
            newPartition.setSpecializedSchema(schema);
            newPartition.setLastFileModifiedTime(modifiedTime);
            newPartition.setLastFileStatusCheckTime(OffsetDateTime.now(ZoneOffset.UTC));
            for (CdmTraitReferenceBase cdmTraitReferenceBase : exhibitsTraits) {
                newPartition.getExhibitsTraits().add(cdmTraitReferenceBase);
            }
            for (Map.Entry entry : args.entrySet()) {
                newPartition.getArguments().put((String)entry.getKey(), (List)entry.getValue());
            }
            this.dataPartitions.add(newPartition);
        }
    }

    public void resetLastFileModifiedOldTime() {
        this.setlastFileModifiedOldTime(null);
    }
}

