/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.commondatamodel.objectmodel.cdm;

import com.microsoft.commondatamodel.objectmodel.cdm.CdmArgumentCollection;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmArgumentDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmAttributeContext;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmCorpusContext;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmCorpusDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmObject;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmObjectBase;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmObjectReferenceBase;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmParameterDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmTraitDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmTraitReferenceBase;
import com.microsoft.commondatamodel.objectmodel.enums.CdmObjectType;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.ParameterCollection;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.ResolveContext;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.ResolvedAttributeSetBuilder;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.ResolvedTrait;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.ResolvedTraitSet;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.ResolvedTraitSetBuilder;
import com.microsoft.commondatamodel.objectmodel.utilities.CdmException;
import com.microsoft.commondatamodel.objectmodel.utilities.CopyOptions;
import com.microsoft.commondatamodel.objectmodel.utilities.ResolveOptions;
import com.microsoft.commondatamodel.objectmodel.utilities.StringUtils;
import com.microsoft.commondatamodel.objectmodel.utilities.SymbolSet;
import com.microsoft.commondatamodel.objectmodel.utilities.VisitCallback;
import java.util.LinkedHashMap;
import java.util.Map;

public class CdmTraitReference
extends CdmTraitReferenceBase {
    protected boolean resolvedArguments;
    private final CdmArgumentCollection arguments;
    private boolean fromProperty;

    public CdmTraitReference(CdmCorpusContext ctx, Object trait, boolean simpleReference, boolean hasArguments) {
        super(ctx, trait, simpleReference);
        this.setObjectType(CdmObjectType.TraitRef);
        this.resolvedArguments = false;
        this.fromProperty = false;
        this.arguments = new CdmArgumentCollection(this.getCtx(), this);
    }

    @Override
    @Deprecated
    public boolean visitRef(String pathFrom, VisitCallback preChildren, VisitCallback postChildren) {
        boolean result = false;
        if (this.arguments != null && this.arguments.size() > 0) {
            int lItem = this.arguments.size();
            for (int iItem = 0; iItem < lItem; ++iItem) {
                String argPath;
                CdmArgumentDefinition element = (CdmArgumentDefinition)this.arguments.get(iItem);
                if (element == null || !element.visit(argPath = pathFrom + "/arguments/a" + iItem, preChildren, postChildren)) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    public CdmArgumentCollection getArguments() {
        return this.arguments;
    }

    public boolean isFromProperty() {
        return this.fromProperty;
    }

    public void setFromProperty(boolean value) {
        this.fromProperty = value;
    }

    public Object fetchArgumentValue(String name) {
        if (this.getArguments() == null) {
            return null;
        }
        int lArgSet = this.getArguments().getCount();
        for (int iArgSet = 0; iArgSet < lArgSet; ++iArgSet) {
            CdmArgumentDefinition arg = (CdmArgumentDefinition)this.getArguments().get(iArgSet);
            String argName = arg.getName();
            if (argName != null && argName.equals(name)) {
                return arg.getValue();
            }
            if (argName != null || lArgSet != 1) continue;
            return arg.getValue();
        }
        return null;
    }

    public void updateArgumentValue(String name, Object value) {
        CdmArgumentDefinition arg;
        int iArgSet;
        for (iArgSet = 0; iArgSet < this.getArguments().getCount(); ++iArgSet) {
            arg = (CdmArgumentDefinition)this.arguments.get(iArgSet);
            if (!arg.getName().equals(name)) continue;
            arg.setValue(value);
        }
        if (iArgSet == this.getArguments().getCount()) {
            arg = new CdmArgumentDefinition(this.getCtx(), null);
            arg.setCtx(this.getCtx());
            arg.setName(name);
            arg.setValue(value);
        }
    }

    @Override
    @Deprecated
    public ResolvedTraitSet fetchResolvedTraits(ResolveOptions resOpt) {
        SymbolSet currSymRefSet;
        if (resOpt == null) {
            resOpt = new ResolveOptions(this, this.getCtx().getCorpus().getDefaultResolutionDirectives());
        }
        String kind = "rtsb";
        ResolveContext ctx = (ResolveContext)this.getCtx();
        CdmTraitDefinition trait = (CdmTraitDefinition)this.fetchObjectDefinition(resOpt);
        ResolvedTraitSet rtsTrait = null;
        if (trait == null) {
            return this.createEmptyResolvedTraitSet(ctx.getCorpus(), resOpt);
        }
        if (trait.thisIsKnownToHaveParameters == null) {
            rtsTrait = trait.fetchResolvedTraits(resOpt);
        }
        boolean cacheByPath = trait.thisIsKnownToHaveParameters == null || trait.thisIsKnownToHaveParameters == false;
        String cacheTag = ctx.getCorpus().createDefinitionCacheTag(resOpt, this, "rtsb", "", cacheByPath, trait.getAtCorpusPath());
        Object rtsResult = null;
        if (cacheTag != null) {
            rtsResult = ctx.getCache().get(cacheTag);
        }
        if ((currSymRefSet = resOpt.getSymbolRefSet()) == null) {
            currSymRefSet = new SymbolSet();
        }
        resOpt.setSymbolRefSet(new SymbolSet());
        if (rtsResult == null) {
            if (rtsTrait == null) {
                SymbolSet newSymbolRefSet = resOpt.getSymbolRefSet();
                resOpt.setSymbolRefSet(new SymbolSet());
                rtsTrait = trait.fetchResolvedTraits(resOpt);
                if (newSymbolRefSet != null) {
                    newSymbolRefSet.merge(resOpt.getSymbolRefSet());
                }
                resOpt.setSymbolRefSet(newSymbolRefSet);
            }
            if (rtsTrait != null) {
                rtsResult = rtsTrait.deepCopy();
            }
            if (this.getArguments() != null && rtsResult != null) {
                if (!this.resolvedArguments) {
                    this.resolvedArguments = true;
                    ParameterCollection param = trait.fetchAllParameters(resOpt);
                    int iArg = 0;
                    if (this.getArguments() != null) {
                        for (CdmArgumentDefinition argumentDef : this.getArguments()) {
                            CdmParameterDefinition paramFound;
                            try {
                                paramFound = param.resolveParameter(iArg, argumentDef.getName());
                            }
                            catch (CdmException e) {
                                throw new RuntimeException();
                            }
                            argumentDef.setResolvedParameter(paramFound);
                            Object aValue = argumentDef.getValue();
                            ctx.getCorpus().constTypeCheck(resOpt, this.getInDocument(), paramFound, aValue);
                            argumentDef.setValue(aValue);
                            ++iArg;
                        }
                    }
                }
                if (this.getArguments() != null) {
                    for (CdmArgumentDefinition argumentDef : this.getArguments()) {
                        ((ResolvedTraitSet)rtsResult).setParameterValueFromArgument(trait, argumentDef);
                    }
                }
            }
            ctx.getCorpus().registerDefinitionReferenceSymbols((CdmObject)this.fetchObjectDefinition(resOpt), "rtsb", resOpt.getSymbolRefSet());
            cacheTag = ctx.getCorpus().createDefinitionCacheTag(resOpt, this, "rtsb", "", cacheByPath, trait.getAtCorpusPath());
            if (cacheTag != null && cacheTag.trim().length() > 0) {
                ctx.getCache().put(cacheTag, rtsResult);
            }
        } else {
            String key = CdmCorpusDefinition.createCacheKeyFromObject(this, "rtsb");
            SymbolSet tempDocRefSet = ctx.getCorpus().getDefinitionReferenceSymbols().get(key);
            resOpt.setSymbolRefSet(tempDocRefSet);
        }
        currSymRefSet.merge(resOpt.getSymbolRefSet());
        resOpt.setSymbolRefSet(currSymRefSet);
        return (ResolvedTraitSet)rtsResult;
    }

    @Override
    @Deprecated
    public CdmObjectReferenceBase copyRefObject(ResolveOptions resOpt, Object refTo, boolean simpleReference) {
        return this.copyRefObject(resOpt, refTo, simpleReference, null);
    }

    @Override
    @Deprecated
    public CdmObjectReferenceBase copyRefObject(ResolveOptions resOpt, Object refTo, boolean simpleReference, CdmObjectReferenceBase host) {
        CdmTraitReference copy;
        int argCount;
        int n = argCount = null != this.arguments ? this.arguments.size() : 0;
        if (host == null) {
            copy = new CdmTraitReference(this.getCtx(), refTo, simpleReference, argCount > 0);
        } else {
            copy = (CdmTraitReference)host.copyToHost(this.getCtx(), refTo, simpleReference);
            copy.getArguments().clear();
        }
        if (!simpleReference) {
            copy.resolvedArguments = this.resolvedArguments;
        }
        for (CdmArgumentDefinition arg : this.arguments) {
            copy.getArguments().add((CdmArgumentDefinition)arg.copy(resOpt));
        }
        return copy;
    }

    @Override
    @Deprecated
    public ResolvedAttributeSetBuilder constructResolvedAttributes(ResolveOptions resOpt) {
        return this.constructResolvedAttributes(resOpt, null);
    }

    @Override
    @Deprecated
    public ResolvedAttributeSetBuilder constructResolvedAttributes(ResolveOptions resOpt, CdmAttributeContext under) {
        return null;
    }

    @Override
    void constructResolvedTraits(ResolvedTraitSetBuilder rtsb, ResolveOptions resOpt) {
    }

    @Override
    @Deprecated
    public Object copyData(ResolveOptions resOpt, CopyOptions options) {
        return CdmObjectBase.copyData(this, resOpt, options, CdmTraitReference.class);
    }

    public Map<String, Object> fetchFinalArgumentValues(ResolveOptions resOpt) {
        LinkedHashMap<String, Object> finalArgs = new LinkedHashMap<String, Object>();
        ResolvedTraitSet rts = this.fetchResolvedTraits(resOpt);
        if (rts == null || rts.getSize() != 1) {
            if (this.getArguments() != null && this.getArguments().size() > 0) {
                int unNamedCount = 0;
                for (CdmArgumentDefinition arg : this.getArguments()) {
                    String argName = arg.getName();
                    if (StringUtils.isNullOrTrimEmpty(argName)) {
                        argName = String.valueOf(unNamedCount);
                    }
                    finalArgs.put(argName, arg.getValue());
                    ++unNamedCount;
                }
                return finalArgs;
            }
            return null;
        }
        ResolvedTrait rt = rts.getFirst();
        if (rt != null && rt.getParameterValues() != null && rt.getParameterValues().length() > 0) {
            int l = rt.getParameterValues().length();
            for (int i = 0; i < l; ++i) {
                CdmParameterDefinition p = rt.getParameterValues().fetchParameter(i);
                Object v = rt.getParameterValues().fetchValue(i);
                String name = p.getName();
                if (name == null) {
                    name = Integer.toString(i);
                }
                finalArgs.put(name, v);
            }
        }
        return finalArgs;
    }

    private ResolvedTraitSet createEmptyResolvedTraitSet(CdmCorpusDefinition corpus, ResolveOptions resOpt) {
        ResolvedTraitSet rts;
        String key = "";
        if (resOpt != null) {
            if (resOpt.getWrtDoc() != null) {
                key = Integer.toString(resOpt.getWrtDoc().getId());
            }
            key = key + "-";
            if (resOpt.getDirectives() != null) {
                key = key + resOpt.getDirectives().getTag();
            }
        }
        if ((rts = corpus.getEmptyRts().get(key)) == null) {
            rts = new ResolvedTraitSet(resOpt);
            corpus.getEmptyRts().put(key, rts);
        }
        return rts;
    }

    @Deprecated
    public boolean isResolvedArguments() {
        return this.resolvedArguments;
    }

    @Deprecated
    public void setResolvedArguments(boolean resolvedArguments) {
        this.resolvedArguments = resolvedArguments;
    }
}

