/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.commondatamodel.objectmodel.cdm;

import com.microsoft.commondatamodel.objectmodel.cdm.CdmDocumentDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmFolderDefinition;
import com.microsoft.commondatamodel.objectmodel.utilities.concurrent.ConcurrentSemaphore;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

@Deprecated
public class DocumentLibrary {
    List<Pair<CdmFolderDefinition, CdmDocumentDefinition>> allDocuments = new ArrayList<Pair<CdmFolderDefinition, CdmDocumentDefinition>>();
    Map<String, Pair<CdmFolderDefinition, CdmDocumentDefinition>> pathLookup = new LinkedHashMap<String, Pair<CdmFolderDefinition, CdmDocumentDefinition>>();
    Map<String, Short> docsCurrentlyLoading = new LinkedHashMap<String, Short>();
    Map<CdmDocumentDefinition, Short> docsNotIndexed;
    Map<String, Short> docsNotFound = new LinkedHashMap<String, Short>();
    Lock documentLibraryLock;
    public ConcurrentSemaphore concurrentReadLock;

    DocumentLibrary() {
        this.docsNotIndexed = new LinkedHashMap<CdmDocumentDefinition, Short>();
        this.documentLibraryLock = new ReentrantLock();
        this.concurrentReadLock = new ConcurrentSemaphore();
    }

    void addDocumentPath(String path, CdmFolderDefinition folder, CdmDocumentDefinition doc) {
        this.documentLibraryLock.lock();
        if (!this.pathLookup.containsKey(path)) {
            this.allDocuments.add((Pair<CdmFolderDefinition, CdmDocumentDefinition>)new ImmutablePair((Object)folder, (Object)doc));
            this.pathLookup.put(path, (Pair<CdmFolderDefinition, CdmDocumentDefinition>)new ImmutablePair((Object)folder, (Object)doc));
            folder.getDocumentLookup().put(doc.getName(), doc);
        }
        this.documentLibraryLock.unlock();
    }

    void removeDocumentPath(String path, CdmFolderDefinition folder, CdmDocumentDefinition doc) {
        this.documentLibraryLock.lock();
        if (this.pathLookup.containsKey(path)) {
            this.pathLookup.remove(path);
            int index = this.allDocuments.indexOf(ImmutablePair.of((Object)folder, (Object)doc));
            this.allDocuments.remove(index);
        }
        this.documentLibraryLock.unlock();
    }

    List<CdmDocumentDefinition> listDocsNotIndexed() {
        this.documentLibraryLock.lock();
        ArrayList<CdmDocumentDefinition> list = new ArrayList<CdmDocumentDefinition>();
        for (Map.Entry<CdmDocumentDefinition, Short> entry : this.docsNotIndexed.entrySet()) {
            CdmDocumentDefinition doc = entry.getKey();
            doc.setCurrentlyIndexing(true);
            list.add(doc);
        }
        this.documentLibraryLock.unlock();
        return list;
    }

    @Deprecated
    public List<CdmDocumentDefinition> listAllDocuments() {
        this.documentLibraryLock.lock();
        ArrayList<CdmDocumentDefinition> list = new ArrayList<CdmDocumentDefinition>();
        for (Pair<CdmFolderDefinition, CdmDocumentDefinition> pair : this.allDocuments) {
            list.add((CdmDocumentDefinition)pair.getRight());
        }
        this.documentLibraryLock.unlock();
        return list;
    }

    CdmDocumentDefinition fetchDocument(String path) {
        Pair<CdmFolderDefinition, CdmDocumentDefinition> lookup;
        this.documentLibraryLock.lock();
        CdmDocumentDefinition doc = null;
        if (!this.docsNotFound.containsKey(path) && (lookup = this.pathLookup.get(path)) != null) {
            doc = (CdmDocumentDefinition)lookup.getRight();
        }
        this.documentLibraryLock.unlock();
        return doc;
    }

    boolean needToLoadDocument(String docPath) {
        boolean needToLoad;
        this.documentLibraryLock.lock();
        CdmDocumentDefinition document = this.pathLookup.containsKey(docPath) ? (CdmDocumentDefinition)this.pathLookup.get(docPath).getValue() : null;
        boolean bl = needToLoad = !this.docsNotFound.containsKey(docPath) && !this.docsCurrentlyLoading.containsKey(docPath) && (document == null || !document.isImportsIndexed() && !document.isCurrentlyIndexing());
        if (needToLoad) {
            this.docsCurrentlyLoading.put(docPath, (short)1);
        }
        this.documentLibraryLock.unlock();
        return needToLoad;
    }

    boolean markDocumentAsLoadedOrFailed(String docPath, CdmDocumentDefinition doc) {
        this.documentLibraryLock.lock();
        boolean hasLoaded = false;
        this.docsCurrentlyLoading.remove(docPath);
        if (doc != null) {
            this.docsNotIndexed.put(doc, (short)1);
            doc.setCurrentlyIndexing(true);
            hasLoaded = true;
        } else {
            this.docsNotFound.put(docPath, (short)1);
        }
        this.documentLibraryLock.unlock();
        return hasLoaded;
    }

    void markDocumentAsIndexed(CdmDocumentDefinition doc) {
        this.documentLibraryLock.lock();
        this.docsNotIndexed.remove(doc);
        this.documentLibraryLock.unlock();
    }

    void markDocumentForIndexing(CdmDocumentDefinition doc) {
        this.documentLibraryLock.lock();
        this.docsNotIndexed.put(doc, (short)1);
        this.documentLibraryLock.unlock();
    }

    @Deprecated
    public boolean contains(Pair<CdmFolderDefinition, CdmDocumentDefinition> fd) {
        return this.allDocuments.contains(fd);
    }
}

