/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.commondatamodel.objectmodel.cdm.projections;

import com.microsoft.commondatamodel.objectmodel.cdm.CdmAttribute;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmAttributeContext;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmCorpusContext;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmObject;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmObjectBase;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmTraitReferenceBase;
import com.microsoft.commondatamodel.objectmodel.cdm.projections.CdmOperationBase;
import com.microsoft.commondatamodel.objectmodel.enums.CdmAttributeContextType;
import com.microsoft.commondatamodel.objectmodel.enums.CdmLogCode;
import com.microsoft.commondatamodel.objectmodel.enums.CdmObjectType;
import com.microsoft.commondatamodel.objectmodel.enums.CdmOperationType;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.ParameterValueSet;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.ResolvedAttribute;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.ResolvedAttributeSet;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.ResolvedTrait;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.ResolvedTraitSet;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.projections.ProjectionAttributeState;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.projections.ProjectionAttributeStateSet;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.projections.ProjectionContext;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.projections.ProjectionResolutionCommonUtil;
import com.microsoft.commondatamodel.objectmodel.utilities.AttributeContextParameters;
import com.microsoft.commondatamodel.objectmodel.utilities.CopyOptions;
import com.microsoft.commondatamodel.objectmodel.utilities.ResolveOptions;
import com.microsoft.commondatamodel.objectmodel.utilities.StringUtils;
import com.microsoft.commondatamodel.objectmodel.utilities.VisitCallback;
import com.microsoft.commondatamodel.objectmodel.utilities.logger.Logger;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class CdmOperationAlterTraits
extends CdmOperationBase {
    private static final String TAG = CdmOperationAlterTraits.class.getSimpleName();
    private List<CdmTraitReferenceBase> traitsToAdd;
    private List<CdmTraitReferenceBase> traitsToRemove;
    private Boolean argumentsContainWildcards;
    private List<String> applyTo;

    public CdmOperationAlterTraits(CdmCorpusContext ctx) {
        super(ctx);
        this.setObjectType(CdmObjectType.OperationAlterTraitsDef);
        this.setType(CdmOperationType.AlterTraits);
    }

    public List<CdmTraitReferenceBase> getTraitsToAdd() {
        return this.traitsToAdd;
    }

    public void setTraitsToAdd(List<CdmTraitReferenceBase> traitsToAdd) {
        this.traitsToAdd = traitsToAdd;
    }

    public List<CdmTraitReferenceBase> getTraitsToRemove() {
        return this.traitsToRemove;
    }

    public void setTraitsToRemove(List<CdmTraitReferenceBase> traitsToRemove) {
        this.traitsToRemove = traitsToRemove;
    }

    public Boolean getArgumentsContainWildcards() {
        return this.argumentsContainWildcards;
    }

    public void setArgumentsContainWildcards(Boolean argumentsContainWildcards) {
        this.argumentsContainWildcards = argumentsContainWildcards;
    }

    public List<String> getApplyTo() {
        return this.applyTo;
    }

    public void setApplyTo(List<String> applyTo) {
        this.applyTo = applyTo;
    }

    @Override
    public CdmObject copy(ResolveOptions resOpt, CdmObject host) {
        if (resOpt == null) {
            resOpt = new ResolveOptions(this, this.getCtx().getCorpus().getDefaultResolutionDirectives());
        }
        CdmOperationAlterTraits copy = host == null ? new CdmOperationAlterTraits(this.getCtx()) : (CdmOperationAlterTraits)host;
        ArrayList<CdmTraitReferenceBase> traitsToAdd = null;
        if (this.traitsToAdd != null) {
            traitsToAdd = new ArrayList<CdmTraitReferenceBase>(this.traitsToAdd);
        }
        ArrayList<CdmTraitReferenceBase> traitsToRemove = null;
        if (this.traitsToRemove != null) {
            traitsToRemove = new ArrayList<CdmTraitReferenceBase>(this.traitsToRemove);
        }
        if (this.applyTo != null) {
            copy.setApplyTo(new ArrayList<String>(this.applyTo));
        }
        copy.traitsToAdd = traitsToAdd;
        copy.traitsToRemove = traitsToRemove;
        copy.argumentsContainWildcards = this.argumentsContainWildcards;
        this.copyProj(resOpt, copy);
        return copy;
    }

    @Override
    @Deprecated
    public Object copyData(ResolveOptions resOpt, CopyOptions options) {
        return CdmObjectBase.copyData(this, resOpt, options, CdmOperationAlterTraits.class);
    }

    @Override
    public String getName() {
        return "operationAlterTraits";
    }

    @Override
    @Deprecated
    public CdmObjectType getObjectType() {
        return CdmObjectType.OperationAlterTraitsDef;
    }

    @Override
    public boolean validate() {
        ArrayList<String> missingFields = new ArrayList<String>();
        if (this.traitsToAdd == null && this.traitsToRemove == null) {
            missingFields.add("traitsToAdd");
            missingFields.add("traitsToRemove");
        }
        if (missingFields.size() > 0) {
            Logger.error(this.getCtx(), TAG, "validate", this.getAtCorpusPath(), CdmLogCode.ErrValdnIntegrityCheckFailure, this.getAtCorpusPath(), String.join((CharSequence)", ", missingFields.parallelStream().map(s -> String.format("'%s'", s)).collect(Collectors.toList())));
            return false;
        }
        return true;
    }

    @Override
    public boolean visit(String pathFrom, VisitCallback preChildren, VisitCallback postChildren) {
        String path = "";
        if (!this.getCtx().getCorpus().getBlockDeclaredPathChanges() && StringUtils.isNullOrEmpty(path = this.getDeclaredPath())) {
            path = pathFrom + this.getName();
            this.setDeclaredPath(path);
        }
        if (preChildren != null && preChildren.invoke(this, path)) {
            return false;
        }
        return postChildren != null && postChildren.invoke(this, path);
    }

    @Override
    @Deprecated
    public ProjectionAttributeStateSet appendProjectionAttributeState(ProjectionContext projCtx, ProjectionAttributeStateSet projOutputSet, CdmAttributeContext attrCtx) {
        AttributeContextParameters attrCtxOpAlterTraitsParam = new AttributeContextParameters();
        attrCtxOpAlterTraitsParam.setUnder(attrCtx);
        attrCtxOpAlterTraitsParam.setType(CdmAttributeContextType.OperationAlterTraits);
        attrCtxOpAlterTraitsParam.setName("operation/index" + this.getIndex() + "/" + this.getName());
        CdmAttributeContext attrCtxOpAlterTraits = CdmAttributeContext.createChildUnder(projCtx.getProjectionDirective().getResOpt(), attrCtxOpAlterTraitsParam);
        Map<String, String> topLevelSelectedAttributeNames = this.applyTo != null ? ProjectionResolutionCommonUtil.getTopList(projCtx, this.applyTo) : null;
        for (ProjectionAttributeState currentPAS : projCtx.getCurrentAttributeStateSet().getStates()) {
            if (topLevelSelectedAttributeNames == null || topLevelSelectedAttributeNames.containsKey(currentPAS.getCurrentResolvedAttribute().getResolvedName())) {
                AttributeContextParameters attrCtxNewAttrParam = new AttributeContextParameters();
                attrCtxNewAttrParam.setUnder(attrCtxOpAlterTraits);
                attrCtxNewAttrParam.setType(CdmAttributeContextType.AttributeDefinition);
                attrCtxNewAttrParam.setName(currentPAS.getCurrentResolvedAttribute().getResolvedName());
                CdmAttributeContext attrCtxNewAttr = CdmAttributeContext.createChildUnder(projCtx.getProjectionDirective().getResOpt(), attrCtxNewAttrParam);
                ResolvedAttribute newResAttr = null;
                if (currentPAS.getCurrentResolvedAttribute().getTarget() instanceof ResolvedAttributeSet) {
                    ResolvedAttributeSet resAttrNewCopy = ((ResolvedAttributeSet)currentPAS.getCurrentResolvedAttribute().getTarget()).copy();
                    newResAttr = new ResolvedAttribute(projCtx.getProjectionDirective().getResOpt(), resAttrNewCopy, currentPAS.getCurrentResolvedAttribute().getResolvedName(), attrCtxNewAttr);
                    newResAttr.setResolvedTraits(currentPAS.getCurrentResolvedAttribute().getResolvedTraits().deepCopy());
                } else if (currentPAS.getCurrentResolvedAttribute().getTarget() instanceof CdmAttribute) {
                    newResAttr = CdmOperationAlterTraits.createNewResolvedAttribute(projCtx, attrCtxNewAttr, currentPAS.getCurrentResolvedAttribute(), currentPAS.getCurrentResolvedAttribute().getResolvedName(), null);
                } else {
                    Logger.error(this.getCtx(), TAG, "appendProjectionAttributeState", this.getAtCorpusPath(), CdmLogCode.ErrProjUnsupportedSource, ((CdmObject)currentPAS.getCurrentResolvedAttribute().getTarget()).getObjectType().toString(), this.getName());
                    projOutputSet.add(currentPAS);
                    break;
                }
                newResAttr.setResolvedTraits(newResAttr.getResolvedTraits().mergeSet(this.resolvedNewTraits(projCtx, currentPAS)));
                this.removeTraitsInNewAttribute(projCtx.getProjectionDirective().getResOpt(), newResAttr);
                ProjectionAttributeState newPAS = currentPAS.copy();
                newPAS.setCurrentResolvedAttribute(newResAttr);
                projOutputSet.add(newPAS);
                continue;
            }
            projOutputSet.add(currentPAS);
        }
        return projOutputSet;
    }

    private ResolvedTraitSet resolvedNewTraits(ProjectionContext projCtx, ProjectionAttributeState currentPAS) {
        ResolvedTraitSet resolvedTraitSet = new ResolvedTraitSet(projCtx.getProjectionDirective().getResOpt());
        String baseAttributeName = projCtx.getProjectionDirective().getOriginalSourceEntityAttributeName() != null ? projCtx.getProjectionDirective().getOriginalSourceEntityAttributeName() : (projCtx.getProjectionDirective().getOwner().getName() != null ? projCtx.getProjectionDirective().getOwner().getName() : "");
        String ordinal = currentPAS.getOrdinal() != null ? currentPAS.getOrdinal().toString() : "";
        String currentAttributeName = currentPAS.getCurrentResolvedAttribute().getTarget() instanceof CdmAttribute ? ((CdmAttribute)currentPAS.getCurrentResolvedAttribute().getTarget()).getName() : "";
        for (CdmTraitReferenceBase traitRef : this.traitsToAdd) {
            ResolvedTraitSet traitRefCopy = traitRef.fetchResolvedTraits(projCtx.getProjectionDirective().getResOpt()).deepCopy();
            this.replaceWildcardCharacters(projCtx.getProjectionDirective().getResOpt(), traitRefCopy, baseAttributeName, ordinal, currentAttributeName);
            resolvedTraitSet = resolvedTraitSet.mergeSet(traitRefCopy);
        }
        return resolvedTraitSet;
    }

    private void replaceWildcardCharacters(ResolveOptions resOpt, ResolvedTraitSet resolvedTraitSet, String baseAttributeName, String ordinal, String currentAttributeName) {
        if (this.argumentsContainWildcards != null && this.argumentsContainWildcards.booleanValue()) {
            for (ResolvedTrait resolvedTrait : resolvedTraitSet.getSet()) {
                ParameterValueSet parameterValueSet = resolvedTrait.getParameterValues();
                for (int i = 0; i < parameterValueSet.length(); ++i) {
                    String newVal;
                    Object value = parameterValueSet.fetchValue(i);
                    if (!(value instanceof String) || value.equals(newVal = CdmOperationAlterTraits.replaceWildcardCharacters((String)value, baseAttributeName, ordinal, currentAttributeName))) continue;
                    parameterValueSet.setParameterValue(resOpt, parameterValueSet.fetchParameter(i).getName(), newVal);
                }
            }
        }
    }

    private void removeTraitsInNewAttribute(ResolveOptions resOpt, ResolvedAttribute newResAttr) {
        HashSet<String> traitNamesToRemove = new HashSet<String>();
        if (this.traitsToRemove != null) {
            for (CdmTraitReferenceBase traitRef : this.traitsToRemove) {
                ResolvedTraitSet resolvedTraitSet = traitRef.fetchResolvedTraits(resOpt).deepCopy();
                for (ResolvedTrait rt : resolvedTraitSet.getSet()) {
                    traitNamesToRemove.add(rt.getTraitName());
                }
            }
            for (String traitName : traitNamesToRemove) {
                newResAttr.getResolvedTraits().remove(resOpt, traitName);
            }
        }
    }
}

