/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.commondatamodel.objectmodel.cdm.projections;

import com.microsoft.commondatamodel.objectmodel.cdm.CdmAttributeContext;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmCorpusContext;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmEntityReference;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmObject;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmObjectBase;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmObjectDefinitionBase;
import com.microsoft.commondatamodel.objectmodel.cdm.projections.CdmOperationBase;
import com.microsoft.commondatamodel.objectmodel.cdm.projections.CdmOperationCollection;
import com.microsoft.commondatamodel.objectmodel.enums.CdmAttributeContextType;
import com.microsoft.commondatamodel.objectmodel.enums.CdmLogCode;
import com.microsoft.commondatamodel.objectmodel.enums.CdmObjectType;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.ResolvedAttributeSet;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.ResolvedTraitSet;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.expressionparser.ExpressionTree;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.expressionparser.InputValues;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.projections.ProjectionAttributeState;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.projections.ProjectionAttributeStateSet;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.projections.ProjectionContext;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.projections.ProjectionDirective;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.projections.ProjectionResolutionCommonUtil;
import com.microsoft.commondatamodel.objectmodel.utilities.AttributeContextParameters;
import com.microsoft.commondatamodel.objectmodel.utilities.CopyOptions;
import com.microsoft.commondatamodel.objectmodel.utilities.ResolveOptions;
import com.microsoft.commondatamodel.objectmodel.utilities.StringUtils;
import com.microsoft.commondatamodel.objectmodel.utilities.VisitCallback;
import com.microsoft.commondatamodel.objectmodel.utilities.logger.Logger;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class CdmProjection
extends CdmObjectDefinitionBase {
    private static final String TAG = CdmProjection.class.getSimpleName();
    private String condition;
    private CdmOperationCollection operations;
    private CdmEntityReference source;
    private Boolean runSequentially;

    public CdmProjection(CdmCorpusContext ctx) {
        super(ctx);
        this.setObjectType(CdmObjectType.ProjectionDef);
        this.operations = new CdmOperationCollection(ctx, this);
    }

    public String getCondition() {
        return this.condition;
    }

    public void setCondition(String condition) {
        this.condition = condition;
    }

    public Boolean getRunSequentially() {
        return this.runSequentially;
    }

    public void setRunSequentially(Boolean runSequentially) {
        this.runSequentially = runSequentially;
    }

    public CdmOperationCollection getOperations() {
        return this.operations;
    }

    public CdmEntityReference getSource() {
        return this.source;
    }

    public void setSource(CdmEntityReference source) {
        if (source != null) {
            source.setOwner(this);
        }
        this.source = source;
    }

    @Override
    public CdmObject copy(ResolveOptions resOpt, CdmObject host) {
        CdmProjection copy;
        if (host == null) {
            copy = new CdmProjection(this.getCtx());
        } else {
            copy = (CdmProjection)host;
            copy.setCtx(this.getCtx());
            copy.operations.clear();
        }
        copy.setCondition(this.getCondition());
        copy.setSource(this.getSource() != null ? (CdmEntityReference)this.getSource().copy() : null);
        for (CdmOperationBase operation : this.getOperations()) {
            copy.getOperations().add((CdmOperationBase)operation.copy());
        }
        copy.setInDocument(this.getInDocument());
        return copy;
    }

    @Override
    @Deprecated
    public Object copyData(ResolveOptions resOpt, CopyOptions options) {
        return CdmObjectBase.copyData(this, resOpt, options, CdmProjection.class);
    }

    @Override
    public String getName() {
        return "projection";
    }

    @Override
    @Deprecated
    public CdmObjectType getObjectType() {
        return CdmObjectType.ProjectionDef;
    }

    @Override
    public boolean isDerivedFrom(String baseDef, ResolveOptions resOpt) {
        return false;
    }

    @Override
    public boolean validate() {
        CdmObject rootOwner;
        ArrayList<String> missingFields = new ArrayList<String>();
        if (this.source == null) {
            CdmObject rootOwner2 = this.getRootOwner();
            if (rootOwner2.getObjectType() != CdmObjectType.TypeAttributeDef) {
                missingFields.add("source");
            }
        } else if ((this.source.getExplicitReference() == null || this.source.getExplicitReference().getObjectType() != CdmObjectType.ProjectionDef) && (rootOwner = this.getRootOwner()).getObjectType() == CdmObjectType.TypeAttributeDef) {
            Logger.error(this.getCtx(), TAG, "validate", this.getAtCorpusPath(), CdmLogCode.ErrProjSourceError, new String[0]);
        }
        if (missingFields.size() > 0) {
            Logger.error(this.getCtx(), TAG, "validate", this.getAtCorpusPath(), CdmLogCode.ErrValdnIntegrityCheckFailure, this.getAtCorpusPath(), String.join((CharSequence)", ", missingFields.parallelStream().map(s -> String.format("'%s'", s)).collect(Collectors.toList())));
            return false;
        }
        return true;
    }

    @Override
    public boolean visit(String pathFrom, VisitCallback preChildren, VisitCallback postChildren) {
        String path = "";
        if (!this.getCtx().getCorpus().getBlockDeclaredPathChanges() && StringUtils.isNullOrTrimEmpty(path = this.getDeclaredPath())) {
            path = pathFrom + "projection";
            this.setDeclaredPath(path);
        }
        if (preChildren != null && preChildren.invoke(this, path)) {
            return false;
        }
        if (this.source != null && this.source.visit(path + "/source/", preChildren, postChildren)) {
            return true;
        }
        boolean result = false;
        if (this.operations != null && this.operations.size() > 0) {
            for (int opIndex = 0; opIndex < this.operations.size(); ++opIndex) {
                ((CdmOperationBase)this.operations.get(opIndex)).setIndex(opIndex + 1);
                result = this.operations.getAllItems().get(opIndex) != null && ((CdmOperationBase)this.operations.getAllItems().get(opIndex)).visit(path + "/operation/index" + (opIndex + 1) + "/", preChildren, postChildren);
            }
            if (result) {
                return true;
            }
        }
        return postChildren != null && postChildren.invoke(this, path);
    }

    @Override
    @Deprecated
    public ResolvedTraitSet fetchResolvedTraits() {
        return this.source.fetchResolvedTraits(null);
    }

    @Override
    @Deprecated
    public ResolvedTraitSet fetchResolvedTraits(ResolveOptions resOpt) {
        return this.source.fetchResolvedTraits(resOpt);
    }

    @Deprecated
    public ProjectionContext constructProjectionContext(ProjectionDirective projDirective, CdmAttributeContext attrCtx) {
        return this.constructProjectionContext(projDirective, attrCtx, null);
    }

    @Deprecated
    public ProjectionContext constructProjectionContext(ProjectionDirective projDirective, CdmAttributeContext attrCtx, ResolvedAttributeSet ras) {
        CdmCorpusContext ctx;
        if (attrCtx == null) {
            return null;
        }
        ProjectionContext projContext = null;
        AttributeContextParameters acpProj = new AttributeContextParameters();
        acpProj.setUnder(attrCtx);
        acpProj.setType(CdmAttributeContextType.Projection);
        acpProj.setName(this.fetchObjectDefinitionName());
        acpProj.setRegarding(projDirective.getOwnerRef());
        acpProj.setIncludeTraits(false);
        CdmAttributeContext acProj = CdmAttributeContext.createChildUnder(projDirective.getResOpt(), acpProj);
        AttributeContextParameters acpSource = new AttributeContextParameters();
        acpSource.setUnder(acProj);
        acpSource.setType(CdmAttributeContextType.Source);
        acpSource.setName("source");
        acpSource.setRegarding(null);
        acpSource.setIncludeTraits(false);
        CdmAttributeContext acSource = CdmAttributeContext.createChildUnder(projDirective.getResOpt(), acpSource);
        CdmCorpusContext cdmCorpusContext = ctx = projDirective.getOwner() != null ? projDirective.getOwner().getCtx() : null;
        if (this.source != null) {
            Object source = this.source.fetchObjectDefinition(projDirective.getResOpt());
            if (source.getObjectType() == CdmObjectType.ProjectionDef) {
                projContext = ((CdmProjection)this.source.getExplicitReference()).constructProjectionContext(projDirective, acSource, ras);
            } else {
                AttributeContextParameters acpSourceProjection = new AttributeContextParameters();
                acpSourceProjection.setUnder(acSource);
                acpSourceProjection.setType(CdmAttributeContextType.Entity);
                acpSourceProjection.setName(this.source.getNamedReference() != null ? this.source.getNamedReference() : this.source.getExplicitReference().getName());
                acpSourceProjection.setRegarding(this.source);
                acpSourceProjection.setIncludeTraits(false);
                ras = this.source.fetchResolvedAttributes(projDirective.getResOpt(), acpSourceProjection);
                ras.getAttributeContext().finalizeAttributeContext(projDirective.getResOpt(), acSource.getAtCorpusPath(), this.getInDocument(), this.getInDocument(), null, false);
                Map<String, List<ProjectionAttributeState>> polySourceSet = null;
                if (projDirective.getIsSourcePolymorphic()) {
                    polySourceSet = ProjectionResolutionCommonUtil.getPolymorphicSourceSet(projDirective, ctx, this.source, ras);
                }
                ProjectionAttributeStateSet pasSet = ProjectionResolutionCommonUtil.initializeProjectionAttributeStateSet(projDirective, ctx, ras, projDirective.getIsSourcePolymorphic(), polySourceSet);
                projContext = new ProjectionContext(projDirective, ras.getAttributeContext());
                projContext.setCurrentAttributeStateSet(pasSet);
            }
        } else {
            ProjectionAttributeStateSet pasSet = ProjectionResolutionCommonUtil.initializeProjectionAttributeStateSet(projDirective, ctx, ras, false, null);
            projContext = new ProjectionContext(projDirective, ras.getAttributeContext());
            projContext.setCurrentAttributeStateSet(pasSet);
        }
        InputValues inputValues = new InputValues(projDirective);
        boolean isConditionValid = ExpressionTree.evaluateCondition(this.condition, inputValues);
        if (isConditionValid && this.operations != null && this.operations.size() > 0) {
            for (int i = 0; i < this.operations.size(); ++i) {
                ((CdmOperationBase)this.operations.get(i)).setIndex(i + 1);
            }
            AttributeContextParameters acpGenAttrSet = new AttributeContextParameters();
            acpGenAttrSet.setUnder(attrCtx);
            acpGenAttrSet.setType(CdmAttributeContextType.GeneratedSet);
            acpGenAttrSet.setName("_generatedAttributeSet");
            CdmAttributeContext acGenAttrSet = CdmAttributeContext.createChildUnder(projDirective.getResOpt(), acpGenAttrSet);
            ProjectionAttributeStateSet pasOperations = new ProjectionAttributeStateSet(projContext.getCurrentAttributeStateSet().getCtx());
            ProjectionAttributeStateSet sourceAttributeSet = projContext.getCurrentAttributeStateSet();
            boolean firstOperationToRun = true;
            for (CdmOperationBase operation : this.operations) {
                ProjectionAttributeStateSet newPasOperations;
                ProjectionAttributeStateSet operationWorkingAttributeSet;
                boolean sourceInput;
                boolean operationCondition = ExpressionTree.evaluateCondition(operation.getCondition(), inputValues);
                if (!operationCondition) continue;
                boolean bl = operation.getSourceInput() != null ? operation.getSourceInput() : (sourceInput = this.getRunSequentially() == null || this.getRunSequentially() == false);
                if (sourceInput || firstOperationToRun) {
                    projContext.setCurrentAttributeStateSet(sourceAttributeSet);
                    operationWorkingAttributeSet = pasOperations;
                } else {
                    projContext.setCurrentAttributeStateSet(pasOperations.copy());
                    operationWorkingAttributeSet = new ProjectionAttributeStateSet(projContext.getCurrentAttributeStateSet().getCtx());
                }
                if ((newPasOperations = operation.appendProjectionAttributeState(projContext, operationWorkingAttributeSet, acGenAttrSet)) == null) continue;
                firstOperationToRun = false;
                pasOperations = newPasOperations;
            }
            if (!firstOperationToRun) {
                projContext.setCurrentAttributeStateSet(pasOperations);
            }
        }
        return projContext;
    }

    @Deprecated
    public ResolvedAttributeSet extractResolvedAttributes(ProjectionContext projCtx, CdmAttributeContext attCtxUnder) {
        ResolvedAttributeSet resolvedAttributeSet = new ResolvedAttributeSet();
        resolvedAttributeSet.setAttributeContext(attCtxUnder);
        if (projCtx == null) {
            Logger.error(this.getCtx(), TAG, "extractResolvedAttributes", this.getAtCorpusPath(), CdmLogCode.ErrProjFailedToResolve, new String[0]);
            return resolvedAttributeSet;
        }
        for (ProjectionAttributeState pas : projCtx.getCurrentAttributeStateSet().getStates()) {
            resolvedAttributeSet.merge(pas.getCurrentResolvedAttribute());
        }
        return resolvedAttributeSet;
    }

    private CdmObject getRootOwner() {
        CdmObject rootOwner = this;
        do {
            if ((rootOwner = rootOwner.getOwner()) == null || rootOwner.getOwner() == null || rootOwner.getOwner().getObjectType() != CdmObjectType.ProjectionDef) continue;
            rootOwner = rootOwner.getOwner();
        } while (rootOwner != null && rootOwner.getObjectType() == CdmObjectType.ProjectionDef);
        return rootOwner;
    }
}

