/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.commondatamodel.objectmodel.persistence.cdmfolder;

import com.fasterxml.jackson.databind.JsonNode;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmCorpusContext;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmObject;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmParameterDefinition;
import com.microsoft.commondatamodel.objectmodel.enums.CdmObjectType;
import com.microsoft.commondatamodel.objectmodel.persistence.cdmfolder.DataTypeReferencePersistence;
import com.microsoft.commondatamodel.objectmodel.persistence.cdmfolder.Utils;
import com.microsoft.commondatamodel.objectmodel.persistence.cdmfolder.types.Parameter;
import com.microsoft.commondatamodel.objectmodel.utilities.CopyOptions;
import com.microsoft.commondatamodel.objectmodel.utilities.JMapper;
import com.microsoft.commondatamodel.objectmodel.utilities.ResolveOptions;

public class ParameterPersistence {
    public static CdmParameterDefinition fromData(CdmCorpusContext ctx, JsonNode obj) {
        CdmParameterDefinition parameter = (CdmParameterDefinition)ctx.getCorpus().makeObject(CdmObjectType.ParameterDef, obj.get("name").asText());
        parameter.setExplanation(obj.get("explanation") != null ? obj.get("explanation").asText() : null);
        parameter.setRequired(obj.get("required") != null ? obj.get("required").asBoolean() : false);
        parameter.setDefaultValue(Utils.createConstant(ctx, obj.get("defaultValue")));
        parameter.setDataTypeRef(DataTypeReferencePersistence.fromData(ctx, obj.get("dataType")));
        return parameter;
    }

    public static Parameter toData(CdmParameterDefinition instance, ResolveOptions resOpt, CopyOptions options) {
        JsonNode defVal = null;
        if (instance.getDefaultValue() != null) {
            defVal = instance.getDefaultValue() instanceof String ? JMapper.MAP.valueToTree(instance.getDefaultValue()) : JMapper.MAP.valueToTree(((CdmObject)instance.getDefaultValue()).copyData(resOpt, options));
        }
        Parameter result = new Parameter();
        result.setExplanation(instance.getExplanation());
        result.setName(instance.getName());
        result.setDefaultValue(defVal);
        result.setRequired(instance.isRequired() != null && instance.isRequired() != false ? Boolean.valueOf(true) : null);
        result.setDataType(Utils.jsonForm(instance.getDataTypeRef(), resOpt, options));
        return result;
    }
}

