/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.commondatamodel.objectmodel.storage;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.microsoft.commondatamodel.objectmodel.storage.NetworkAdapter;
import com.microsoft.commondatamodel.objectmodel.storage.StorageAdapterException;
import com.microsoft.commondatamodel.objectmodel.utilities.JMapper;
import com.microsoft.commondatamodel.objectmodel.utilities.StringUtils;
import com.microsoft.commondatamodel.objectmodel.utilities.network.CdmHttpClient;
import com.microsoft.commondatamodel.objectmodel.utilities.network.CdmHttpRequest;
import com.microsoft.commondatamodel.objectmodel.utilities.network.CdmHttpResponse;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;

public class RemoteAdapter
extends NetworkAdapter {
    static final String TYPE = "remote";
    private final Map<String, String> sources = new LinkedHashMap<String, String>();
    private final Map<String, Map<String, String>> sourcesById = new LinkedHashMap<String, Map<String, String>>();
    private Map<String, String> hosts;

    public RemoteAdapter() {
        this(null);
    }

    public RemoteAdapter(Map<String, String> hosts) {
        if (hosts != null) {
            this.setHosts(hosts);
        }
        this.httpClient = new CdmHttpClient();
    }

    @Override
    public boolean canRead() {
        return true;
    }

    @Override
    public String fetchConfig() {
        ObjectNode resultConfig = JsonNodeFactory.instance.objectNode();
        resultConfig.put("type", TYPE);
        ArrayNode hostsArray = JsonNodeFactory.instance.arrayNode();
        ObjectNode configObject = JsonNodeFactory.instance.objectNode();
        for (Map.Entry<String, String> entry : this.hosts.entrySet()) {
            ObjectNode hostItem = JsonNodeFactory.instance.objectNode();
            hostItem.put(entry.getKey(), entry.getValue());
            hostsArray.add((JsonNode)hostItem);
        }
        configObject.put("hosts", (JsonNode)hostsArray);
        for (Map.Entry<String, String> entry : this.fetchNetworkConfig().entrySet()) {
            configObject.set(entry.getKey(), (JsonNode)entry.getValue());
        }
        String locationHint = this.getLocationHint();
        if (locationHint != null) {
            configObject.put("locationHint", locationHint);
        }
        resultConfig.put("config", (JsonNode)configObject);
        try {
            return JMapper.WRITER.writeValueAsString((Object)resultConfig);
        }
        catch (JsonProcessingException jsonProcessingException) {
            throw new StorageAdapterException("", (Exception)((Object)jsonProcessingException));
        }
    }

    @Override
    public void clearCache() {
        this.sources.clear();
        this.sourcesById.clear();
    }

    @Override
    public String createAdapterPath(String corpusPath) throws StorageAdapterException {
        Map<String, String> urlConfig = this.getUrlConfig(corpusPath);
        String protocol = urlConfig.get("protocol");
        String host = urlConfig.get("host");
        String path = urlConfig.get("path");
        return protocol + "://" + host + path;
    }

    @Override
    public String createCorpusPath(String adapterPath) {
        if (StringUtils.isNullOrTrimEmpty(adapterPath)) {
            return null;
        }
        int protocolIndex = adapterPath.indexOf("://");
        if (protocolIndex == -1) {
            return null;
        }
        int pathIndex = adapterPath.indexOf("/", protocolIndex + 3);
        String path = pathIndex != -1 ? adapterPath.substring(pathIndex) : "";
        Map<String, String> hostInfo = this.getOrRegisterHostInfo(adapterPath);
        return String.format("/%s%s", hostInfo.get("key"), path);
    }

    @Override
    public CompletableFuture<String> readAsync(String corpusPath) {
        return CompletableFuture.supplyAsync(() -> {
            String path = this.createAdapterPath(corpusPath);
            LinkedHashMap<String, String> headers = new LinkedHashMap<String, String>();
            headers.put("User-Agent", "CDM");
            CdmHttpRequest cdmHttpRequest = this.setUpCdmRequest(path, headers, "GET");
            try {
                CdmHttpResponse res = this.executeRequest(cdmHttpRequest).get();
                return res != null ? res.getContent() : null;
            }
            catch (Exception e) {
                throw new StorageAdapterException("Could not read remote content at path: " + corpusPath, e);
            }
        });
    }

    private Map<String, String> getOrRegisterHostInfo(String adapterPath) {
        return this.getOrRegisterHostInfo(adapterPath, null);
    }

    private Map<String, String> getOrRegisterHostInfo(String adapterPath, String key) {
        int protocolIndex = adapterPath.indexOf("://");
        if (protocolIndex == -1) {
            return null;
        }
        int pathIndex = adapterPath.indexOf("/", protocolIndex + 3);
        int hostIndex = pathIndex != -1 ? pathIndex : adapterPath.length();
        String protocol = adapterPath.substring(0, protocolIndex);
        String host = adapterPath.substring(protocolIndex + 3, hostIndex);
        String fullHost = adapterPath.substring(0, hostIndex);
        if (!this.sources.containsKey(fullHost)) {
            String guid = key != null ? key : this.getGuid();
            this.sources.put(fullHost, guid);
            LinkedHashMap<String, String> sourceId = new LinkedHashMap<String, String>();
            sourceId.put("protocol", protocol);
            sourceId.put("host", host);
            this.sourcesById.put(guid, sourceId);
        }
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        result.put("key", this.sources.get(fullHost));
        result.put("protocol", protocol);
        result.put("host", host);
        return result;
    }

    @Override
    public void updateConfig(String config) throws IOException {
        if (config == null) {
            throw new StorageAdapterException("Remote adapter needs a config.");
        }
        this.updateNetworkConfig(config);
        JsonNode configsJson = JMapper.MAP.readTree(config);
        if (configsJson.has("locationHint")) {
            this.setLocationHint(configsJson.get("locationHint").asText());
        }
        if (configsJson.has("hosts") && configsJson.get("hosts").isArray()) {
            ArrayNode hosts = (ArrayNode)configsJson.get("hosts");
            LinkedHashMap<String, String> hostsDict = new LinkedHashMap<String, String>();
            for (JsonNode host : hosts) {
                host.fields().forEachRemaining(entry -> hostsDict.put((String)entry.getKey(), ((JsonNode)entry.getValue()).asText()));
            }
            this.hosts = hostsDict;
        }
    }

    private String getGuid() {
        return UUID.randomUUID().toString();
    }

    private Map<String, String> getUrlConfig(String corpusPath) throws StorageAdapterException {
        int hostKeyIndex = corpusPath.indexOf("/", 1);
        String hostKey = corpusPath.substring(1, hostKeyIndex);
        if (!this.sourcesById.containsKey(hostKey)) {
            throw new StorageAdapterException("Host id not identified by remote adapter. Make sure to use createCorpusPath to get the corpus path.");
        }
        String path = corpusPath.substring(hostKeyIndex);
        Map<String, String> config = this.sourcesById.get(hostKey);
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        result.put("protocol", config.get("protocol"));
        result.put("host", config.get("host"));
        result.put("path", path);
        return result;
    }

    public Map<String, String> getHosts() {
        return this.hosts;
    }

    public void setHosts(Map<String, String> hosts) {
        this.hosts = hosts;
        this.hosts.forEach((key, value) -> this.getOrRegisterHostInfo((String)value, (String)key));
    }
}

