/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.commondatamodel.objectmodel.utilities.logger;

import com.microsoft.aad.msal4j.AzureCloudEndpoint;
import com.microsoft.aad.msal4j.ClientCredentialFactory;
import com.microsoft.aad.msal4j.ClientCredentialParameters;
import com.microsoft.aad.msal4j.ConfidentialClientApplication;
import com.microsoft.aad.msal4j.IAuthenticationResult;
import com.microsoft.aad.msal4j.IClientCredential;
import com.microsoft.aad.msal4j.IClientSecret;
import com.microsoft.commondatamodel.objectmodel.enums.EnvironmentType;
import com.microsoft.commondatamodel.objectmodel.utilities.network.TokenProvider;
import java.net.MalformedURLException;
import java.util.Collections;
import java.util.Date;
import java.util.Set;

public class TelemetryConfig {
    private String tenantId;
    private String clientId;
    private String secret;
    private String region;
    private boolean removeUserContent;
    private String kustoClusterName;
    private String kustoDatabaseName;
    private String kustoInfoLogTable = "infoLogs";
    private String kustoWarningLogTable = "warningLogs";
    private String kustoErrorLogTable = "errorLogs";
    private AzureCloudEndpoint cloudInstance;
    private EnvironmentType ingestAtLevel;
    private TokenProvider tokenProvider;
    private ConfidentialClientApplication context;
    private IAuthenticationResult lastAuthenticationResult;
    private static final String CDM_INFOLOG_TABLE = "infoLogs";
    private static final String CDM_WARNINGLOG_TABLE = "warningLogs";
    private static final String CDM_ERRORLOG_TABLE = "errorLogs";

    public TelemetryConfig(TokenProvider tokenProvider, EnvironmentType ingestAtLevel, String region, boolean removeUserContent) {
        this.tokenProvider = tokenProvider;
        this.ingestAtLevel = ingestAtLevel;
        this.region = region;
        this.removeUserContent = removeUserContent;
    }

    public TelemetryConfig(TokenProvider tokenProvider, EnvironmentType ingestAtLevel) {
        this(tokenProvider, ingestAtLevel, null, true);
    }

    public TelemetryConfig(String tenantId, String clientId, String secret, String clusterName, String databaseName, String infoTable, String warningTable, String errorTable, EnvironmentType ingestAtLevel, String region, boolean removeUserContent, AzureCloudEndpoint cloudInstance) {
        this.tenantId = tenantId;
        this.clientId = clientId;
        this.secret = secret;
        this.kustoClusterName = clusterName;
        this.kustoDatabaseName = databaseName;
        this.kustoInfoLogTable = infoTable;
        this.kustoWarningLogTable = warningTable;
        this.kustoErrorLogTable = errorTable;
        this.ingestAtLevel = ingestAtLevel;
        this.region = region;
        this.cloudInstance = cloudInstance;
    }

    public TelemetryConfig(String tenantId, String clientId, String secret, String clusterName, String databaseName, EnvironmentType ingestAtLevel) {
        this(tenantId, clientId, secret, clusterName, databaseName, CDM_INFOLOG_TABLE, CDM_WARNINGLOG_TABLE, CDM_ERRORLOG_TABLE, ingestAtLevel, null, true, AzureCloudEndpoint.AzurePublic);
    }

    public TelemetryConfig(String tenantId, String clientId, String secret, String clusterName, String databaseName, EnvironmentType ingestAtLevel, String region, AzureCloudEndpoint cloudInstance) {
        this(tenantId, clientId, secret, clusterName, databaseName, CDM_INFOLOG_TABLE, CDM_WARNINGLOG_TABLE, CDM_ERRORLOG_TABLE, ingestAtLevel, region, true, cloudInstance);
    }

    public TelemetryConfig(String tenantId, String clientId, String secret, String clusterName, String databaseName, String infoTable, String warningTable, String errorTable, EnvironmentType ingestAtLevel) {
        this(tenantId, clientId, secret, clusterName, databaseName, infoTable, warningTable, errorTable, ingestAtLevel, null, true, AzureCloudEndpoint.AzurePublic);
    }

    public String getAuthenticationToken() {
        if (this.tokenProvider != null) {
            return this.tokenProvider.getToken();
        }
        if (this.tenantId != null && this.clientId != null && this.secret != null && this.kustoClusterName != null && this.kustoDatabaseName != null && this.kustoInfoLogTable != null && this.kustoWarningLogTable != null && this.kustoErrorLogTable != null) {
            this.generateKustoToken();
            String tokenWithHeader = "Bearer " + this.lastAuthenticationResult.accessToken();
            return tokenWithHeader;
        }
        throw new RuntimeException("Failed to get authentication token: No method configured to provide a token.");
    }

    private void buildContext() {
        if (this.context == null) {
            IClientSecret credential = ClientCredentialFactory.createFromSecret((String)this.secret);
            try {
                this.context = ((ConfidentialClientApplication.Builder)ConfidentialClientApplication.builder((String)this.clientId, (IClientCredential)credential).authority(this.cloudInstance.endpoint + this.tenantId)).build();
            }
            catch (MalformedURLException e) {
                throw new RuntimeException("There was an error while building context. Exception: ", e);
            }
        }
    }

    private boolean needsRefreshToken() {
        if (this.lastAuthenticationResult == null) {
            return true;
        }
        Date now = new Date();
        return this.lastAuthenticationResult.expiresOnDate().before(now);
    }

    private void generateKustoToken() {
        IAuthenticationResult result;
        if (!this.needsRefreshToken()) {
            return;
        }
        Set<String> SCOPE = Collections.singleton(String.format("https://%s.kusto.windows.net/.default", this.kustoClusterName));
        this.buildContext();
        try {
            ClientCredentialParameters parameters = ClientCredentialParameters.builder(SCOPE).build();
            result = (IAuthenticationResult)this.context.acquireToken(parameters).join();
        }
        catch (Exception ex) {
            throw new RuntimeException("There was an error while acquiring Kusto authorization Token with client ID/secret authentication. Exception: ", ex);
        }
        if (result == null || result.accessToken() == null) {
            throw new RuntimeException("Received invalid Kusto authentication result. The result might be null, or missing HTTP authorization header from the authentication result.");
        }
        this.lastAuthenticationResult = result;
    }

    void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    String getTenantId() {
        return this.tenantId;
    }

    void setClientId(String clientId) {
        this.clientId = clientId;
    }

    String getClientId() {
        return this.clientId;
    }

    void setSecret(String secret) {
        this.secret = secret;
    }

    String getSecret() {
        return this.secret;
    }

    void setRegion(String region) {
        this.region = region;
    }

    String getRegion() {
        return this.region;
    }

    void setRemoveUserContent(boolean removeUserContent) {
        this.removeUserContent = removeUserContent;
    }

    boolean getRemoveUserContent() {
        return this.removeUserContent;
    }

    void setKustoClusterName(String clusterName) {
        this.kustoClusterName = clusterName;
    }

    String getKustoClusterName() {
        return this.kustoClusterName;
    }

    void setKustoDatabaseName(String databaseName) {
        this.kustoDatabaseName = databaseName;
    }

    String getKustoDatabaseName() {
        return this.kustoDatabaseName;
    }

    void setKustoInfoLogTable(String tableName) {
        this.kustoInfoLogTable = tableName;
    }

    String getKustoInfoLogTable() {
        return this.kustoInfoLogTable;
    }

    void setKustoWarningLogTable(String tableName) {
        this.kustoWarningLogTable = tableName;
    }

    String getKustoWarningLogTable() {
        return this.kustoWarningLogTable;
    }

    void setKustoErrorLogTable(String tableName) {
        this.kustoErrorLogTable = tableName;
    }

    String getKustoErrorLogTable() {
        return this.kustoErrorLogTable;
    }

    void setCloudInstance(AzureCloudEndpoint cloudInstance) {
        this.cloudInstance = cloudInstance;
    }

    AzureCloudEndpoint getCloudInstance() {
        return this.cloudInstance;
    }

    void setIngestAtLevel(EnvironmentType ingestAtLevel) {
        this.ingestAtLevel = ingestAtLevel;
    }

    EnvironmentType getIngestAtLevel() {
        return this.ingestAtLevel;
    }

    void setTokenProvider(TokenProvider tokenProvider) {
        this.tokenProvider = tokenProvider;
    }

    TokenProvider getTokenProvider() {
        return this.tokenProvider;
    }
}

