/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.commondatamodel.objectmodel.utilities.network;

import com.microsoft.commondatamodel.objectmodel.utilities.network.CdmTimedOutException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class TimeLimitedNetworkBlockExecutor {
    public static void runWithTimeout(Runnable runnable, long timeout, TimeUnit timeUnit) {
        TimeLimitedNetworkBlockExecutor.runWithTimeout(() -> {
            runnable.run();
            return null;
        }, timeout, timeUnit);
    }

    public static <T> T runWithTimeout(Callable<T> callable, long timeout, TimeUnit timeUnit) {
        ExecutorService executor = Executors.newSingleThreadExecutor();
        Future<T> future = executor.submit(callable);
        executor.shutdown();
        try {
            return future.get(timeout, timeUnit);
        }
        catch (TimeoutException e) {
            future.cancel(true);
            throw new CdmTimedOutException();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new CdmTimedOutException();
        }
    }
}

