/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.commondatamodel.objectmodel.cdm;

import com.microsoft.commondatamodel.objectmodel.cdm.CdmCollection;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmCorpusContext;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmDocumentDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmFolderDefinition;
import com.microsoft.commondatamodel.objectmodel.enums.CdmObjectType;
import java.util.List;
import java.util.Objects;

public class CdmDocumentCollection
extends CdmCollection<CdmDocumentDefinition> {
    public CdmDocumentCollection(CdmCorpusContext ctx, CdmFolderDefinition owner) {
        super(ctx, owner, CdmObjectType.DocumentDef);
    }

    @Override
    public CdmFolderDefinition getOwner() {
        return (CdmFolderDefinition)super.getOwner();
    }

    @Override
    public void add(int index, CdmDocumentDefinition document) {
        this.addItemModifications(document);
        document.setOwner(this.getOwner());
        this.getAllItems().add(index, document);
    }

    @Override
    public CdmDocumentDefinition add(CdmDocumentDefinition document) {
        this.addItemModifications(document);
        document.setOwner(this.getOwner());
        this.allItems.add(document);
        return document;
    }

    public void add(CdmDocumentDefinition document, String documentName) {
        document.setName(documentName);
        this.add(document);
    }

    @Override
    public CdmDocumentDefinition add(String name) {
        return this.add(name, false);
    }

    @Override
    public CdmDocumentDefinition add(String name, boolean simpleRef) {
        CdmDocumentDefinition document = (CdmDocumentDefinition)this.getCtx().getCorpus().makeObject(this.getDefaultType(), name, simpleRef);
        this.add(document);
        return document;
    }

    @Override
    public void addAll(List<CdmDocumentDefinition> documents) {
        documents.forEach(this::add);
    }

    @Override
    public boolean remove(CdmDocumentDefinition document) {
        return this.remove(document.getName());
    }

    @Override
    public boolean remove(String name) {
        if (this.getOwner().getDocumentLookup().containsKey(name)) {
            this.removeItemModifications(name);
            for (int i = 0; i < this.getAllItems().size(); ++i) {
                if (!Objects.equals(((CdmDocumentDefinition)this.getAllItems().get(i)).getName(), name)) continue;
                boolean save = this.getCtx().getCorpus().isCurrentlyResolving;
                this.getCtx().getCorpus().isCurrentlyResolving = true;
                super.removeAt(i);
                this.getCtx().getCorpus().isCurrentlyResolving = save;
                return true;
            }
        }
        return false;
    }

    @Override
    public void removeAt(int index) {
        if (index >= 0 && index < this.allItems.size()) {
            this.remove(((CdmDocumentDefinition)this.allItems.get(index)).getName());
        }
    }

    @Override
    public void clear() {
        this.getAllItems().forEach(doc -> this.removeItemModifications(doc.getName()));
        super.clear();
    }

    private void addItemModifications(CdmDocumentDefinition document) {
        if (document.getOwner() != null && document.getOwner() != this.getOwner()) {
            document.localizeCorpusPaths(this.getOwner());
            ((CdmFolderDefinition)document.getOwner()).getDocuments().remove(document.getName());
        }
        document.setFolderPath(this.getOwner().getFolderPath());
        document.setFolder(this.getOwner());
        document.setNamespace(this.getOwner().getNamespace());
        document.setNeedsIndexing(true);
        this.makeDocumentDirty();
        this.getOwner().getCorpus().addDocumentObjects(this.getOwner(), document);
    }

    private void removeItemModifications(String documentName) {
        this.getOwner().getCorpus().removeDocumentObjects(this.getOwner(), this.getOwner().getDocumentLookup().get(documentName));
        this.getOwner().getDocumentLookup().remove(documentName);
    }
}

