/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.commondatamodel.objectmodel.cdm;

import com.microsoft.commondatamodel.objectmodel.cdm.CdmCollection;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmCorpusContext;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmObject;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmObjectBase;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmTraitDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmTraitGroupDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmTraitGroupReference;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmTraitReference;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmTraitReferenceBase;
import com.microsoft.commondatamodel.objectmodel.enums.CdmObjectType;
import java.util.List;
import java.util.Objects;

public class CdmTraitCollection
extends CdmCollection<CdmTraitReferenceBase> {
    public CdmTraitCollection(CdmCorpusContext ctx, CdmObject owner) {
        super(ctx, owner, CdmObjectType.TraitRef);
    }

    @Override
    public void add(int index, CdmTraitReferenceBase cdmTraitReference) {
        this.clearCache();
        super.add(index, cdmTraitReference);
    }

    @Override
    public CdmTraitReferenceBase add(String name) {
        return this.add(name, false);
    }

    @Override
    public CdmTraitReferenceBase add(String name, boolean simpleRef) {
        this.clearCache();
        return (CdmTraitReferenceBase)super.add(name, simpleRef);
    }

    @Override
    public CdmTraitReferenceBase add(CdmTraitReferenceBase cdmTraitReference) {
        this.clearCache();
        return super.add(cdmTraitReference);
    }

    @Override
    public CdmTraitReference add(CdmTraitDefinition traitDefinition) {
        return this.add(traitDefinition, false);
    }

    @Override
    public CdmTraitGroupReference add(CdmTraitGroupDefinition traitGroupDefinition) {
        return this.add(traitGroupDefinition, false);
    }

    public CdmTraitReference add(CdmTraitDefinition traitDefinition, boolean simpleRef) {
        this.clearCache();
        CdmTraitReference traitReference = new CdmTraitReference(this.getCtx(), traitDefinition, simpleRef, false);
        super.add(traitReference);
        return traitReference;
    }

    public CdmTraitGroupReference add(CdmTraitGroupDefinition traitGroupDefinition, boolean simpleRef) {
        this.clearCache();
        CdmTraitGroupReference traitGroupReference = new CdmTraitGroupReference(this.getCtx(), traitGroupDefinition, simpleRef);
        super.add(traitGroupReference);
        return traitGroupReference;
    }

    @Override
    public boolean remove(CdmTraitDefinition traitDefToRemove) {
        return this.remove(traitDefToRemove, false);
    }

    @Override
    public boolean remove(CdmTraitGroupDefinition traitGroupDefToRemove) {
        return this.remove(traitGroupDefToRemove.getTraitGroupName());
    }

    public boolean remove(CdmTraitDefinition traitDefToRemove, boolean onlyFromProperty) {
        return this.remove(traitDefToRemove.getTraitName(), onlyFromProperty);
    }

    @Override
    public void removeAt(int index) {
        this.clearCache();
        super.removeAt(index);
    }

    @Override
    public boolean remove(String traitRefName) {
        return this.remove(traitRefName, false);
    }

    public boolean remove(String traitRefName, boolean onlyFromProperty) {
        CdmTraitReferenceBase foundTraitNotFromProperty = null;
        this.clearCache();
        for (CdmTraitReferenceBase traitRef : this) {
            if (!this.corresponds(traitRef, traitRefName)) continue;
            if (traitRef instanceof CdmTraitReference && ((CdmTraitReference)traitRef).isFromProperty()) {
                return super.remove(traitRef);
            }
            foundTraitNotFromProperty = traitRef;
        }
        if (!onlyFromProperty && foundTraitNotFromProperty != null) {
            return super.remove(foundTraitNotFromProperty);
        }
        return false;
    }

    @Override
    public boolean remove(CdmTraitReferenceBase traitToRemove) {
        return this.remove(traitToRemove, false);
    }

    public boolean remove(CdmTraitReferenceBase traitToRemove, boolean onlyFromProperty) {
        return this.remove(traitToRemove.fetchObjectDefinitionName(), onlyFromProperty);
    }

    @Override
    public void clear() {
        this.clearCache();
        super.clear();
    }

    public int indexOf(CdmTraitDefinition traitDefinition) {
        return this.indexOf(traitDefinition, false);
    }

    public int indexOf(CdmTraitGroupDefinition traitGroupDefinition) {
        return this.indexOf(traitGroupDefinition.getTraitGroupName(), false);
    }

    public int indexOf(CdmTraitDefinition traitDefinition, boolean onlyFromProperty) {
        return this.indexOf(traitDefinition.getTraitName(), onlyFromProperty);
    }

    public int indexOf(String traitName) {
        return this.indexOf(traitName, false);
    }

    public int indexOf(String traitName, boolean onlyFromProperty) {
        int indexOfTraitNotFromProperty = -1;
        for (int index = 0; index < this.size(); ++index) {
            if (!this.corresponds((CdmTraitReferenceBase)this.get(index), traitName)) continue;
            CdmTraitReferenceBase ref = (CdmTraitReferenceBase)this.get(index);
            if (ref instanceof CdmTraitGroupReference || ((CdmTraitReference)this.get(index)).isFromProperty()) {
                return index;
            }
            indexOfTraitNotFromProperty = index;
        }
        if (!onlyFromProperty) {
            return indexOfTraitNotFromProperty;
        }
        return -1;
    }

    public int indexOf(CdmTraitReferenceBase trait, boolean onlyFromProperty) {
        return this.indexOf(trait.fetchObjectDefinitionName(), onlyFromProperty);
    }

    @Override
    public void addAll(List<CdmTraitDefinition> traitList) {
        traitList.forEach(this::add);
    }

    public void addAllTraitGroupDefs(List<CdmTraitGroupDefinition> traitGroupList) {
        traitGroupList.forEach(this::add);
    }

    public CdmCollection<CdmTraitReference> toTraitRefs() {
        CdmCollection<CdmTraitReference> traitCollection = new CdmCollection<CdmTraitReference>(this.getCtx(), this.getOwner(), CdmObjectType.TraitRef);
        this.forEach(x -> {
            if (x instanceof CdmTraitReference) {
                traitCollection.add((CdmTraitReference)x);
            }
        });
        return traitCollection;
    }

    public CdmCollection<CdmTraitGroupReference> toTraitGroupRefs() {
        CdmCollection<CdmTraitGroupReference> traitCollection = new CdmCollection<CdmTraitGroupReference>(this.getCtx(), this.getOwner(), CdmObjectType.TraitGroupRef);
        this.forEach(x -> {
            if (x instanceof CdmTraitGroupReference) {
                traitCollection.add((CdmTraitGroupReference)x);
            }
        });
        return traitCollection;
    }

    private boolean corresponds(CdmTraitReferenceBase traitReferenceBase, String traitName) {
        return Objects.equals(traitReferenceBase.fetchObjectDefinitionName(), traitName);
    }

    private void clearCache() {
        if (this.getOwner() instanceof CdmObjectBase) {
            CdmObjectBase owner = (CdmObjectBase)this.getOwner();
            owner.clearTraitCache();
        }
    }
}

