/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.commondatamodel.objectmodel.persistence.cdmfolder;

import com.fasterxml.jackson.databind.JsonNode;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmCorpusContext;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmEntityReference;
import com.microsoft.commondatamodel.objectmodel.cdm.projections.CdmProjection;
import com.microsoft.commondatamodel.objectmodel.enums.CdmObjectType;
import com.microsoft.commondatamodel.objectmodel.persistence.cdmfolder.CdmObjectRefPersistence;
import com.microsoft.commondatamodel.objectmodel.persistence.cdmfolder.ConstantEntityPersistence;
import com.microsoft.commondatamodel.objectmodel.persistence.cdmfolder.EntityPersistence;
import com.microsoft.commondatamodel.objectmodel.persistence.cdmfolder.Utils;
import com.microsoft.commondatamodel.objectmodel.persistence.cdmfolder.projections.ProjectionPersistence;
import com.microsoft.commondatamodel.objectmodel.utilities.CopyOptions;
import com.microsoft.commondatamodel.objectmodel.utilities.ResolveOptions;

public class EntityReferencePersistence {
    public static CdmEntityReference fromData(CdmCorpusContext ctx, JsonNode obj) {
        Object entity;
        if (obj == null) {
            return null;
        }
        boolean simpleReference = true;
        if (obj.isValueNode()) {
            entity = obj.asText();
        } else {
            entity = EntityReferencePersistence.getEntityReference(ctx, obj);
            simpleReference = false;
        }
        CdmEntityReference entityReference = (CdmEntityReference)ctx.getCorpus().makeRef(CdmObjectType.EntityRef, entity, simpleReference);
        if (!obj.isValueNode()) {
            Utils.addListToCdmCollection(entityReference.getAppliedTraits(), Utils.createTraitReferenceList(ctx, obj.get("appliedTraits")));
        }
        return entityReference;
    }

    public static Object toData(CdmEntityReference instance, ResolveOptions resOpt, CopyOptions options) {
        if (instance.getExplicitReference() != null && instance.getExplicitReference() instanceof CdmProjection) {
            return ProjectionPersistence.toData((CdmProjection)instance.getExplicitReference(), resOpt, options);
        }
        return CdmObjectRefPersistence.toData(instance, resOpt, options);
    }

    private static Object getEntityReference(CdmCorpusContext ctx, JsonNode obj) {
        Object entity = null;
        entity = obj.get("entityReference") != null && obj.get("entityReference").isValueNode() ? obj.get("entityReference") : (obj.get("entityReference") != null && obj.get("entityReference").get("entityShape") != null ? ConstantEntityPersistence.fromData(ctx, obj.get("entityReference")) : (obj.get("source") != null || obj.get("operations") != null ? ProjectionPersistence.fromData(ctx, obj) : EntityPersistence.fromData(ctx, obj.get("entityReference"))));
        return entity;
    }
}

