/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.commondatamodel.objectmodel.persistence.cdmfolder.projections;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmCorpusContext;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmEntityReference;
import com.microsoft.commondatamodel.objectmodel.cdm.projections.CdmOperationAddArtifactAttribute;
import com.microsoft.commondatamodel.objectmodel.cdm.projections.CdmOperationAddAttributeGroup;
import com.microsoft.commondatamodel.objectmodel.cdm.projections.CdmOperationAddCountAttribute;
import com.microsoft.commondatamodel.objectmodel.cdm.projections.CdmOperationAddSupportingAttribute;
import com.microsoft.commondatamodel.objectmodel.cdm.projections.CdmOperationAddTypeAttribute;
import com.microsoft.commondatamodel.objectmodel.cdm.projections.CdmOperationAlterTraits;
import com.microsoft.commondatamodel.objectmodel.cdm.projections.CdmOperationArrayExpansion;
import com.microsoft.commondatamodel.objectmodel.cdm.projections.CdmOperationBase;
import com.microsoft.commondatamodel.objectmodel.cdm.projections.CdmOperationCombineAttributes;
import com.microsoft.commondatamodel.objectmodel.cdm.projections.CdmOperationExcludeAttributes;
import com.microsoft.commondatamodel.objectmodel.cdm.projections.CdmOperationIncludeAttributes;
import com.microsoft.commondatamodel.objectmodel.cdm.projections.CdmOperationRenameAttributes;
import com.microsoft.commondatamodel.objectmodel.cdm.projections.CdmOperationReplaceAsForeignKey;
import com.microsoft.commondatamodel.objectmodel.cdm.projections.CdmProjection;
import com.microsoft.commondatamodel.objectmodel.cdm.projections.OperationTypeConvertor;
import com.microsoft.commondatamodel.objectmodel.enums.CdmLogCode;
import com.microsoft.commondatamodel.objectmodel.enums.CdmObjectType;
import com.microsoft.commondatamodel.objectmodel.enums.CdmOperationType;
import com.microsoft.commondatamodel.objectmodel.persistence.cdmfolder.EntityReferencePersistence;
import com.microsoft.commondatamodel.objectmodel.persistence.cdmfolder.projections.OperationAddArtifactAttributePersistence;
import com.microsoft.commondatamodel.objectmodel.persistence.cdmfolder.projections.OperationAddAttributeGroupPersistence;
import com.microsoft.commondatamodel.objectmodel.persistence.cdmfolder.projections.OperationAddCountAttributePersistence;
import com.microsoft.commondatamodel.objectmodel.persistence.cdmfolder.projections.OperationAddSupportingAttributePersistence;
import com.microsoft.commondatamodel.objectmodel.persistence.cdmfolder.projections.OperationAddTypeAttributePersistence;
import com.microsoft.commondatamodel.objectmodel.persistence.cdmfolder.projections.OperationAlterTraitsPersistence;
import com.microsoft.commondatamodel.objectmodel.persistence.cdmfolder.projections.OperationArrayExpansionPersistence;
import com.microsoft.commondatamodel.objectmodel.persistence.cdmfolder.projections.OperationCombineAttributesPersistence;
import com.microsoft.commondatamodel.objectmodel.persistence.cdmfolder.projections.OperationExcludeAttributesPersistence;
import com.microsoft.commondatamodel.objectmodel.persistence.cdmfolder.projections.OperationIncludeAttributesPersistence;
import com.microsoft.commondatamodel.objectmodel.persistence.cdmfolder.projections.OperationRenameAttributesPersistence;
import com.microsoft.commondatamodel.objectmodel.persistence.cdmfolder.projections.OperationReplaceAsForeignKeyPersistence;
import com.microsoft.commondatamodel.objectmodel.persistence.cdmfolder.types.projections.OperationAddArtifactAttribute;
import com.microsoft.commondatamodel.objectmodel.persistence.cdmfolder.types.projections.OperationAddAttributeGroup;
import com.microsoft.commondatamodel.objectmodel.persistence.cdmfolder.types.projections.OperationAddCountAttribute;
import com.microsoft.commondatamodel.objectmodel.persistence.cdmfolder.types.projections.OperationAddSupportingAttribute;
import com.microsoft.commondatamodel.objectmodel.persistence.cdmfolder.types.projections.OperationAddTypeAttribute;
import com.microsoft.commondatamodel.objectmodel.persistence.cdmfolder.types.projections.OperationAlterTraits;
import com.microsoft.commondatamodel.objectmodel.persistence.cdmfolder.types.projections.OperationArrayExpansion;
import com.microsoft.commondatamodel.objectmodel.persistence.cdmfolder.types.projections.OperationBase;
import com.microsoft.commondatamodel.objectmodel.persistence.cdmfolder.types.projections.OperationCombineAttributes;
import com.microsoft.commondatamodel.objectmodel.persistence.cdmfolder.types.projections.OperationExcludeAttributes;
import com.microsoft.commondatamodel.objectmodel.persistence.cdmfolder.types.projections.OperationIncludeAttributes;
import com.microsoft.commondatamodel.objectmodel.persistence.cdmfolder.types.projections.OperationRenameAttributes;
import com.microsoft.commondatamodel.objectmodel.persistence.cdmfolder.types.projections.OperationReplaceAsForeignKey;
import com.microsoft.commondatamodel.objectmodel.persistence.cdmfolder.types.projections.Projection;
import com.microsoft.commondatamodel.objectmodel.utilities.CopyOptions;
import com.microsoft.commondatamodel.objectmodel.utilities.JMapper;
import com.microsoft.commondatamodel.objectmodel.utilities.ResolveOptions;
import com.microsoft.commondatamodel.objectmodel.utilities.StringUtils;
import com.microsoft.commondatamodel.objectmodel.utilities.logger.Logger;
import java.util.ArrayList;
import java.util.List;

public class ProjectionPersistence {
    private static final String TAG = ProjectionPersistence.class.getSimpleName();

    public static CdmProjection fromData(CdmCorpusContext ctx, JsonNode obj) {
        if (obj == null) {
            return null;
        }
        CdmProjection projection = (CdmProjection)ctx.getCorpus().makeObject(CdmObjectType.ProjectionDef);
        CdmEntityReference source = EntityReferencePersistence.fromData(ctx, obj.get("source"));
        if (obj.get("explanation") != null) {
            projection.setExplanation(obj.get("explanation").asText());
        }
        if (obj.get("condition") != null) {
            projection.setCondition(obj.get("condition").asText());
        }
        if (obj.get("runSequentially") != null) {
            projection.setRunSequentially(obj.get("runSequentially").asBoolean());
        }
        if (obj.get("operations") != null) {
            List operationJsons = (List)JMapper.MAP.convertValue((Object)obj.get("operations"), (TypeReference)new TypeReference<List<JsonNode>>(){});
            block28: for (JsonNode operationJson : operationJsons) {
                String type;
                switch (type = operationJson.get("$type").asText()) {
                    case "addCountAttribute": {
                        CdmOperationAddCountAttribute addCountAttributeOp = OperationAddCountAttributePersistence.fromData(ctx, operationJson);
                        projection.getOperations().add(addCountAttributeOp);
                        continue block28;
                    }
                    case "addSupportingAttribute": {
                        CdmOperationAddSupportingAttribute addSupportingAttributeOp = OperationAddSupportingAttributePersistence.fromData(ctx, operationJson);
                        projection.getOperations().add(addSupportingAttributeOp);
                        continue block28;
                    }
                    case "addTypeAttribute": {
                        CdmOperationAddTypeAttribute addTypeAttributeOp = OperationAddTypeAttributePersistence.fromData(ctx, operationJson);
                        projection.getOperations().add(addTypeAttributeOp);
                        continue block28;
                    }
                    case "excludeAttributes": {
                        CdmOperationExcludeAttributes excludeAttributesOp = OperationExcludeAttributesPersistence.fromData(ctx, operationJson);
                        projection.getOperations().add(excludeAttributesOp);
                        continue block28;
                    }
                    case "arrayExpansion": {
                        CdmOperationArrayExpansion arrayExpansionOp = OperationArrayExpansionPersistence.fromData(ctx, operationJson);
                        projection.getOperations().add(arrayExpansionOp);
                        continue block28;
                    }
                    case "combineAttributes": {
                        CdmOperationCombineAttributes combineAttributesOp = OperationCombineAttributesPersistence.fromData(ctx, operationJson);
                        projection.getOperations().add(combineAttributesOp);
                        continue block28;
                    }
                    case "renameAttributes": {
                        CdmOperationRenameAttributes renameAttributesOp = OperationRenameAttributesPersistence.fromData(ctx, operationJson);
                        projection.getOperations().add(renameAttributesOp);
                        continue block28;
                    }
                    case "replaceAsForeignKey": {
                        CdmOperationReplaceAsForeignKey replaceAsForeignKeyOp = OperationReplaceAsForeignKeyPersistence.fromData(ctx, operationJson);
                        projection.getOperations().add(replaceAsForeignKeyOp);
                        continue block28;
                    }
                    case "includeAttributes": {
                        CdmOperationIncludeAttributes includeAttributesOp = OperationIncludeAttributesPersistence.fromData(ctx, operationJson);
                        projection.getOperations().add(includeAttributesOp);
                        continue block28;
                    }
                    case "addAttributeGroup": {
                        CdmOperationAddAttributeGroup addAttributeGroupOp = OperationAddAttributeGroupPersistence.fromData(ctx, operationJson);
                        projection.getOperations().add(addAttributeGroupOp);
                        continue block28;
                    }
                    case "alterTraits": {
                        CdmOperationAlterTraits addAlterTraitsOp = OperationAlterTraitsPersistence.fromData(ctx, operationJson);
                        projection.getOperations().add(addAlterTraitsOp);
                        continue block28;
                    }
                    case "addArtifactAttribute": {
                        CdmOperationAddArtifactAttribute addArtifactAttributeOp = OperationAddArtifactAttributePersistence.fromData(ctx, operationJson);
                        projection.getOperations().add(addArtifactAttributeOp);
                        continue block28;
                    }
                }
                Logger.error(ctx, TAG, "fromData", source.getAtCorpusPath(), CdmLogCode.ErrPersistProjInvalidOpsType, type);
            }
        }
        projection.setSource(source);
        return projection;
    }

    public static Projection toData(CdmProjection instance, ResolveOptions resOpt, CopyOptions options) {
        if (instance == null) {
            return null;
        }
        Object source = null;
        if (instance.getSource() != null && !StringUtils.isNullOrEmpty(instance.getSource().getNamedReference()) && instance.getSource().getExplicitReference() == null) {
            source = instance.getSource().getNamedReference();
        } else if (instance.getSource() != null && instance.getSource().getObjectType() == CdmObjectType.EntityRef) {
            source = EntityReferencePersistence.toData(instance.getSource(), resOpt, options);
        } else if (instance.getSource() != null) {
            source = instance.getSource();
        }
        ArrayList<OperationBase> operations = null;
        if (instance.getOperations() != null && instance.getOperations().getCount() > 0) {
            operations = new ArrayList<OperationBase>();
            block14: for (CdmOperationBase operation : instance.getOperations()) {
                switch (operation.getObjectType()) {
                    case OperationAddCountAttributeDef: {
                        OperationAddCountAttribute addCountAttributeOp = OperationAddCountAttributePersistence.toData((CdmOperationAddCountAttribute)operation, resOpt, options);
                        operations.add(addCountAttributeOp);
                        continue block14;
                    }
                    case OperationAddSupportingAttributeDef: {
                        OperationAddSupportingAttribute addSupportingAttributeOp = OperationAddSupportingAttributePersistence.toData((CdmOperationAddSupportingAttribute)operation, resOpt, options);
                        operations.add(addSupportingAttributeOp);
                        continue block14;
                    }
                    case OperationAddTypeAttributeDef: {
                        OperationAddTypeAttribute addTypeAttributeOp = OperationAddTypeAttributePersistence.toData((CdmOperationAddTypeAttribute)operation, resOpt, options);
                        operations.add(addTypeAttributeOp);
                        continue block14;
                    }
                    case OperationExcludeAttributesDef: {
                        OperationExcludeAttributes excludeAttributesOp = OperationExcludeAttributesPersistence.toData((CdmOperationExcludeAttributes)operation, resOpt, options);
                        operations.add(excludeAttributesOp);
                        continue block14;
                    }
                    case OperationArrayExpansionDef: {
                        OperationArrayExpansion arrayExpansionOp = OperationArrayExpansionPersistence.toData((CdmOperationArrayExpansion)operation, resOpt, options);
                        operations.add(arrayExpansionOp);
                        continue block14;
                    }
                    case OperationCombineAttributesDef: {
                        OperationCombineAttributes combineAttributesOp = OperationCombineAttributesPersistence.toData((CdmOperationCombineAttributes)operation, resOpt, options);
                        operations.add(combineAttributesOp);
                        continue block14;
                    }
                    case OperationRenameAttributesDef: {
                        OperationRenameAttributes renameAttributesOp = OperationRenameAttributesPersistence.toData((CdmOperationRenameAttributes)operation, resOpt, options);
                        operations.add(renameAttributesOp);
                        continue block14;
                    }
                    case OperationReplaceAsForeignKeyDef: {
                        OperationReplaceAsForeignKey replaceAsForeignKeyOp = OperationReplaceAsForeignKeyPersistence.toData((CdmOperationReplaceAsForeignKey)operation, resOpt, options);
                        operations.add(replaceAsForeignKeyOp);
                        continue block14;
                    }
                    case OperationIncludeAttributesDef: {
                        OperationIncludeAttributes includeAttributesOp = OperationIncludeAttributesPersistence.toData((CdmOperationIncludeAttributes)operation, resOpt, options);
                        operations.add(includeAttributesOp);
                        continue block14;
                    }
                    case OperationAddAttributeGroupDef: {
                        OperationAddAttributeGroup addAttributeGroupOp = OperationAddAttributeGroupPersistence.toData((CdmOperationAddAttributeGroup)operation, resOpt, options);
                        operations.add(addAttributeGroupOp);
                        continue block14;
                    }
                    case OperationAlterTraitsDef: {
                        OperationAlterTraits alterTraitsOp = OperationAlterTraitsPersistence.toData((CdmOperationAlterTraits)operation, resOpt, options);
                        operations.add(alterTraitsOp);
                        continue block14;
                    }
                    case OperationAddArtifactAttributeDef: {
                        OperationAddArtifactAttribute addArtifactAttributeOp = OperationAddArtifactAttributePersistence.toData((CdmOperationAddArtifactAttribute)operation, resOpt, options);
                        operations.add(addArtifactAttributeOp);
                        continue block14;
                    }
                }
                OperationBase baseOp = new OperationBase();
                baseOp.setType(OperationTypeConvertor.operationTypeToString(CdmOperationType.Error));
                operations.add(baseOp);
            }
        }
        Projection obj = new Projection();
        obj.setExplanation(instance.getExplanation());
        obj.setSource(source);
        obj.setOperations(operations);
        obj.setCondition(instance.getCondition());
        obj.setRunSequentially(instance.getRunSequentially());
        return obj;
    }
}

