/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.commondatamodel.objectmodel.utilities;

import com.microsoft.commondatamodel.objectmodel.utilities.StringUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;

public class AttributeResolutionDirectiveSet {
    private Set<String> set;
    private Set<String> setRemoved;
    private String sortedTag;

    public AttributeResolutionDirectiveSet() {
    }

    public AttributeResolutionDirectiveSet(Set<String> set) {
        this.set = new LinkedHashSet<String>(set);
    }

    public AttributeResolutionDirectiveSet copy() {
        AttributeResolutionDirectiveSet result = new AttributeResolutionDirectiveSet();
        if (this.set != null) {
            result.setSet(new LinkedHashSet<String>(this.set));
        }
        if (this.setRemoved != null) {
            result.setSetRemoved(new LinkedHashSet<String>(this.setRemoved));
        }
        result.sortedTag = this.sortedTag;
        return result;
    }

    public boolean has(String directive) {
        if (this.set != null) {
            return this.set.contains(directive);
        }
        return false;
    }

    public void add(String directive) {
        if (this.set == null) {
            this.set = new LinkedHashSet<String>();
        }
        if (this.setRemoved != null && this.setRemoved.contains(directive)) {
            return;
        }
        this.set.add(directive);
        this.sortedTag = null;
    }

    public void delete(String directive) {
        if (this.setRemoved == null) {
            this.setRemoved = new LinkedHashSet<String>();
        }
        this.getSetRemoved().add(directive);
        if (this.set != null) {
            this.set.remove(directive);
        }
        this.sortedTag = null;
    }

    public void merge(AttributeResolutionDirectiveSet directives) {
        if (directives != null) {
            if (directives.getSetRemoved() != null) {
                for (String d : directives.getSetRemoved()) {
                    this.delete(d);
                }
            }
            if (directives.getSet() != null) {
                this.set.addAll(directives.getSet());
            }
            this.sortedTag = null;
        }
    }

    public String getTag() {
        if (StringUtils.isNullOrEmpty(this.sortedTag) && this.set != null && !this.set.isEmpty()) {
            this.sortedTag = "";
            StringBuilder tagBuilder = new StringBuilder();
            ArrayList<String> sorted = new ArrayList<String>(this.set);
            Collections.sort(sorted);
            for (String sortedItem : sorted) {
                tagBuilder.append('-').append(sortedItem);
            }
            this.sortedTag = tagBuilder.toString();
        }
        if (!StringUtils.isNullOrEmpty(this.sortedTag)) {
            return this.sortedTag;
        }
        return "";
    }

    public Set<String> getSet() {
        return this.set;
    }

    public void setSet(Set<String> set) {
        this.set = set;
    }

    public Set<String> getSetRemoved() {
        return this.setRemoved;
    }

    public void setSetRemoved(Set<String> setRemoved) {
        this.setRemoved = setRemoved;
    }
}

