/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.commondatamodel.objectmodel.utilities;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmArgumentCollection;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmArgumentDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmAttribute;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmConstantEntityDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmCorpusContext;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmEntityReference;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmObject;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmObjectBase;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmObjectDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmObjectReference;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmTraitCollection;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmTraitGroupReference;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmTraitReference;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmTraitReferenceBase;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmTypeAttributeDefinition;
import com.microsoft.commondatamodel.objectmodel.enums.CdmDataFormat;
import com.microsoft.commondatamodel.objectmodel.enums.CdmLogCode;
import com.microsoft.commondatamodel.objectmodel.enums.CdmObjectType;
import com.microsoft.commondatamodel.objectmodel.enums.CdmPropertyName;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.ResolvedTrait;
import com.microsoft.commondatamodel.objectmodel.utilities.CdmDataFormatTrait;
import com.microsoft.commondatamodel.objectmodel.utilities.CdmTraitName;
import com.microsoft.commondatamodel.objectmodel.utilities.logger.Logger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;

@Deprecated
public class TraitToPropertyMap {
    private static final String TAG = TraitToPropertyMap.class.getSimpleName();
    private CdmObject host;
    private static Map<CdmTraitName, List<CdmPropertyName>> TRAIT_TO_LIST_OF_PROPERTIES_MAP = new ConcurrentHashMap<CdmTraitName, List<CdmPropertyName>>();
    private static String[] dataFormatTraitNames = new String[]{"is.dataFormat.integer", "is.dataFormat.small", "is.dataFormat.big", "is.dataFormat.floatingPoint", "is.dataFormat.guid", "is.dataFormat.character", "is.dataFormat.array", "is.dataFormat.byte", "is.dataFormat.time", "is.dataFormat.date", "is.dataFormat.timeOffset", "is.dataFormat.boolean", "is.dataFormat.numeric.shaped", "means.content.text.JSON"};

    @Deprecated
    public TraitToPropertyMap(CdmObject host) {
        this.host = host;
    }

    private static String asText(JsonNode node) {
        return null == node ? null : node.asText();
    }

    @Deprecated
    public Object fetchPropertyValue(CdmPropertyName propertyName) {
        return this.fetchPropertyValue(propertyName, false);
    }

    @Deprecated
    public Object fetchPropertyValue(CdmPropertyName propertyName, boolean onlyFromProperty) {
        switch (propertyName) {
            case VERSION: {
                return TraitToPropertyMap.fetchTraitReferenceArgumentValue(this.fetchTraitReference(CdmTraitName.VERSION.toString(), onlyFromProperty), "versionNumber");
            }
            case SOURCE_NAME: {
                return TraitToPropertyMap.fetchTraitReferenceArgumentValue(this.fetchTraitReference(CdmTraitName.SOURCE_NAME.toString(), onlyFromProperty), "name");
            }
            case DISPLAY_NAME: {
                return this.fetchLocalizedTraitTable(CdmTraitName.DISPLAY_NAME.toString(), onlyFromProperty);
            }
            case DESCRIPTION: {
                return this.fetchLocalizedTraitTable(CdmTraitName.DESCRIPTION.toString(), onlyFromProperty);
            }
            case CDM_SCHEMAS: {
                return this.fetchSingleAttTraitTable(CdmTraitName.ATTRIBUTE_GROUP.toString(), "groupList", onlyFromProperty);
            }
            case SOURCE_ORDERING: {
                return TraitToPropertyMap.fetchTraitReferenceArgumentValue(this.fetchTraitReference(CdmTraitName.SOURCE_ORDERING.toString()), "ordinal");
            }
            case IS_PRIMARY_KEY: {
                if (this.host instanceof CdmTypeAttributeDefinition) {
                    CdmTypeAttributeDefinition typeAttribute = (CdmTypeAttributeDefinition)this.host;
                    if (!onlyFromProperty && typeAttribute.getPurpose() != null && typeAttribute.getPurpose().getNamedReference().equals("identifiedBy")) {
                        return true;
                    }
                }
                return this.fetchTraitReference(CdmTraitName.IS_IDENTIFIED_BY.toString(), onlyFromProperty) != null;
            }
            case IS_NULLABLE: {
                return this.fetchTraitReference(CdmTraitName.IS_NULLABLE.toString(), onlyFromProperty) != null;
            }
            case IS_READ_ONLY: {
                return this.fetchTraitReference(CdmTraitName.IS_READ_ONLY.toString(), onlyFromProperty) != null;
            }
            case IS_RESOLVED: {
                CdmTraitReference trait = this.fetchTraitReference(CdmTraitName.IS_RESOLVED.toString(), onlyFromProperty);
                return trait != null && trait.getArguments() != null && "resolved".equals(trait.getArguments().fetchValue("level"));
            }
            case VALUE_CONSTRAINED_TO_LIST: {
                return this.fetchTraitReference(CdmTraitName.VALUE_CONSTRAINED_TO_LIST.toString(), onlyFromProperty) != null;
            }
            case MAXIMUM_VALUE: {
                return TraitToPropertyMap.fetchTraitReferenceArgumentValue(this.fetchTraitReference(CdmTraitName.IS_CONSTRAINED.toString(), onlyFromProperty), CdmPropertyName.MAXIMUM_VALUE.toString());
            }
            case MINIMUM_VALUE: {
                return TraitToPropertyMap.fetchTraitReferenceArgumentValue(this.fetchTraitReference(CdmTraitName.IS_CONSTRAINED.toString(), onlyFromProperty), CdmPropertyName.MINIMUM_VALUE.toString());
            }
            case MAXIMUM_LENGTH: {
                Object temp = TraitToPropertyMap.fetchTraitReferenceArgumentValue(this.fetchTraitReference(CdmTraitName.IS_CONSTRAINED.toString(), onlyFromProperty), CdmPropertyName.MAXIMUM_LENGTH.toString());
                if (temp == null) break;
                return temp;
            }
            case DATA_FORMAT: {
                return this.traitsToDataFormat(onlyFromProperty);
            }
            case PRIMARY_KEY: {
                Object attRef = TraitToPropertyMap.fetchTraitReferenceArgumentValue(this.fetchTraitReference(CdmTraitName.IS_IDENTIFIED_BY.toString(), onlyFromProperty), "attribute");
                if (attRef == null) break;
                if (attRef instanceof String) {
                    return attRef;
                }
                return ((CdmTypeAttributeDefinition)attRef).fetchObjectDefinitionName();
            }
            case DEFAULT: {
                return this.fetchDefaultValue(onlyFromProperty);
            }
        }
        return null;
    }

    @Deprecated
    public CdmTraitReference fetchTraitReference(String traitName) {
        return this.fetchTraitReference(traitName, false);
    }

    @Deprecated
    private CdmTraitReference fetchTraitReference(String traitName, boolean onlyFromProperty) {
        int traitIndex = this.getTraits() != null ? this.getTraits().indexOf(traitName, onlyFromProperty) : -1;
        return traitIndex == -1 ? null : (CdmTraitReference)this.getTraits().get(traitIndex);
    }

    @Deprecated
    public void updatePropertyValue(CdmPropertyName propertyName, Object newValue) {
        boolean multipleProperties;
        Enum traitName = this.mapTraitName(propertyName);
        List<CdmPropertyName> listOfProps = TRAIT_TO_LIST_OF_PROPERTIES_MAP.get(traitName);
        boolean bl = multipleProperties = listOfProps != null && listOfProps.size() > 1;
        if (newValue == null && !multipleProperties) {
            this.removeTrait(traitName.toString());
        } else {
            switch (propertyName) {
                case VERSION: {
                    this.updateTraitArgument(CdmTraitName.VERSION.toString(), "versionNumber", newValue);
                    break;
                }
                case CDM_SCHEMAS: {
                    this.updateSingleAttributeTraitTable(CdmTraitName.ATTRIBUTE_GROUP.toString(), "groupList", "attributeGroupSet", (List)newValue);
                    break;
                }
                case SOURCE_NAME: {
                    this.updateTraitArgument(CdmTraitName.SOURCE_NAME.toString(), "name", newValue);
                    break;
                }
                case DISPLAY_NAME: {
                    this.ConstructLocalizedTraitTable(CdmTraitName.DISPLAY_NAME.toString(), (String)newValue);
                    break;
                }
                case DESCRIPTION: {
                    this.ConstructLocalizedTraitTable(CdmTraitName.DESCRIPTION.toString(), (String)newValue);
                    break;
                }
                case SOURCE_ORDERING: {
                    this.updateTraitArgument(CdmTraitName.SOURCE_ORDERING.toString(), "ordinal", newValue.toString());
                    break;
                }
                case IS_PRIMARY_KEY: {
                    this.updateTraitArgument(CdmTraitName.IS_IDENTIFIED_BY.toString(), "", newValue);
                    break;
                }
                case IS_READ_ONLY: {
                    this.mapBooleanTrait(CdmTraitName.IS_READ_ONLY.toString(), (Boolean)newValue);
                    break;
                }
                case IS_NULLABLE: {
                    this.mapBooleanTrait(CdmTraitName.IS_NULLABLE.toString(), (Boolean)newValue);
                    break;
                }
                case VALUE_CONSTRAINED_TO_LIST: {
                    this.mapBooleanTrait(CdmTraitName.VALUE_CONSTRAINED_TO_LIST.toString(), (Boolean)newValue);
                    break;
                }
                case MAXIMUM_VALUE: {
                    this.updateTraitArgument(CdmTraitName.IS_CONSTRAINED.toString(), CdmPropertyName.MAXIMUM_VALUE.toString(), newValue);
                    break;
                }
                case MINIMUM_VALUE: {
                    this.updateTraitArgument(CdmTraitName.IS_CONSTRAINED.toString(), CdmPropertyName.MINIMUM_VALUE.toString(), newValue);
                    break;
                }
                case MAXIMUM_LENGTH: {
                    this.updateTraitArgument(CdmTraitName.IS_CONSTRAINED.toString(), CdmPropertyName.MAXIMUM_LENGTH.toString(), newValue);
                    break;
                }
                case DATA_FORMAT: {
                    this.dataFormatToTraits(newValue.toString());
                    break;
                }
                case DEFAULT: {
                    this.updateDefaultValue(newValue);
                }
            }
        }
    }

    private void dataFormatToTraits(String dataFormat) {
        for (String traitName : dataFormatTraitNames) {
            this.removeTrait(traitName);
        }
        switch (CdmDataFormat.fromString(dataFormat)) {
            case Int16: {
                this.fetchOrCreateTrait(CdmDataFormatTrait.INTEGER.toString(), true);
                this.fetchOrCreateTrait(CdmDataFormatTrait.SMALL.toString(), true);
                break;
            }
            case Int32: {
                this.fetchOrCreateTrait(CdmDataFormatTrait.INTEGER.toString(), true);
                break;
            }
            case Int64: {
                this.fetchOrCreateTrait(CdmDataFormatTrait.INTEGER.toString(), true);
                this.fetchOrCreateTrait(CdmDataFormatTrait.BIG.toString(), true);
                break;
            }
            case Float: {
                this.fetchOrCreateTrait(CdmDataFormatTrait.FLOATING_POINT.toString(), true);
                break;
            }
            case Double: {
                this.fetchOrCreateTrait(CdmDataFormatTrait.FLOATING_POINT.toString(), true);
                this.fetchOrCreateTrait(CdmDataFormatTrait.BIG.toString(), true);
                break;
            }
            case Guid: {
                this.fetchOrCreateTrait(CdmDataFormatTrait.GUID.toString(), true);
                this.fetchOrCreateTrait(CdmDataFormatTrait.CHARACTER.toString(), true);
                this.fetchOrCreateTrait(CdmDataFormatTrait.ARRAY.toString(), true);
                break;
            }
            case String: {
                this.fetchOrCreateTrait(CdmDataFormatTrait.CHARACTER.toString(), true);
                this.fetchOrCreateTrait(CdmDataFormatTrait.ARRAY.toString(), true);
                break;
            }
            case Char: {
                this.fetchOrCreateTrait(CdmDataFormatTrait.CHARACTER.toString(), true);
                this.fetchOrCreateTrait(CdmDataFormatTrait.BIG.toString(), true);
                break;
            }
            case Byte: {
                this.fetchOrCreateTrait(CdmDataFormatTrait.BYTE.toString(), true);
                break;
            }
            case Binary: {
                this.fetchOrCreateTrait(CdmDataFormatTrait.BYTE.toString(), true);
                this.fetchOrCreateTrait(CdmDataFormatTrait.ARRAY.toString(), true);
                break;
            }
            case Time: {
                this.fetchOrCreateTrait(CdmDataFormatTrait.TIME.toString(), true);
                break;
            }
            case Date: {
                this.fetchOrCreateTrait(CdmDataFormatTrait.DATE.toString(), true);
                break;
            }
            case DateTime: {
                this.fetchOrCreateTrait(CdmDataFormatTrait.TIME.toString(), true);
                this.fetchOrCreateTrait(CdmDataFormatTrait.DATE.toString(), true);
                break;
            }
            case DateTimeOffset: {
                this.fetchOrCreateTrait(CdmDataFormatTrait.TIME.toString(), true);
                this.fetchOrCreateTrait(CdmDataFormatTrait.DATE.toString(), true);
                this.fetchOrCreateTrait(CdmDataFormatTrait.DATETIME_OFFSET.toString(), true);
                break;
            }
            case Boolean: {
                this.fetchOrCreateTrait(CdmDataFormatTrait.BOOLEAN.toString(), true);
                break;
            }
            case Decimal: {
                this.fetchOrCreateTrait(CdmDataFormatTrait.NUMERIC_SHAPED.toString(), true);
                break;
            }
            case Json: {
                this.fetchOrCreateTrait(CdmDataFormatTrait.ARRAY.toString(), true);
                this.fetchOrCreateTrait(CdmDataFormatTrait.JSON.toString(), true);
            }
        }
    }

    private void ConstructLocalizedTraitTable(String traitName, String sourceText) {
        this.updateTraitTable(traitName, "localizedDisplayText", "localizedTable", (cEnt, created) -> {
            if (created.booleanValue()) {
                ArrayList<List<String>> list = new ArrayList<List<String>>();
                ArrayList<String> innerList = new ArrayList<String>();
                innerList.add("en");
                innerList.add(sourceText);
                list.add(innerList);
                cEnt.setConstantValues(list);
            } else {
                cEnt.updateConstantValue(null, 1, sourceText, 0, "en", -1);
            }
        });
    }

    private Object fetchLocalizedTraitTable(String traitName, boolean onlyFromProperty) {
        CdmConstantEntityDefinition cEnt = this.fetchTraitTable(traitName, "localizedDisplayText", onlyFromProperty);
        if (cEnt != null) {
            return cEnt.fetchConstantValue(null, 1, 0, "en", -1);
        }
        return null;
    }

    private CdmTraitReference fetchOrCreateTrait(String traitName, boolean simpleRef) {
        CdmTraitReference trait = this.fetchTraitReference(traitName, true);
        if (trait == null) {
            trait = (CdmTraitReference)this.getCtx().getCorpus().makeObject(CdmObjectType.TraitRef, traitName, simpleRef);
            trait.setFromProperty(true);
            this.getTraits().add(trait);
        }
        return trait;
    }

    private List<String> fetchSingleAttTraitTable(String traitName, String argName, boolean onlyFromProperty) {
        CdmConstantEntityDefinition cEnt = this.fetchTraitTable(traitName, argName, onlyFromProperty);
        if (cEnt != null) {
            ArrayList<String> result = new ArrayList<String>();
            for (List<String> v : cEnt.getConstantValues()) {
                result.add(v.get(0));
            }
            return result;
        }
        return null;
    }

    private Object fetchDefaultValue(boolean onlyFromProperty) {
        CdmTraitReference trait = this.fetchTraitReference(CdmTraitName.DOES_HAVE_DEFAULT.toString(), onlyFromProperty);
        if (trait != null) {
            Object defVal = TraitToPropertyMap.fetchTraitReferenceArgumentValue(trait, "default");
            if (defVal != null) {
                CdmConstantEntityDefinition cEnt;
                CdmObject cdmObjectDefVal;
                if (defVal instanceof String) {
                    return defVal;
                }
                if (defVal instanceof CdmObject && (cdmObjectDefVal = (CdmObject)defVal).getObjectType() == CdmObjectType.EntityRef && (cEnt = (CdmConstantEntityDefinition)cdmObjectDefVal.fetchObjectDefinition(null)) != null) {
                    String esName = cEnt.getEntityShape().fetchObjectDefinitionName();
                    boolean corr = "listLookupCorrelatedValues".equals(esName);
                    boolean lookup = "listLookupValues".equals(esName);
                    if ("localizedTable".equals(esName) || lookup || corr) {
                        ArrayList result = new ArrayList();
                        List<List<String>> rawValues = cEnt.getConstantValues();
                        if (rawValues != null) {
                            for (List<String> rawValue : rawValues) {
                                LinkedHashMap<String, String> row = new LinkedHashMap<String, String>();
                                if (rawValue.size() == 2 || lookup && rawValue.size() == 4 || corr && rawValue.size() == 5) {
                                    row.put("languageTag", rawValue.get(0));
                                    row.put("displayText", rawValue.get(1));
                                    if (lookup || corr) {
                                        row.put("attributeValue", rawValue.get(2));
                                        row.put("displayOrder", rawValue.get(3));
                                        if (corr) {
                                            row.put("correlatedValue", rawValue.get(4));
                                        }
                                    }
                                }
                                result.add(row);
                            }
                        }
                        return result;
                    }
                    defVal = cdmObjectDefVal.copyData(null, null);
                }
            }
            return defVal;
        }
        return null;
    }

    private Enum mapTraitName(CdmPropertyName propertyName) {
        switch (propertyName) {
            case VERSION: {
                return CdmTraitName.VERSION;
            }
            case CDM_SCHEMAS: {
                return CdmTraitName.ATTRIBUTE_GROUP;
            }
            case SOURCE_NAME: {
                return CdmTraitName.SOURCE_NAME;
            }
            case DISPLAY_NAME: {
                return CdmTraitName.DISPLAY_NAME;
            }
            case DESCRIPTION: {
                return CdmTraitName.DESCRIPTION;
            }
            case SOURCE_ORDERING: {
                return CdmTraitName.SOURCE_ORDERING;
            }
            case PRIMARY_KEY: {
                return CdmTraitName.IS_IDENTIFIED_BY;
            }
            case IS_READ_ONLY: {
                return CdmTraitName.IS_READ_ONLY;
            }
            case IS_NULLABLE: {
                return CdmTraitName.IS_NULLABLE;
            }
            case VALUE_CONSTRAINED_TO_LIST: {
                return CdmTraitName.VALUE_CONSTRAINED_TO_LIST;
            }
            case MAXIMUM_VALUE: 
            case MINIMUM_VALUE: 
            case MAXIMUM_LENGTH: {
                return CdmTraitName.IS_CONSTRAINED;
            }
        }
        return propertyName;
    }

    private CdmConstantEntityDefinition fetchTraitTable(String traitName, String argName, boolean onlyFromProperty) {
        int traitIndex = this.getTraits().indexOf(traitName, onlyFromProperty);
        CdmTraitReference trait = traitIndex == -1 ? null : (CdmTraitReference)this.getTraits().get(traitIndex);
        Object locEntRef = TraitToPropertyMap.fetchTraitReferenceArgumentValue(trait, argName);
        if (locEntRef != null) {
            return (CdmConstantEntityDefinition)((CdmObject)locEntRef).fetchObjectDefinition(null);
        }
        return null;
    }

    private void removeTrait(String traitName) {
        this.getTraits().remove(traitName, true);
    }

    private void mapBooleanTrait(String traitName, boolean value) {
        if (value) {
            this.fetchOrCreateTrait(traitName, true);
        } else {
            this.removeTrait(traitName);
        }
    }

    private void updateSingleAttributeTraitTable(String traitName, String argName, String entityName, List<String> sourceText) {
        this.updateTraitTable(traitName, argName, entityName, (cEnt, created) -> {
            ArrayList<List<String>> vals = new ArrayList<List<String>>();
            for (String v : sourceText) {
                ArrayList<String> r = new ArrayList<String>();
                r.add(v);
                vals.add(r);
            }
            cEnt.setConstantValues(vals);
        });
    }

    private void updateTraitArgument(String traitName, String argName, Object argValue) {
        CdmTraitReference trait = this.fetchOrCreateTrait(traitName, false);
        CdmArgumentCollection args = trait.getArguments();
        if (args == null || args.getCount() == 0) {
            if (argValue != null) {
                trait.getArguments().add(argName, argValue);
                return;
            }
            this.removeTrait(traitName);
        } else {
            for (int iArg = 0; iArg < args.getCount(); ++iArg) {
                CdmArgumentDefinition arg = (CdmArgumentDefinition)args.getAllItems().get(iArg);
                if (!arg.getName().equals(argName)) continue;
                if (argValue == null) {
                    args.remove(arg);
                    if (trait != null && trait.getArguments() != null && trait.getArguments().size() == 0) {
                        this.removeTrait(traitName);
                    }
                } else {
                    arg.setValue(argValue);
                }
                return;
            }
        }
        if (argValue != null) {
            trait.getArguments().add(argName, argValue);
        }
    }

    String traitsToDataFormat(boolean onlyFromProperty) {
        boolean isArray = false;
        boolean isBig = false;
        boolean isSmall = false;
        boolean isInteger = false;
        boolean probablyJson = false;
        CdmDataFormat baseType = CdmDataFormat.Unknown;
        CdmTraitCollection traits = this.getTraits();
        if (traits != null) {
            for (CdmTraitReferenceBase trait : traits) {
                String traitName;
                if (onlyFromProperty && (trait instanceof CdmTraitGroupReference || !((CdmTraitReference)trait).isFromProperty()) || (traitName = trait.fetchObjectDefinitionName()) == null) continue;
                switch (CdmDataFormatTrait.fromString(traitName)) {
                    case ARRAY: {
                        isArray = true;
                        break;
                    }
                    case BIG: {
                        isBig = true;
                        break;
                    }
                    case SMALL: {
                        isSmall = true;
                        break;
                    }
                    case INTEGER: {
                        isInteger = true;
                        break;
                    }
                    case FLOATING_POINT: {
                        baseType = CdmDataFormat.Float;
                        break;
                    }
                    case CHARACTER: {
                        if (CdmDataFormat.Guid.equals((Object)baseType)) break;
                        baseType = CdmDataFormat.Char;
                        break;
                    }
                    case BYTE: {
                        baseType = CdmDataFormat.Byte;
                        break;
                    }
                    case DATE: {
                        if (CdmDataFormat.Time.equals((Object)baseType)) {
                            baseType = CdmDataFormat.DateTime;
                            break;
                        }
                        baseType = CdmDataFormat.Date;
                        break;
                    }
                    case TIME: {
                        if (CdmDataFormat.Date.equals((Object)baseType)) {
                            baseType = CdmDataFormat.DateTime;
                            break;
                        }
                        baseType = CdmDataFormat.Time;
                        break;
                    }
                    case DATETIME_OFFSET: {
                        if (!CdmDataFormat.DateTime.equals((Object)baseType)) break;
                        baseType = CdmDataFormat.DateTimeOffset;
                        break;
                    }
                    case BOOLEAN: {
                        baseType = CdmDataFormat.Boolean;
                        break;
                    }
                    case NUMERIC_SHAPED: {
                        baseType = CdmDataFormat.Decimal;
                        break;
                    }
                    case GUID: {
                        baseType = CdmDataFormat.Guid;
                        break;
                    }
                    case JSON: {
                        baseType = isArray ? CdmDataFormat.Json : CdmDataFormat.Unknown;
                        probablyJson = true;
                        break;
                    }
                }
            }
            if (isArray) {
                if (probablyJson) {
                    baseType = CdmDataFormat.Json;
                } else if (CdmDataFormat.Char.equals((Object)baseType)) {
                    baseType = CdmDataFormat.String;
                } else if (CdmDataFormat.Byte.equals((Object)baseType)) {
                    baseType = CdmDataFormat.Binary;
                } else if (!CdmDataFormat.Guid.equals((Object)baseType)) {
                    baseType = CdmDataFormat.Unknown;
                }
            }
            if (CdmDataFormat.Float.equals((Object)baseType) && isBig) {
                baseType = CdmDataFormat.Double;
            }
            if (isInteger && isBig) {
                baseType = CdmDataFormat.Int64;
            } else if (isInteger && isSmall) {
                baseType = CdmDataFormat.Int16;
            } else if (isInteger) {
                baseType = CdmDataFormat.Int32;
            }
        }
        return baseType.name();
    }

    private void updateTraitTable(String traitName, String argName, String entityName, BiConsumer<CdmConstantEntityDefinition, Boolean> action) {
        CdmTraitReference trait = this.fetchOrCreateTrait(traitName, false);
        CdmTraitReference traitRef = trait;
        if (traitRef.getArguments() == null || traitRef.getArguments().getCount() == 0) {
            CdmConstantEntityDefinition cEnt = (CdmConstantEntityDefinition)this.getCtx().getCorpus().makeObject(CdmObjectType.ConstantEntityDef, null, false);
            cEnt.setEntityShape((CdmEntityReference)this.getCtx().getCorpus().makeRef(CdmObjectType.EntityRef, entityName, true));
            action.accept(cEnt, true);
            traitRef.getArguments().add(argName, this.getCtx().getCorpus().makeRef(CdmObjectType.EntityRef, cEnt, false));
        } else {
            Object locEntRef = TraitToPropertyMap.fetchTraitReferenceArgumentValue(trait, argName);
            if (locEntRef != null) {
                CdmConstantEntityDefinition locEnt;
                CdmConstantEntityDefinition cdmConstantEntityDefinition = locEnt = locEntRef instanceof CdmObjectBase ? (CdmConstantEntityDefinition)((CdmObjectBase)locEntRef).fetchObjectDefinition(null) : null;
                if (locEnt != null) {
                    action.accept(locEnt, false);
                }
            }
        }
    }

    private CdmObject getHost() {
        return this.host;
    }

    private void setHost(CdmObject host) {
        this.host = host;
    }

    private CdmTraitCollection getTraits() {
        if (this.host instanceof CdmObjectReference) {
            return ((CdmObjectReference)this.host).getAppliedTraits();
        }
        if (this.host instanceof CdmAttribute) {
            return ((CdmAttribute)this.host).getAppliedTraits();
        }
        return ((CdmObjectDefinition)this.host).getExhibitsTraits();
    }

    private CdmCorpusContext getCtx() {
        return this.host.getCtx();
    }

    private void updateDefaultValue(Object newDefault) {
        if (newDefault instanceof ArrayNode) {
            ArrayNode array = (ArrayNode)newDefault;
            int l = array.size();
            if (l > 0 && array.get(0).get("languageTag") != null && array.get(0).get("displayText") != null) {
                ArrayList<List<String>> tab = new ArrayList<List<String>>();
                boolean corr = array.get(0).get("correlatedValue") != null;
                for (int i = 0; i < l; ++i) {
                    ArrayList<String> row = new ArrayList<String>();
                    row.add(TraitToPropertyMap.asText(array.get(i).get("languageTag")));
                    row.add(TraitToPropertyMap.asText(array.get(i).get("displayText")));
                    row.add(TraitToPropertyMap.asText(array.get(i).get("attributeValue")));
                    row.add(TraitToPropertyMap.asText(array.get(i).get("displayOrder")));
                    if (corr) {
                        row.add(TraitToPropertyMap.asText(array.get(i).get("correlatedValue")));
                    }
                    tab.add(row);
                }
                CdmConstantEntityDefinition cEnt = (CdmConstantEntityDefinition)this.getCtx().getCorpus().makeObject(CdmObjectType.ConstantEntityDef, null, false);
                cEnt.setEntityShape((CdmEntityReference)this.getCtx().getCorpus().makeObject(CdmObjectType.EntityRef, corr ? "listLookupCorrelatedValues" : "listLookupValues", true));
                cEnt.setConstantValues(tab);
                newDefault = this.getCtx().getCorpus().makeRef(CdmObjectType.EntityRef, cEnt, false);
                this.updateTraitArgument(CdmTraitName.DOES_HAVE_DEFAULT.toString(), "default", newDefault);
            } else {
                Logger.error(this.host.getCtx(), TAG, "updateDefaultValue", null, CdmLogCode.ErrValdnMissingLanguageTag, new String[0]);
            }
        } else {
            Logger.error(this.host.getCtx(), TAG, "updateDefaultValue", null, CdmLogCode.ErrUnsupportedType, new String[0]);
        }
    }

    private static Object fetchTraitReferenceArgumentValue(Object traitRef, String argName) {
        if (traitRef instanceof ResolvedTrait) {
            return TraitToPropertyMap.fetchTraitReferenceArgumentValue((ResolvedTrait)traitRef, argName);
        }
        if (traitRef instanceof CdmTraitReference) {
            return TraitToPropertyMap.fetchTraitReferenceArgumentValue((CdmTraitReference)traitRef, argName);
        }
        return null;
    }

    private static Object fetchTraitReferenceArgumentValue(ResolvedTrait traitRef, String argName) {
        return traitRef == null ? null : traitRef.getParameterValues().fetchParameterValue(argName).getValue();
    }

    private static Object fetchTraitReferenceArgumentValue(CdmTraitReference traitRef, String argName) {
        return traitRef == null ? null : traitRef.getArguments().fetchValue(argName);
    }

    static {
        TRAIT_TO_LIST_OF_PROPERTIES_MAP.put(CdmTraitName.VERSION, Collections.singletonList(CdmPropertyName.VERSION));
        TRAIT_TO_LIST_OF_PROPERTIES_MAP.put(CdmTraitName.ATTRIBUTE_GROUP, Collections.singletonList(CdmPropertyName.CDM_SCHEMAS));
        TRAIT_TO_LIST_OF_PROPERTIES_MAP.put(CdmTraitName.SOURCE_NAME, Collections.singletonList(CdmPropertyName.SOURCE_NAME));
        TRAIT_TO_LIST_OF_PROPERTIES_MAP.put(CdmTraitName.DISPLAY_NAME, Collections.singletonList(CdmPropertyName.DISPLAY_NAME));
        TRAIT_TO_LIST_OF_PROPERTIES_MAP.put(CdmTraitName.DESCRIPTION, Collections.singletonList(CdmPropertyName.DESCRIPTION));
        TRAIT_TO_LIST_OF_PROPERTIES_MAP.put(CdmTraitName.SOURCE_ORDERING, Collections.singletonList(CdmPropertyName.SOURCE_ORDERING));
        TRAIT_TO_LIST_OF_PROPERTIES_MAP.put(CdmTraitName.IS_READ_ONLY, Collections.singletonList(CdmPropertyName.IS_READ_ONLY));
        TRAIT_TO_LIST_OF_PROPERTIES_MAP.put(CdmTraitName.IS_NULLABLE, Collections.singletonList(CdmPropertyName.IS_NULLABLE));
        TRAIT_TO_LIST_OF_PROPERTIES_MAP.put(CdmTraitName.VALUE_CONSTRAINED_TO_LIST, Collections.singletonList(CdmPropertyName.VALUE_CONSTRAINED_TO_LIST));
        TRAIT_TO_LIST_OF_PROPERTIES_MAP.put(CdmTraitName.IS_CONSTRAINED, Arrays.asList(CdmPropertyName.MAXIMUM_VALUE, CdmPropertyName.MINIMUM_VALUE, CdmPropertyName.MAXIMUM_LENGTH));
    }
}

